/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.diagram;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.awt.KeyTool;
import com.elixirtech.awt.KeyboardInterface;
import com.elixirtech.canvas.corego.Diagram;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.corego.GOExtras;
import com.elixirtech.canvas.diagram.DiagramKeyTool;
import com.elixirtech.canvas.diagram.ICanvas;
import com.elixirtech.canvas.diagram.ICanvasContext;
import com.elixirtech.canvas.diagram.MouseManager;
import com.elixirtech.canvas.diagram.MouseTool;
import com.elixirtech.canvas.diagram.SelectionManager;
import com.elixirtech.canvas.extras.DiagramExtras;
import com.elixirtech.canvas.extras.DiagramWrapper;
import com.elixirtech.canvas.geometry.RectangleEx;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JViewport;

public class DiagramCanvas
extends JComponent
implements ICanvas {
    protected DiagramWrapper m_DiagramWrapper;
    protected KeyboardInterface m_KeyboardInterface;
    protected DiagramKeyTool m_KeyTool;
    protected MouseManager m_MML = new MouseManager(this);
    protected ICanvasContext m_CanvasContext;

    public DiagramCanvas() {
        this.m_KeyTool = new DiagramKeyTool();
        this.m_KeyTool.setCanvas(this);
        this.m_KeyboardInterface = new KeyboardInterface(this);
    }

    public DiagramCanvas(DiagramKeyTool diagramKeyTool) {
        this.m_KeyTool = diagramKeyTool;
        this.m_KeyTool.setCanvas(this);
        this.m_KeyboardInterface = new KeyboardInterface(this);
    }

    public DiagramCanvas(Diagram diagram) {
        this();
        this.setDiagram(diagram);
    }

    public DiagramCanvas(DiagramKeyTool diagramKeyTool, Diagram diagram) {
        this(diagramKeyTool);
        this.setDiagram(diagram);
    }

    public void setKeyTool(DiagramKeyTool diagramKeyTool) {
        this.m_KeyTool = diagramKeyTool;
    }

    @Override
    public KeyboardInterface getKeyboardInterface() {
        return this.m_KeyboardInterface;
    }

    @Override
    public void setCanvasContext(ICanvasContext iCanvasContext) {
        this.m_CanvasContext = iCanvasContext;
        if (this.m_CanvasContext != null && this.m_DiagramWrapper != null) {
            this.m_CanvasContext.diagramOpened();
        }
    }

    @Override
    public ICanvasContext getCanvasContext() {
        return this.m_CanvasContext;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void refresh() {
        Dimension dimension = this.m_DiagramWrapper.getDiagramSize();
        int n = this.m_DiagramWrapper.getZoomPercent();
        this.m_MML.setZoomPercent(n);
        dimension.width = (int)((double)dimension.width * ((double)n / 100.0));
        dimension.height = (int)((double)dimension.height * ((double)n / 100.0));
        this.setPreferredSize(dimension);
        this.revalidate();
        this.repaint();
        this.m_CanvasContext.diagramChanged(7);
    }

    @Override
    public void refresh(int n) {
        if ((n & 2) != 0) {
            Dimension dimension = this.m_DiagramWrapper.getDiagramSize();
            int n2 = this.m_DiagramWrapper.getZoomPercent();
            this.m_MML.setZoomPercent(n2);
            dimension.width = (int)((double)dimension.width * ((double)n2 / 100.0));
            dimension.height = (int)((double)dimension.height * ((double)n2 / 100.0));
            this.setPreferredSize(dimension);
            this.revalidate();
            this.repaint();
        }
        this.m_CanvasContext.diagramChanged(n);
    }

    @Override
    public SelectionManager getSelectionManager() {
        if (this.m_DiagramWrapper != null) {
            return this.m_DiagramWrapper.getSelectionManager();
        }
        return null;
    }

    @Override
    public final void setDiagram(Diagram diagram) {
        if (this.m_DiagramWrapper == null || this.m_DiagramWrapper.d() != diagram) {
            if (this.m_DiagramWrapper != null) {
                this.m_DiagramWrapper.setCanvas(null);
            }
            this.m_DiagramWrapper = DiagramExtras.getWrapper(diagram);
            this.m_DiagramWrapper.setCanvas(this);
            this.getSelectionManager().removeAllSelections();
            this.setScrollPosition(new Point(0, 0));
            this.setPreferredSize(this.m_DiagramWrapper.getDiagramSize());
            this.repaint();
            if (this.m_CanvasContext != null) {
                this.m_CanvasContext.diagramOpened();
            }
        }
    }

    @Override
    public void setDiagram(Diagram diagram, Point point) {
        if (this.m_DiagramWrapper.d() == diagram) {
            this.setScrollPosition(point);
        } else {
            if (this.m_DiagramWrapper != null) {
                this.m_DiagramWrapper.setCanvas(null);
            }
            this.m_DiagramWrapper = DiagramExtras.getWrapper(diagram);
            this.m_DiagramWrapper.setCanvas(this);
            this.getSelectionManager().removeAllSelections();
            this.setPreferredSize(this.m_DiagramWrapper.getDiagramSize());
            this.setScrollPosition(point);
            this.repaint();
            if (this.m_CanvasContext != null) {
                this.m_CanvasContext.diagramOpened();
            }
        }
    }

    @Override
    public final void setScrollPosition(Point point) {
        JViewport jViewport = (JViewport)this.getParent();
        if (jViewport != null) {
            this.m_DiagramWrapper.zoomPoint(point);
            Dimension dimension = jViewport.getSize();
            Dimension dimension2 = this.getSize();
            if (point.x + dimension.width > dimension2.width) {
                point.x = dimension2.width - dimension.width;
            }
            if (point.y + dimension.height > dimension2.height) {
                point.y = dimension2.height - dimension.height;
            }
            this.scrollRectToVisible(new Rectangle(point.x, point.y, dimension.width, dimension.height));
        }
    }

    @Override
    public Point getScrollPosition() {
        Point point = ((JViewport)this.getParent()).getViewPosition();
        int n = this.m_DiagramWrapper.getZoomPercent();
        return new Point(point.x * 100 / n, point.y * 100 / n);
    }

    @Override
    public void setTool(MouseTool mouseTool) {
        if (mouseTool != null) {
            this.m_MML.setCurrentTool(mouseTool);
        }
    }

    @Override
    public Diagram getDiagram() {
        return this.m_DiagramWrapper.d();
    }

    @Override
    public DiagramWrapper getWrappedDiagram() {
        return this.m_DiagramWrapper;
    }

    @Override
    public KeyTool getKeyTool() {
        return this.m_KeyTool;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        try {
            if (this.m_DiagramWrapper != null) {
                double d = (double)this.m_DiagramWrapper.getZoomPercent() / 100.0;
                ((Graphics2D)graphics).scale(d, d);
                this.m_DiagramWrapper.draw(graphics);
            }
        }
        catch (Throwable throwable) {
            ElxLoggerJ.getLogger(DiagramCanvas.class).error((Object)("Paint error " + String.valueOf(throwable)), throwable);
        }
    }

    @Override
    public Graphics getGraphics() {
        Graphics graphics = super.getGraphics();
        double d = (double)this.m_DiagramWrapper.getZoomPercent() / 100.0;
        ((Graphics2D)graphics).scale(d, d);
        return graphics;
    }

    @Override
    public void drawShape(GO gO) {
        RectangleEx rectangleEx = GOExtras.getPaintRect(gO);
        this.drawRect(rectangleEx.left, rectangleEx.top, rectangleEx.width(), rectangleEx.height());
    }

    @Override
    public void drawShapes() {
        Rectangle rectangle = this.getBounds();
        this.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        double d = (double)this.m_DiagramWrapper.getZoomPercent() / 100.0;
        int n5 = (int)((double)n * d);
        int n6 = (int)((double)n2 * d);
        int n7 = (int)((double)n3 * d);
        int n8 = (int)((double)n4 * d);
        this.repaint(0L, n5 - 1, n6 - 1, n7 + 2, n8 + 2);
    }
}

