/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.diagram;

import com.elixirtech.awt.KeyTool;
import com.elixirtech.canvas.commands.DeleteCmd;
import com.elixirtech.canvas.commands.SelectAllCmd;
import com.elixirtech.canvas.corego.Diagram;
import com.elixirtech.canvas.diagram.ICanvas;
import com.elixirtech.canvas.diagram.SelectionManager;
import com.elixirtech.canvas.extras.DiagramExtras;
import com.elixirtech.canvas.geometry.RectangleEx;
import com.elixirtech.canvas.xml.XmlExtras;
import com.elixirtech.command.CommandManager;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;

public class DiagramKeyTool
extends KeyTool {
    private ICanvas m_Canvas;

    public void setCanvas(ICanvas iCanvas) {
        this.m_Canvas = iCanvas;
    }

    public void keyPressed(KeyEvent keyEvent) {
        Diagram diagram = this.m_Canvas.getDiagram();
        if (!DiagramExtras.getWrapper(diagram).isEditable()) {
            return;
        }
        SelectionManager selectionManager = this.getSelectionManager();
        if (selectionManager.getSelections().length > 0) {
            Dimension dimension = DiagramExtras.getDiagramSize();
            int n = keyEvent.getKeyCode();
            if (n == 37 || n == 39 || n == 38 || n == 40) {
                int n2 = 0;
                int n3 = 0;
                RectangleEx rectangleEx = selectionManager.getSelectionRect();
                if (keyEvent.isAltDown()) {
                    switch (n) {
                        case 37: {
                            n2 = -1;
                            break;
                        }
                        case 39: {
                            n2 = 1;
                            break;
                        }
                        case 38: {
                            n3 = -1;
                            break;
                        }
                        case 40: {
                            n3 = 1;
                        }
                    }
                } else {
                    int n4 = rectangleEx.left % 10;
                    int n5 = rectangleEx.top % 10;
                    switch (n) {
                        case 37: {
                            if (rectangleEx.left >= 10) {
                                if (n4 == 0) {
                                    n2 = -10;
                                    break;
                                }
                                n2 = -n4;
                                break;
                            }
                            n2 = -rectangleEx.left;
                            break;
                        }
                        case 39: {
                            if (rectangleEx.right > dimension.width - 10) break;
                            n2 = 10 - n4;
                            break;
                        }
                        case 38: {
                            if (rectangleEx.top >= 10) {
                                if (n5 == 0) {
                                    n3 = -10;
                                    break;
                                }
                                n3 = -n5;
                                break;
                            }
                            n3 = -rectangleEx.top;
                            break;
                        }
                        case 40: {
                            if (rectangleEx.top > dimension.height - 10) break;
                            n3 = 10 - n5;
                        }
                    }
                }
                if (n2 != 0 || n3 != 0) {
                    RectangleEx rectangleEx2 = selectionManager.getSelectionPaintRect();
                    selectionManager.moveSelections(n2, n3);
                    RectangleEx rectangleEx3 = selectionManager.getSelectionPaintRect();
                    RectangleEx rectangleEx4 = rectangleEx2.union(rectangleEx3);
                    this.m_Canvas.drawRect(rectangleEx4.left, rectangleEx4.top, rectangleEx4.width(), rectangleEx4.height());
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        Diagram diagram = this.m_Canvas.getDiagram();
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 127: {
                this.delete(diagram);
                break;
            }
            case 90: {
                if ((keyEvent.getModifiers() & 2) == 0) break;
                this.undo(diagram);
                break;
            }
            case 89: {
                if ((keyEvent.getModifiers() & 2) == 0) break;
                this.redo(diagram);
                break;
            }
            case 67: {
                if ((keyEvent.getModifiers() & 2) == 0) break;
                this.copy(diagram);
                break;
            }
            case 88: {
                if ((keyEvent.getModifiers() & 2) == 0) break;
                this.cut(diagram);
                break;
            }
            case 86: {
                if ((keyEvent.getModifiers() & 2) == 0) break;
                this.paste(diagram);
                break;
            }
            case 65: {
                if ((keyEvent.getModifiers() & 2) == 0) break;
                this.selectAll(diagram);
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void selectAll(Diagram diagram) {
        try {
            SelectAllCmd selectAllCmd = new SelectAllCmd(DiagramExtras.getWrapper(diagram).getCanvas());
            DiagramExtras.getWrapper(diagram).doCommand(selectAllCmd);
        }
        catch (Exception exception) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    protected void cut(Diagram diagram) {
        if (DiagramExtras.getWrapper(diagram).isEditable()) {
            try {
                XmlExtras.cutToClipboard(diagram);
            }
            catch (Exception exception) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    protected void copy(Diagram diagram) {
        if (DiagramExtras.getWrapper(diagram).isEditable()) {
            try {
                XmlExtras.copyToClipboard(diagram);
            }
            catch (Exception exception) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    protected void paste(Diagram diagram) {
        if (DiagramExtras.getWrapper(diagram).isEditable()) {
            try {
                XmlExtras.pasteFromClipboard(diagram);
            }
            catch (Exception exception) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    protected void delete(Diagram diagram) {
        if (DiagramExtras.getWrapper(diagram).isEditable() && this.getSelectionManager().getSelections().length > 0) {
            DeleteCmd deleteCmd = new DeleteCmd(this.m_Canvas);
            DiagramExtras.getWrapper(diagram).doCommand(deleteCmd);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    protected void undo(Diagram diagram) {
        if (DiagramExtras.getWrapper(diagram).isEditable()) {
            CommandManager commandManager = this.getCommandManager();
            if (commandManager.canUndo()) {
                commandManager.undo();
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    protected void redo(Diagram diagram) {
        if (DiagramExtras.getWrapper(diagram).isEditable()) {
            CommandManager commandManager = this.getCommandManager();
            if (commandManager.canRedo()) {
                commandManager.redo();
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    protected SelectionManager getSelectionManager() {
        return this.m_Canvas.getSelectionManager();
    }

    protected CommandManager getCommandManager() {
        return DiagramExtras.getWrapper(this.m_Canvas.getDiagram()).getCommandManager();
    }
}

