/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.diagram;

import com.elixirtech.canvas.corego.Diagram;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.corego.GOExtras;
import com.elixirtech.canvas.corego.Handle;
import com.elixirtech.canvas.corego.IParentGO;
import com.elixirtech.canvas.diagram.SelectionEvent;
import com.elixirtech.canvas.diagram.SelectionListener;
import com.elixirtech.canvas.diagram.SelectionManager;
import com.elixirtech.canvas.extras.DiagramWrapper;
import com.elixirtech.canvas.geometry.RectangleEx;
import com.elixirtech.canvas.graph.Node;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DiagramSelectionManager
implements SelectionManager {
    protected Diagram m_Diagram;
    protected DiagramWrapper m_DiagramWrapper;
    protected List<GO> m_Selections = new LinkedList<GO>();
    protected List<SelectionListener> m_SelectionListeners = new ArrayList<SelectionListener>();
    protected List<RectangleEx> m_Damages = new ArrayList<RectangleEx>();
    protected List<Handle> m_Handles = new ArrayList<Handle>();
    private static final Stroke THIN_STROKE = new BasicStroke(0.0f);

    public DiagramSelectionManager(DiagramWrapper diagramWrapper) {
        this.m_DiagramWrapper = diagramWrapper;
        this.m_Diagram = diagramWrapper.d();
        this.buildSelectionCache();
    }

    @Override
    public void select(RectangleEx rectangleEx) {
        this.damage(this.getSelectionRect().grow(Handle.HANDLESZ()));
        this.m_Selections.clear();
        List<Node> list = this.m_DiagramWrapper.shapesInRect(rectangleEx);
        for (GO gO : list) {
            this.m_Selections.add(gO);
            this.damage(GOExtras.getPaintRect(gO).grow(Handle.HANDLESZ()));
        }
        this.buildSelectionCache();
        this.repaintCanvas();
        this.notifySelectionChanged();
    }

    @Override
    public void shiftSelect(RectangleEx rectangleEx) {
        List<Node> list = this.m_DiagramWrapper.shapesInRect(rectangleEx);
        for (GO gO : list) {
            if (this.m_Selections.contains(gO)) {
                this.m_Selections.remove(gO);
            } else {
                this.m_Selections.add(gO);
            }
            this.damage(GOExtras.getPaintRect(gO).grow(Handle.HANDLESZ()));
        }
        this.buildSelectionCache();
        this.repaintCanvas();
        this.notifySelectionChanged();
    }

    @Override
    public RectangleEx getSelectionRect() {
        Iterator<GO> iterator = this.m_Selections.iterator();
        if (iterator.hasNext()) {
            GO gO = iterator.next();
            RectangleEx rectangleEx = GOExtras.getPaintRect(gO);
            while (iterator.hasNext()) {
                gO = iterator.next();
                rectangleEx = rectangleEx.union(GOExtras.getPaintRect(gO));
            }
            return rectangleEx;
        }
        return new RectangleEx(0, 0, 0, 0);
    }

    @Override
    public RectangleEx getSelectionPaintRect() {
        Iterator<GO> iterator = this.m_Selections.iterator();
        if (iterator.hasNext()) {
            GO gO = iterator.next();
            RectangleEx rectangleEx = GOExtras.getRepaintsRect(gO);
            while (iterator.hasNext()) {
                gO = iterator.next();
                rectangleEx = rectangleEx.union(GOExtras.getRepaintsRect(gO));
            }
            return rectangleEx.grow(Handle.HANDLESZ());
        }
        return new RectangleEx(0, 0, 0, 0);
    }

    @Override
    public RectangleEx getSelectionContainer() {
        ArrayList<IParentGO> arrayList = new ArrayList<IParentGO>();
        for (GO gO : this.m_Selections) {
            IParentGO iParentGO = gO.getParentGO();
            if (!arrayList.contains(iParentGO)) {
                arrayList.add(iParentGO);
            }
            if (arrayList.size() <= 1) continue;
            return new RectangleEx(new Point(0, 0), this.m_DiagramWrapper.getDiagramSize());
        }
        IParentGO iParentGO = (IParentGO)arrayList.get(0);
        return (RectangleEx)GOExtras.getChildRect(iParentGO).clone();
    }

    @Override
    public void moveSelections(int n, int n2) {
        for (GO gO : this.m_Selections) {
            if (this.isParentSelected(gO)) continue;
            GOExtras.move(gO, n, n2);
        }
    }

    @Override
    public boolean isSelected(GO gO) {
        return this.m_Selections.contains(gO);
    }

    @Override
    public void addSelection(GO gO) {
        if (!this.m_Selections.contains(gO)) {
            this.damage(this.getSelectionRect().grow(Handle.HANDLESZ()));
            this.m_Selections.add(gO);
            this.buildSelectionCache();
            this.damage(this.getSelectionRect().grow(Handle.HANDLESZ()));
            this.repaintCanvas();
            this.notifySelectionChanged();
        }
    }

    @Override
    public void setSelection(GO gO) {
        this.damage(this.getSelectionRect().grow(Handle.HANDLESZ()));
        this.m_Selections.clear();
        this.m_Selections.add(gO);
        this.buildSelectionCache();
        this.damage(this.getSelectionRect().grow(Handle.HANDLESZ()));
        this.repaintCanvas();
        this.notifySelectionChanged();
    }

    @Override
    public void setSelections(GO[] gOArray) {
        this.damage(this.getSelectionRect().grow(Handle.HANDLESZ()));
        this.m_Selections.clear();
        for (int i = 0; i < gOArray.length; ++i) {
            this.m_Selections.add(gOArray[i]);
        }
        this.buildSelectionCache();
        this.damage(this.getSelectionRect().grow(Handle.HANDLESZ()));
        this.repaintCanvas();
        this.notifySelectionChanged();
    }

    @Override
    public void removeSelection(GO gO) {
        this.damage(this.getSelectionRect().grow(Handle.HANDLESZ()));
        this.m_Selections.remove(gO);
        this.buildSelectionCache();
        this.repaintCanvas();
        this.notifySelectionChanged();
    }

    @Override
    public void removeAllSelections() {
        if (this.m_Selections.size() > 0) {
            this.damage(this.getSelectionRect().grow(Handle.HANDLESZ()));
            this.m_Selections.clear();
            this.buildSelectionCache();
            this.repaintCanvas();
            this.notifySelectionChanged();
        }
    }

    @Override
    public Handle handleAtPoint(Point point) {
        if (this.m_Handles == null) {
            return null;
        }
        for (Handle handle : this.m_Handles) {
            if (!handle.contains(point)) continue;
            return handle;
        }
        return null;
    }

    @Override
    public synchronized void addSelectionListener(SelectionListener selectionListener) {
        this.m_SelectionListeners.add(selectionListener);
    }

    @Override
    public synchronized void removeSelectionListener(SelectionListener selectionListener) {
        this.m_SelectionListeners.remove(selectionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySelectionChanged() {
        ArrayList<SelectionListener> arrayList;
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList<SelectionListener>(this.m_SelectionListeners);
        }
        object = new SelectionEvent(this);
        for (SelectionListener selectionListener : arrayList) {
            selectionListener.selectionChanged((SelectionEvent)object);
        }
    }

    protected boolean isParentSelected(GO gO) {
        IParentGO iParentGO = gO.getParentGO();
        if (iParentGO != null) {
            if (this.m_Selections.contains(iParentGO)) {
                return true;
            }
            if (iParentGO instanceof GO) {
                return this.isParentSelected((GO)iParentGO);
            }
        }
        return false;
    }

    @Override
    public GO[] getSelections() {
        GO[] gOArray = new GO[this.m_Selections.size()];
        this.m_Selections.toArray(gOArray);
        return gOArray;
    }

    public List<Handle> getHandles() {
        return Collections.unmodifiableList(this.m_Handles);
    }

    @Override
    public final void buildSelectionCache() {
        boolean bl = this.m_DiagramWrapper.isEditable();
        this.m_Handles = new ArrayList<Handle>();
        for (GO gO : this.m_Selections) {
            this.m_Handles.addAll(GOExtras.handlesJ(gO, bl));
        }
    }

    protected void damage(RectangleEx rectangleEx) {
        this.m_Damages.add(rectangleEx);
    }

    public void repaintCanvas() {
        for (RectangleEx rectangleEx : this.m_Damages) {
            this.repaintCanvas(rectangleEx);
        }
        this.m_Damages.clear();
    }

    protected void repaintCanvas(RectangleEx rectangleEx) {
        this.m_DiagramWrapper.drawRect(rectangleEx.left, rectangleEx.top, rectangleEx.width(), rectangleEx.height());
    }

    @Override
    public void drawHandles(Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(THIN_STROKE);
        Rectangle rectangle = graphics2D.getClipBounds();
        RectangleEx rectangleEx = new RectangleEx(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        for (Handle handle : this.m_Handles) {
            if (!rectangleEx.intersects(handle.getPaintRect())) continue;
            handle.draw(graphics2D);
        }
        graphics2D.setStroke(stroke);
    }
}

