/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.diagram;

import com.elixirtech.canvas.commands.HandleCmd;
import com.elixirtech.canvas.corego.Diagram;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.corego.GOExtras;
import com.elixirtech.canvas.corego.Handle;
import com.elixirtech.canvas.diagram.ICanvas;
import com.elixirtech.canvas.diagram.MouseTool;
import com.elixirtech.canvas.extras.DiagramExtras;
import com.elixirtech.canvas.geometry.RectangleEx;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;

class HandleTracker
extends MouseTool {
    private Handle m_Handle;
    private GO m_GO;
    private Point m_HandleOffset;
    private ICanvas m_Canvas;
    private Dimension m_Grid;
    private Point m_OriginalPoint;
    private RectangleEx m_OriginalRect;
    private boolean m_IsDragged;

    public HandleTracker(Handle handle) {
        this.m_Handle = handle;
        this.m_GO = this.m_Handle.getOwner().getGO();
        Diagram diagram = this.m_GO.getDiagram();
        this.m_Canvas = DiagramExtras.getWrapper(diagram).getCanvas();
        this.m_Grid = DiagramExtras.getGridSize();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.m_Handle.mouseDragged(mouseEvent);
        if (this.m_Handle.isMoveable()) {
            Point point = this.snapToGrid(mouseEvent.getPoint());
            Point point2 = new Point(point.x + this.m_HandleOffset.x, point.y + this.m_HandleOffset.y);
            RectangleEx rectangleEx = GOExtras.getRepaintsRect(this.m_GO).grow(Handle.HANDLESZ());
            Point point3 = this.m_Handle.getPoint();
            this.m_Handle.setPoint(point2);
            Point point4 = this.m_Handle.getPoint();
            if (!point3.equals(point4)) {
                RectangleEx rectangleEx2 = GOExtras.getRepaintsRect(this.m_GO).grow(Handle.HANDLESZ());
                RectangleEx rectangleEx3 = rectangleEx.union(rectangleEx2);
                this.m_Canvas.drawRect(rectangleEx3.left, rectangleEx3.top, rectangleEx3.width(), rectangleEx3.height());
                this.m_IsDragged = true;
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.m_Handle.mousePressed(mouseEvent);
        if (this.m_Handle.isMoveable()) {
            Point point = this.snapToGrid(mouseEvent.getPoint());
            this.m_OriginalPoint = this.m_Handle.getPoint();
            this.m_HandleOffset = new Point(this.m_OriginalPoint.x - point.x, this.m_OriginalPoint.y - point.y);
            this.m_OriginalRect = GOExtras.getRepaintsRect(this.m_GO).grow(Handle.HANDLESZ());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.m_Handle.mouseReleased(mouseEvent);
        if (this.m_Handle.isMoveable()) {
            if (this.m_IsDragged) {
                Point point = this.snapToGrid(mouseEvent.getPoint());
                Point point2 = new Point(point.x + this.m_HandleOffset.x, point.y + this.m_HandleOffset.y);
                this.m_Handle.setPoint(point2);
                RectangleEx rectangleEx = GOExtras.getRepaintsRect(this.m_GO).grow(Handle.HANDLESZ());
                this.m_Canvas.drawRect(rectangleEx.left, rectangleEx.top, rectangleEx.width(), rectangleEx.height());
                RectangleEx rectangleEx2 = rectangleEx.union(this.m_OriginalRect);
                Diagram diagram = this.m_GO.getDiagram();
                HandleCmd handleCmd = new HandleCmd(DiagramExtras.getWrapper(diagram).getCanvas(), this.m_Handle, this.m_OriginalPoint, point2, rectangleEx2);
                DiagramExtras.getWrapper(diagram).doCommand(handleCmd);
                this.m_IsDragged = false;
            }
            this.m_Canvas.getSelectionManager().buildSelectionCache();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.m_Handle.mouseClicked(mouseEvent);
        RectangleEx rectangleEx = GOExtras.getRepaintsRect(this.m_GO).grow(Handle.HANDLESZ());
        this.m_Canvas.drawRect(rectangleEx.left, rectangleEx.top, rectangleEx.width(), rectangleEx.height());
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected Point snapToGrid(Point point) {
        point.x += this.m_Grid.width / 2;
        point.y += this.m_Grid.height / 2;
        point.x -= point.x % this.m_Grid.width;
        point.y -= point.y % this.m_Grid.height;
        return point;
    }
}

