/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.diagram;

import com.elixirtech.canvas.diagram.MouseTool;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MouseManager
implements MouseListener,
MouseMotionListener {
    private Component m_Component;
    private int m_ZoomPercent = 100;
    private MouseTool m_CurrentTool;

    public MouseManager(Component component) {
        this.m_Component = component;
        this.m_Component.addMouseListener(this);
        this.m_Component.addMouseMotionListener(this);
    }

    public void deregister() {
        if (this.m_CurrentTool != null) {
            this.m_CurrentTool.deregister();
        }
        this.m_Component.removeMouseListener(this);
        this.m_Component.removeMouseMotionListener(this);
        this.m_Component = null;
    }

    public void setZoomPercent(int n) {
        this.m_ZoomPercent = n;
    }

    public MouseTool getCurrentTool() {
        return this.m_CurrentTool;
    }

    public void setCurrentTool(MouseTool mouseTool) {
        if (this.m_CurrentTool != null) {
            this.m_CurrentTool.deregister();
        }
        this.m_CurrentTool = mouseTool;
        if (this.m_CurrentTool != null && this.m_Component != null) {
            this.m_CurrentTool.register(this.m_Component);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.m_CurrentTool != null) {
            this.m_CurrentTool.mouseExited(this.transform(mouseEvent));
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.m_CurrentTool != null) {
            this.m_CurrentTool.mouseEntered(this.transform(mouseEvent));
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        mouseEvent.getComponent().requestFocus();
        if (this.m_CurrentTool != null && !this.isButton2(mouseEvent)) {
            this.m_CurrentTool.mousePressed(this.transform(mouseEvent));
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.m_CurrentTool != null && !this.isButton2(mouseEvent)) {
            this.m_CurrentTool.mouseReleased(this.transform(mouseEvent));
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.m_CurrentTool != null && !this.isButton2(mouseEvent)) {
            this.m_CurrentTool.mouseClicked(this.transform(mouseEvent));
        }
    }

    public boolean isButton2(MouseEvent mouseEvent) {
        return mouseEvent.getButton() == 2;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.m_CurrentTool != null) {
            this.m_CurrentTool.mouseMoved(this.transform(mouseEvent));
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.m_CurrentTool != null) {
            this.m_CurrentTool.mouseDragged(this.transform(mouseEvent));
        }
    }

    protected MouseEvent transform(MouseEvent mouseEvent) {
        if (this.m_ZoomPercent != 100) {
            Point point = mouseEvent.getPoint();
            Point point2 = mouseEvent.getPoint();
            point.x = (int)((double)point.x * (100.0 / (double)this.m_ZoomPercent));
            point.y = (int)((double)point.y * (100.0 / (double)this.m_ZoomPercent));
            mouseEvent.translatePoint(point.x - point2.x, point.y - point2.y);
        }
        return mouseEvent;
    }
}

