/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.diagram;

import com.elixirtech.canvas.diagram.MouseTool;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;

public abstract class MouseTracker
extends MouseTool {
    protected static final Stroke THIN_STROKE = new BasicStroke(0.0f);
    protected Point m_DownPoint;
    protected Point m_CurrentPoint;
    protected Graphics2D m_Graphics;

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.m_Graphics != null) {
            this.draw();
            Point point = mouseEvent.getPoint();
            this.setCurrentPoint(new Point(point.x, point.y));
            this.draw();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0 && this.m_Graphics == null) {
            Point point = mouseEvent.getPoint();
            Point point2 = new Point(point.x, point.y);
            this.setDownPoint(point2);
            this.setCurrentPoint(point2);
            this.m_Graphics = (Graphics2D)mouseEvent.getComponent().getGraphics();
            this.m_Graphics.setColor(Color.black);
            this.m_Graphics.setXORMode(Color.white);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            if (this.m_Graphics != null) {
                this.draw();
                this.m_Graphics.dispose();
                this.m_Graphics = null;
            }
            Point point = mouseEvent.getPoint();
            this.setCurrentPoint(new Point(point.x, point.y));
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    protected void setDownPoint(Point point) {
        this.m_DownPoint = point;
    }

    protected void setCurrentPoint(Point point) {
        this.m_CurrentPoint = point;
    }

    protected abstract void draw();
}

