/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.diagram;

import com.elixirtech.canvas.commands.MoveCmd;
import com.elixirtech.canvas.corego.Diagram;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.corego.GOExtras;
import com.elixirtech.canvas.diagram.MouseTracker;
import com.elixirtech.canvas.diagram.SelectionManager;
import com.elixirtech.canvas.extras.DiagramExtras;
import com.elixirtech.canvas.geometry.RectangleEx;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;

public class MoveTracker
extends MouseTracker {
    private SelectionManager m_SelectionManager;
    private GO m_GO;
    private boolean m_PriorSelection;
    private RectangleEx m_Rect;
    private RectangleEx m_Container;
    private Dimension m_Grid;

    public MoveTracker(SelectionManager selectionManager, GO gO) {
        this.m_SelectionManager = selectionManager;
        this.m_GO = gO;
        this.m_Grid = DiagramExtras.getGridSize();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.m_PriorSelection = this.m_SelectionManager.isSelected(this.m_GO);
        if (!this.m_PriorSelection) {
            if (mouseEvent.isShiftDown()) {
                this.m_SelectionManager.addSelection(this.m_GO);
            } else {
                this.m_SelectionManager.setSelection(this.m_GO);
            }
        }
        this.m_Rect = this.m_SelectionManager.getSelectionRect();
        assert (this.m_Rect != null);
        this.m_Container = this.m_SelectionManager.getSelectionContainer();
        super.mousePressed(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        RectangleEx rectangleEx = this.getRectangle();
        int n = rectangleEx.left - this.m_Rect.left;
        int n2 = rectangleEx.top - this.m_Rect.top;
        if (n != 0 || n2 != 0) {
            Diagram diagram = this.m_GO.getDiagram();
            MoveCmd moveCmd = new MoveCmd(DiagramExtras.getWrapper(diagram).getCanvas(), n, n2);
            DiagramExtras.getWrapper(diagram).doCommand(moveCmd);
        } else if (mouseEvent.isShiftDown()) {
            if (this.m_PriorSelection) {
                this.m_SelectionManager.removeSelection(this.m_GO);
            } else {
                this.m_SelectionManager.addSelection(this.m_GO);
            }
        } else {
            this.m_SelectionManager.setSelection(this.m_GO);
        }
    }

    public RectangleEx getRectangle() {
        RectangleEx rectangleEx = (RectangleEx)this.m_Rect.clone();
        int n = this.m_CurrentPoint.x - this.m_DownPoint.x;
        int n2 = this.m_CurrentPoint.y - this.m_DownPoint.y;
        if (n != 0 || n2 != 0) {
            rectangleEx.move(n, n2);
            if (rectangleEx.left < this.m_Container.left) {
                rectangleEx.move(this.m_Container.left - rectangleEx.left, 0);
            }
            if (rectangleEx.top < this.m_Container.top) {
                rectangleEx.move(0, this.m_Container.top - rectangleEx.top);
            }
            if (rectangleEx.right > this.m_Container.right) {
                rectangleEx.move(this.m_Container.right - rectangleEx.right, 0);
            }
            if (rectangleEx.bottom > this.m_Container.bottom) {
                rectangleEx.move(0, this.m_Container.bottom - rectangleEx.bottom);
            }
        }
        return rectangleEx;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        GO gO = DiagramExtras.shapeAtPoint(this.m_GO.getDiagram(), new Point(point.x, point.y));
        if (gO != null) {
            GOExtras.doClick(gO, point);
        }
    }

    @Override
    protected void setDownPoint(Point point) {
        point.x -= point.x % this.m_Grid.width;
        point.y -= point.y % this.m_Grid.height;
        super.setDownPoint(point);
    }

    @Override
    protected void setCurrentPoint(Point point) {
        point.x -= point.x % this.m_Grid.width;
        point.y -= point.y % this.m_Grid.height;
        super.setCurrentPoint(point);
    }

    @Override
    protected void draw() {
        RectangleEx rectangleEx = this.getRectangle();
        if (!rectangleEx.equals((Object)this.m_Rect)) {
            Stroke stroke = this.m_Graphics.getStroke();
            this.m_Graphics.setStroke(THIN_STROKE);
            this.m_Graphics.drawRect(rectangleEx.left, rectangleEx.top, rectangleEx.width(), rectangleEx.height());
            this.m_Graphics.setStroke(stroke);
        }
    }
}

