/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.diagram;

import com.elixirtech.canvas.diagram.DiagramCanvas;
import com.elixirtech.canvas.diagram.MouseTracker;
import com.elixirtech.canvas.diagram.SelectionManager;
import com.elixirtech.canvas.extras.DiagramExtras;
import com.elixirtech.canvas.geometry.RectangleEx;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Stroke;
import java.awt.event.MouseEvent;

class RectTracker
extends MouseTracker {
    RectangleEx m_Container;
    SelectionManager m_SelectionManager;

    public RectTracker(SelectionManager selectionManager) {
        this.m_SelectionManager = selectionManager;
    }

    @Override
    public void register(Component component) {
        super.register(component);
        DiagramCanvas diagramCanvas = (DiagramCanvas)component;
        Dimension dimension = DiagramExtras.getDiagramSize();
        this.m_Container = new RectangleEx(0, 0, dimension.width, dimension.height);
    }

    public void setContainer(RectangleEx rectangleEx) {
        this.m_Container = rectangleEx;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        RectangleEx rectangleEx = this.getRectangle();
        if (mouseEvent.isShiftDown()) {
            this.m_SelectionManager.shiftSelect(rectangleEx);
        } else {
            this.m_SelectionManager.select(rectangleEx);
        }
    }

    public RectangleEx getRectangle() {
        RectangleEx rectangleEx = new RectangleEx(this.m_DownPoint, this.m_CurrentPoint);
        rectangleEx.normalize();
        rectangleEx.limitTo(this.m_Container);
        return rectangleEx;
    }

    @Override
    protected void draw() {
        RectangleEx rectangleEx = this.getRectangle();
        if (rectangleEx.width() > 1 || rectangleEx.height() > 1) {
            Stroke stroke = this.m_Graphics.getStroke();
            this.m_Graphics.setStroke(THIN_STROKE);
            this.m_Graphics.drawRect(rectangleEx.left, rectangleEx.top, rectangleEx.width(), rectangleEx.height());
            this.m_Graphics.setStroke(stroke);
        }
    }
}

