/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.diagram;

import com.elixirtech.canvas.corego.Diagram;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.corego.GOExtras;
import com.elixirtech.canvas.corego.Handle;
import com.elixirtech.canvas.diagram.HandleTracker;
import com.elixirtech.canvas.diagram.ICanvas;
import com.elixirtech.canvas.diagram.MouseTool;
import com.elixirtech.canvas.diagram.RectTracker;
import com.elixirtech.canvas.diagram.SelectionManager;
import com.elixirtech.canvas.extras.DiagramExtras;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;

public class SelectionTool
extends MouseTool {
    protected ICanvas m_Canvas;
    protected SelectionManager m_SelMgr;
    protected MouseTool m_Tracker;
    protected MouseTool m_ClickTracker;
    protected Handle m_Handle;

    @Override
    public void register(Component component) {
        super.register(component);
        this.m_Canvas = (ICanvas)((Object)component);
        this.m_SelMgr = this.m_Canvas.getSelectionManager();
    }

    @Override
    public void deregister() {
        this.m_Canvas.getKeyboardInterface().setKeyTool(this.m_Canvas.getKeyTool());
        super.deregister();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Handle handle = this.m_SelMgr.handleAtPoint(new Point(point.x, point.y));
        if (handle != this.m_Handle) {
            this.m_Handle = handle;
            boolean bl = this.m_Canvas.getWrappedDiagram().isEditable();
            Cursor cursor = Cursor.getDefaultCursor();
            if (bl && this.m_Handle != null) {
                cursor = this.m_Handle.getCursor();
            }
            this.m_Canvas.getCanvasContext().getFrame().setCursor(cursor);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.m_Tracker != null) {
            this.m_Tracker.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.m_Tracker != null) {
            return;
        }
        this.m_Canvas.getKeyboardInterface().setKeyTool(this.m_Canvas.getKeyTool());
        mouseEvent.getComponent().requestFocus();
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(point);
        } else if ((mouseEvent.getModifiers() & 4) == 0) {
            GO gO;
            this.m_Tracker = this.m_Handle != null ? new HandleTracker(this.m_Handle) : ((gO = DiagramExtras.shapeAtPoint(this.m_Canvas.getDiagram(), point)) != null ? GOExtras.getTracker(this.m_SelMgr, mouseEvent, gO) : new RectTracker(this.m_SelMgr));
            if (this.m_Tracker != null) {
                this.m_Tracker.register(mouseEvent.getComponent());
                this.m_Tracker.mousePressed(mouseEvent);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.m_Tracker != null) {
            this.m_Tracker.mouseReleased(mouseEvent);
        }
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(point);
        } else if ((mouseEvent.getModifiers() & 0x10) != 0) {
            GO gO;
            if (mouseEvent.getClickCount() == 1) {
                this.m_ClickTracker = this.m_Tracker;
            }
            if (mouseEvent.getClickCount() == 2 && (gO = DiagramExtras.shapeAtPoint(this.m_Canvas.getDiagram(), new Point(point.x, point.y))) != null) {
                GOExtras.doDoubleClick(point, gO);
            }
        }
        this.m_Tracker = null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0 && this.m_ClickTracker != null) {
            this.m_ClickTracker.mouseClicked(mouseEvent);
            this.m_ClickTracker = null;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void doPopup(Point point) {
        JPopupMenu jPopupMenu = null;
        Diagram diagram = this.m_Canvas.getDiagram();
        GO gO = DiagramExtras.shapeAtPoint(diagram, new Point(point.x, point.y));
        jPopupMenu = gO != null ? GOExtras.getPopupMenu(gO, point) : DiagramExtras.getPopupMenu(point, this.m_Canvas.getDiagram(), gO);
        if (jPopupMenu != null) {
            this.m_Canvas.getComponent().add(jPopupMenu);
            double d = (double)this.m_Canvas.getWrappedDiagram().getZoomPercent() / 100.0;
            jPopupMenu.show(this.m_Canvas.getComponent(), (int)((double)point.x * d), (int)((double)point.y * d));
        }
    }
}

