/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.extras;

import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.canvas.extras.CubeGOHelper;
import com.elixirtech.canvas.extras.DiagramExtras$;
import com.elixirtech.canvas.geometry.RectangleEx;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.CubeGO;
import com.elixirtech.ensemble.canvas.action.ViewCubeListener;
import com.elixirtech.ensemble.wizard.cube.CubeGOWrapper;
import com.elixirtech.ensemble.wizard.cube.CubeWizard;
import com.elixirtech.i18n.I18NBypass;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import scala.runtime.ModuleSerializationProxy;

public final class CubeGOHelper$
implements Serializable {
    public static final CubeGOHelper$ MODULE$ = new CubeGOHelper$();

    private CubeGOHelper$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CubeGOHelper$.class);
    }

    public Shape getShape(CubeGO go) {
        RectangleEx rect = go.getRect();
        int width = rect.width();
        int height = rect.height();
        int offset = Math.min(width / 5, height / 5);
        GeneralPath path = new GeneralPath();
        path.moveTo((float)rect.left + (float)offset, rect.top);
        path.lineTo(rect.right, rect.top);
        path.lineTo(rect.right, (float)rect.bottom - (float)offset);
        path.lineTo((float)rect.right - (float)offset, rect.bottom);
        path.lineTo(rect.left, rect.bottom);
        path.lineTo(rect.left, (float)rect.top + (float)offset);
        path.closePath();
        return path;
    }

    public JPopupMenu getPopupMenu(CubeGO go, Point pt) {
        JPopupMenu pm = new JPopupMenu();
        JMenuItem mi = I18NBypass.newMenuItem(I18N.ENSEMBLE.getString("GO.PROPERTIES"));
        boolean isEditable = DiagramExtras$.MODULE$.getWrapper(go.getDiagram()).isEditable();
        mi.addActionListener(new CubeGOHelper.ShowGOPropertiesListener(go));
        mi.setEnabled(isEditable);
        pm.add(mi);
        mi = I18NBypass.newMenuItem(I18N.ENSEMBLE.getString("CubeGO.VIEW_CUBE"));
        mi.addActionListener(new ViewCubeListener(go));
        mi.setEnabled(go.getDataSchema() != null);
        pm.add(mi);
        mi = I18NBypass.newMenuItem(I18N.ENSEMBLE.getString("GO.DELETE_GRAPHIC"));
        mi.addActionListener(new CubeGOHelper.DeleteGOListener(go));
        mi.setEnabled(isEditable);
        pm.add(mi);
        return pm;
    }

    public void showProperties(CubeGO go) {
        ElixirFrame f = (ElixirFrame)Elixir$.MODULE$.get(ElixirFrame.class);
        f.showWizard(new CubeWizard(new CubeGOWrapper(go)));
    }
}

