/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.extras;

import com.elixirtech.canvas.corego.Diagram;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.corego.GOExtras$;
import com.elixirtech.canvas.corego.ParentGO;
import com.elixirtech.canvas.corego.ParentGOHelper$;
import com.elixirtech.canvas.diagram.DiagramSelectionManager;
import com.elixirtech.canvas.diagram.ICanvas;
import com.elixirtech.canvas.extras.DiagramExtras$;
import com.elixirtech.canvas.extras.DiagramWrapper$;
import com.elixirtech.canvas.geometry.RectangleEx;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.command.Command;
import com.elixirtech.command.CommandManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class DiagramWrapper
implements Product,
Serializable {
    private final Diagram d;
    private final CommandManager commandManager;
    private final DiagramSelectionManager selectionManager;
    private Option<ICanvas> optCanvas;
    private boolean editable;
    private int zoomPercent;

    public static DiagramWrapper apply(Diagram diagram) {
        return DiagramWrapper$.MODULE$.apply(diagram);
    }

    public static DiagramWrapper fromProduct(Product product) {
        return DiagramWrapper$.MODULE$.fromProduct(product);
    }

    public static DiagramWrapper unapply(DiagramWrapper diagramWrapper) {
        return DiagramWrapper$.MODULE$.unapply(diagramWrapper);
    }

    public DiagramWrapper(Diagram d) {
        this.d = d;
        if (Option$.MODULE$.apply((Object)d).isEmpty()) {
            throw new RuntimeException("Diagram is null");
        }
        this.commandManager = new CommandManager();
        this.selectionManager = new DiagramSelectionManager(this);
        this.optCanvas = None$.MODULE$;
        this.editable = true;
        this.zoomPercent = 100;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DiagramWrapper)) return false;
        DiagramWrapper diagramWrapper = (DiagramWrapper)object;
        Diagram diagram = this.d();
        Diagram diagram2 = diagramWrapper.d();
        if (diagram == null) {
            if (diagram2 != null) {
                return false;
            }
        } else if (!diagram.equals(diagram2)) return false;
        if (!diagramWrapper.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof DiagramWrapper;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "DiagramWrapper";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "d";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Diagram d() {
        return this.d;
    }

    public CommandManager commandManager() {
        return this.commandManager;
    }

    public DiagramSelectionManager selectionManager() {
        return this.selectionManager;
    }

    public CommandManager getCommandManager() {
        return this.commandManager();
    }

    public void doCommand(Command c) {
        this.commandManager().doCommand(c);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean e) {
        this.editable = e;
    }

    public ICanvas getCanvas() {
        return (ICanvas)this.optCanvas.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void setCanvas(ICanvas c) {
        this.optCanvas = Option$.MODULE$.apply((Object)c);
    }

    public DiagramSelectionManager getSelectionManager() {
        return this.selectionManager();
    }

    public int getZoomPercent() {
        return this.zoomPercent;
    }

    public void setZoomPercent(int z) {
        this.zoomPercent = z;
        this.optCanvas.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.refresh());
    }

    public Point zoomPoint(Point pt) {
        if (this.zoomPercent == 100) {
            return pt;
        }
        pt.x *= this.zoomPercent / 100;
        pt.y *= this.zoomPercent / 100;
        return pt;
    }

    public void draw(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.drawSheet(g2);
        this.drawShapes(g2);
        this.selectionManager().drawHandles(g2);
    }

    public void drawSheet(Graphics2D g) {
        Icon icon = this.getBackgroundIcon();
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        Rectangle clip = g.getClipBounds();
        Dimension sz = this.getDiagramSize();
        RectangleEx rc = new RectangleEx(clip.x, clip.y, clip.x + clip.width, clip.y + clip.height);
        g.setColor(Color.lightGray);
        g.fillRect(clip.x, clip.y, clip.x + clip.width, clip.y + clip.height);
        rc.right = Math.min(sz.width, clip.x + clip.width);
        rc.bottom = Math.min(sz.height, clip.y + clip.height);
        g.setClip(rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top);
        rc.left -= rc.left % w;
        rc.top -= rc.top % h;
        this.optCanvas.foreach((Function1)(JProcedure1 & Serializable)canvas -> {
            for (int gx = rc$1.left; gx <= rc$1.right; gx += w) {
                for (int gy = rc$1.top; gy <= rc$1.bottom; gy += h) {
                    icon.paintIcon(canvas.getComponent(), g, gx, gy);
                }
            }
        });
        g.setClip(clip.x, clip.y, clip.width, clip.height);
        g.setColor(Color.black);
        g.drawRect(-1, -1, sz.width + 2, sz.height + 2);
    }

    public void drawShapes(Graphics2D g) {
        Rectangle clip = g.getClipBounds();
        RectangleEx rc = new RectangleEx(clip.x, clip.y, clip.x + clip.width, clip.y + clip.height);
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.d().getChildArray());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)x$1 -> {
            Node node = x$1;
            if (node instanceof GO) {
                GO go = (GO)node;
                RectangleEx rc2 = GOExtras$.MODULE$.getPaintRect(go);
                if (rc.intersects(rc2)) {
                    GOExtras$.MODULE$.draw(g, go);
                    return;
                }
                return;
            }
        });
    }

    public void drawShapes() {
        this.optCanvas.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.drawShapes());
    }

    public Icon getBackgroundIcon() {
        return DiagramExtras$.MODULE$.policy().getBackgroundIcon(this.d());
    }

    public GO shapeAtPoint(Point pt) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.d().getChildArray());
        Object[] shapes = (Node[])ArrayOps$.MODULE$.reverse$extension(object);
        Object object2 = Predef$.MODULE$.refArrayOps(shapes);
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.collect$extension(object2, (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Node x) {
                Node node = x;
                if (node instanceof GO) {
                    GO go = (GO)node;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Node x, Function1 function1) {
                Node node = x;
                if (node instanceof GO) {
                    GO go = (GO)node;
                    return go;
                }
                return function1.apply((Object)x);
            }
        }, ClassTag$.MODULE$.apply(GO.class)));
        return (GO)ArrayOps$.MODULE$.find$extension(object3, (Function1 & Serializable)go -> GOExtras$.MODULE$.contains(pt, (GO)go)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public List<Node> shapesInRect(RectangleEx rc) {
        ArrayList<Node> ret = new ArrayList<Node>();
        if (rc.width() < 5 && rc.height() < 5) {
            GO go = this.shapeAtPoint(rc.leftTop());
            if (go != null) {
                ret.add((Node)go);
            }
            return ret;
        }
        Object[] shapes = this.d().getChildArray();
        Object object = Predef$.MODULE$.refArrayOps(shapes);
        ArrayOps$.MODULE$.indices$extension(object).foreach((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> DiagramWrapper.shapesInRect$$anonfun$1((Node[])shapes, rc, ret, arg_0)));
        return ret;
    }

    public void drawRect(int l, int t, int w, int h) {
        this.optCanvas.foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.drawRect(l, t, w, h));
    }

    public Dimension getDiagramSize() {
        return DiagramExtras$.MODULE$.getDiagramSize();
    }

    public Option<ParentGO> getParent(Point pt, GO newGO) {
        RectangleEx rc = GOExtras$.MODULE$.getPaintRect(newGO);
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.d().getChildArray());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.collect$extension(object, (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Node x) {
                Node node = x;
                if (node instanceof ParentGO) {
                    ParentGO go = (ParentGO)node;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Node x, Function1 function1) {
                Node node = x;
                if (node instanceof ParentGO) {
                    ParentGO go = (ParentGO)node;
                    return go;
                }
                return function1.apply((Object)x);
            }
        }, ClassTag$.MODULE$.apply(ParentGO.class)));
        Object[] shapes = (ParentGO[])ArrayOps$.MODULE$.reverse$extension(object2);
        Object object3 = Predef$.MODULE$.refArrayOps(shapes);
        Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filterNot$extension(object3, (Function1 & Serializable)_$4 -> {
            ParentGO parentGO = _$4;
            GO gO = newGO;
            return !(parentGO != null ? !parentGO.equals(gO) : gO != null);
        }));
        return ArrayOps$.MODULE$.find$extension(object4, (Function1 & Serializable)parent -> {
            if (GOExtras$.MODULE$.contains(pt, (GO)parent)) {
                RectangleEx paintRc = ParentGOHelper$.MODULE$.expandToContain((ParentGO)parent, rc);
                if (paintRc != null) {
                    this.drawRect(paintRc.left, paintRc.top, paintRc.width(), paintRc.height());
                }
                return true;
            }
            return false;
        });
    }

    public ParentGO getParentJ(Point pt, GO newGO) {
        return (ParentGO)this.getParent(pt, newGO).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public DiagramWrapper copy(Diagram d) {
        return new DiagramWrapper(d);
    }

    public Diagram copy$default$1() {
        return this.d();
    }

    public Diagram _1() {
        return this.d();
    }

    private static final /* synthetic */ void shapesInRect$$anonfun$1(Node[] shapes$1, RectangleEx rc$3, ArrayList ret$1, int i) {
        GO go = (GO)shapes$1[i];
        RectangleEx rc2 = GOExtras$.MODULE$.getPaintRect(go);
        if (rc$3.contains(rc2)) {
            ret$1.add(go);
            return;
        }
    }
}

