/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.extras;

import com.elixirtech.awt.TextBlock;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.corego.GOExtras;
import com.elixirtech.canvas.corego.GOExtras$;
import com.elixirtech.canvas.extras.DiagramExtras$;
import com.elixirtech.canvas.geometry.RectangleEx;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.canvas.action.ViewListener;
import com.elixirtech.i18n.I18NBypass;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.io.Serializable;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import scala.Float$;
import scala.MatchError;
import scala.runtime.ModuleSerializationProxy;

public final class InOutGOHelper$
implements Serializable {
    private static final Font LABEL_FONT;
    private static final FontRenderContext FRC;
    private static final int FONT_HEIGHT;
    public static final InOutGOHelper$ MODULE$;

    private InOutGOHelper$() {
    }

    static {
        MODULE$ = new InOutGOHelper$();
        LABEL_FONT = new Font("SansSerif", 0, 10);
        FRC = new FontRenderContext(null, false, false);
        FONT_HEIGHT = (int)Math.ceil(Float$.MODULE$.float2double(MODULE$.LABEL_FONT().getLineMetrics("Sample chars", MODULE$.FRC()).getHeight()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(InOutGOHelper$.class);
    }

    public Font LABEL_FONT() {
        return LABEL_FONT;
    }

    public FontRenderContext FRC() {
        return FRC;
    }

    public int FONT_HEIGHT() {
        return FONT_HEIGHT;
    }

    public void doDoubleClick(InOutGO go, Point pt) {
        if (this.isEditable(go)) {
            GOExtras$.MODULE$.showProperties((GO)go);
            return;
        }
        Toolkit.getDefaultToolkit().beep();
    }

    public void draw(InOutGO go, Graphics2D g) {
        g.setColor(Color.black);
        this.getTextBlock(go).draw((Graphics)g, this.namePoint(go), this.getTextAlignment());
        for (InOutGO.In in : go.getIns()) {
            if (in instanceof InOutGO.Top) {
                InOutGO.Top top = (InOutGO.Top)in;
                this.paintTop(top, g, go);
                continue;
            }
            if (in instanceof InOutGO.In) {
                InOutGO.In in2 = in;
                this.paintIn(in2, g, go);
                continue;
            }
            throw new MatchError((Object)in);
        }
        for (InOutGO.Out out : go.getOuts()) {
            this.paintOut(out, g, go);
        }
    }

    public JPopupMenu getPopupMenu(InOutGO go, Point pt) {
        JPopupMenu pm = new JPopupMenu();
        JMenuItem mi = I18NBypass.newMenuItem(I18N.ENSEMBLE.getString("GO.PROPERTIES"));
        mi.addActionListener(new GOExtras.ShowGOPropertiesListener((GO)go));
        mi.setEnabled(this.isEditable(go));
        pm.add(mi);
        mi = I18NBypass.newMenuItem(I18N.ENSEMBLE.getString("GO.VIEW_OUTPUT"));
        mi.addActionListener(new ViewListener(go));
        mi.setEnabled(go.getSchema() != null);
        pm.add(mi);
        mi = I18NBypass.newMenuItem(I18N.ENSEMBLE.getString("GO.DELETE_GRAPHIC"));
        mi.addActionListener(new GOExtras.DeleteGOListener((GO)go));
        mi.setEnabled(this.isEditable(go));
        pm.add(mi);
        return pm;
    }

    public int getTextAlignment() {
        return 1;
    }

    public Point namePoint(InOutGO go) {
        return go.getRect().center();
    }

    public TextBlock getTextBlock(InOutGO go) {
        TextBlock m_TextBlock = new TextBlock(this.LABEL_FONT());
        m_TextBlock.setWordWrap(true);
        m_TextBlock.setWrapWidth(go.getRect().width() - 20);
        m_TextBlock.update(this.getText(go));
        return m_TextBlock;
    }

    public void drawBox(InOutGO go, Graphics2D g, Shape shape) {
        g.setColor(SystemColor.controlShadow);
        g.translate(2, 2);
        g.fill(shape);
        g.translate(-2, -2);
        g.setColor(go.getFillColor());
        g.fill(shape);
        g.setColor(Color.black);
        g.draw(shape);
    }

    public RectangleEx getPaintRect(InOutGO go) {
        TextBlock tb = this.getTextBlock(go);
        RectangleEx rc = tb.getOutlineRect(this.namePoint(go), this.getTextAlignment());
        for (InOutGO.In in : go.getIns()) {
            if (in instanceof InOutGO.Top) {
                InOutGO.Top top = (InOutGO.Top)in;
                rc = rc.union(this.paintRectTop(top, go));
                continue;
            }
            if (in instanceof InOutGO.In) {
                InOutGO.In in2 = in;
                rc = rc.union(this.paintRectIn(in2, go));
                continue;
            }
            throw new MatchError((Object)in);
        }
        for (InOutGO.Out out : go.getOuts()) {
            rc = rc.union(this.paintRectOut(out, go));
        }
        return go.getRect().union(rc);
    }

    public boolean contains(InOutGO go, Point pt) {
        if (go.getRect().contains(pt)) {
            return true;
        }
        TextBlock tb = this.getTextBlock(go);
        RectangleEx rc = tb.getOutlineRect(this.namePoint(go), this.getTextAlignment());
        if (rc.contains(pt)) {
            return true;
        }
        for (InOutGO.In in : go.getIns()) {
            if (!this.paintRectIn(in, go).contains(pt)) continue;
            return true;
        }
        for (InOutGO.Out out : go.getOuts()) {
            if (!this.paintRectOut(out, go).contains(pt)) continue;
            return true;
        }
        return false;
    }

    public Rectangle getShape(InOutGO go) {
        RectangleEx rect = go.getRect();
        return new Rectangle(rect.left, rect.top, rect.width(), rect.height());
    }

    public void setText(InOutGO go, String text) {
        go.setText(text);
    }

    public String getText(InOutGO go) {
        return go.getText();
    }

    public boolean isEditable(InOutGO go) {
        return DiagramExtras$.MODULE$.getWrapper(go.getDiagram()).isEditable();
    }

    public void paintIn(InOutGO.In in, Graphics g, InOutGO go) {
        int x2 = go.getRectGOLeft();
        int x = x2 - in.m_Width;
        RectangleEx rc = go.getRect();
        int y = (int)((double)rc.top + (double)rc.height() * in.m_Y);
        g.setFont(this.LABEL_FONT());
        g.drawLine(x, y, x2 - 4, y);
        Polygon p = new Polygon(new int[]{x2 - 4, x2 - 1, x2 - 4}, new int[]{y - 3, y, y + 3}, 3);
        g.drawPolygon(p);
        int m_LabelWidth = go.stringWidth(in.getLabel()) + 5;
        g.drawString(in.getLabel(), x2 - m_LabelWidth, y + this.FONT_HEIGHT());
    }

    public void paintOut(InOutGO.Out out, Graphics g, InOutGO go) {
        int x = go.getRectGORight();
        int x2 = x + out.m_Width;
        RectangleEx rc = go.getRect();
        int y = (int)((double)rc.top + (double)rc.height() * out.m_Y);
        g.setFont(this.LABEL_FONT());
        g.drawLine(x, y, x2 - 3, y);
        Polygon p = new Polygon(new int[]{x2 - 3, x2, x2 - 3}, new int[]{y - 3, y, y + 3}, 3);
        g.drawPolygon(p);
        g.drawString(out.getLabel(), x + 3, y - 2);
    }

    public void paintTop(InOutGO.Top top, Graphics g, InOutGO go) {
        int y2 = go.getRectGOTop();
        int y = y2 - top.m_Height;
        RectangleEx rc = go.getRect();
        int x = (int)((double)rc.left + (double)rc.width() * top.m_Y);
        g.setFont(this.LABEL_FONT());
        g.drawLine(x, y, x, y2 - 4);
        Polygon p = new Polygon(new int[]{x - 3, x, x + 3}, new int[]{y2 - 4, y2 - 1, y2 - 4}, 3);
        g.drawPolygon(p);
        g.drawString(top.getLabel(), x + 3, y + top.m_Height - 4);
    }

    public RectangleEx paintRectIn(InOutGO.In in, InOutGO go) {
        int left = go.getRectGOLeft();
        RectangleEx rc = go.getRect();
        int y = (int)((double)rc.top + (double)rc.height() * in.m_Y);
        int width = Math.max(in.m_Width, go.stringWidth(in.getLabel()) + 5);
        return new RectangleEx(left - width - 8, y, left + 8, y + this.FONT_HEIGHT() + 8);
    }

    public RectangleEx paintRectOut(InOutGO.Out out, InOutGO go) {
        int right = go.getRectGORight();
        RectangleEx rc = go.getRect();
        int y = (int)((double)rc.top + (double)rc.height() * out.m_Y);
        int width = Math.max(out.m_Width, go.stringWidth(out.getLabel()) + 5);
        return new RectangleEx(right, y - 10, right + width + 8, y + 8);
    }

    public RectangleEx paintRectTop(InOutGO.Top topRect, InOutGO go) {
        int top = go.getRectGOTop();
        RectangleEx rc = go.getRect();
        int x = (int)((double)rc.left + (double)rc.width() * topRect.m_Y);
        int width = Math.max(topRect.m_Width, go.stringWidth(topRect.getLabel()));
        return new RectangleEx(x - 4, top - topRect.m_Height, x + width, top);
    }
}

