/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.sub;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.ISecurity;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.Path;
import com.elixirtech.canvas.commands.CreationCmd;
import com.elixirtech.canvas.corego.Diagram;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.corego.RectGO;
import com.elixirtech.canvas.corego.RectGOHelper;
import com.elixirtech.canvas.diagram.DiagramCanvas;
import com.elixirtech.canvas.diagram.DiagramSelectionManager;
import com.elixirtech.canvas.diagram.ICanvasContext;
import com.elixirtech.canvas.extras.DiagramExtras;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.canvas.graph.RelType;
import com.elixirtech.canvas.toolbox.ToolBarBuilder;
import com.elixirtech.canvas.xml.XmlExtras;
import com.elixirtech.data2.datasource.composite.CompositeDataSource;
import com.elixirtech.ensemble.DataSourceFileType;
import com.elixirtech.ensemble.EnsembleAction;
import com.elixirtech.ensemble.EnsembleOptions;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.DataSourceGO;
import com.elixirtech.ensemble.canvas.DataStoreGO;
import com.elixirtech.ensemble.canvas.EnsembleKeyTool;
import com.elixirtech.ensemble.canvas.ICanvasPanel;
import com.elixirtech.ensemble.canvas.action.CanvasPrintAction;
import com.elixirtech.ensemble.canvas.sub.InputGO;
import com.elixirtech.ensemble.canvas.sub.OutputGO;
import com.elixirtech.ensemble.canvas.sub.SubCompositeDiagram;
import com.elixirtech.ensemble.canvas.sub.SubGO;
import com.elixirtech.ensemble.ds.DSPanel;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.util.StringUtil;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SubCanvasPanel
implements ICanvasPanel,
ChangeListener {
    private CompositeDataSource m_DataSource;
    private SubGO m_SubGO;
    private JPanel m_Panel;
    private JToolBar m_ToolBar;
    private DTL m_DTL = new DTL();
    EnsembleContext m_Context;
    JComboBox m_Zoom;
    SubCompositeDiagram m_Diagram;
    DiagramCanvas m_Canvas;
    private static final String[] ZOOM_LABELS = new String[]{"50%", "100%", "200%", "400%"};
    static final int[] ZOOM_PERCENTS = new int[]{50, 100, 200, 400};

    public SubCanvasPanel(CompositeDataSource compositeDataSource, SubGO subGO) {
        ISecurity iSecurity;
        this.m_DataSource = compositeDataSource;
        this.m_SubGO = subGO;
        this.m_Context = new EnsembleContext();
        this.m_Panel = new JPanel(new BorderLayout());
        this.m_ToolBar = SwingFactory.newToolBar();
        this.m_Panel.add((Component)this.m_ToolBar, "North");
        this.m_Diagram = this.m_SubGO.getSubDiagram();
        if (this.m_Diagram == null) {
            this.m_Diagram = new SubCompositeDiagram(compositeDataSource, "SubEnsemble");
            iSecurity = new InputGO();
            RectGOHelper.setPoint(new Point(50, 50), (RectGO)iSecurity);
            this.m_Diagram.connectTo((Node)iSecurity, RelType.Owns);
            iSecurity = new OutputGO();
            RectGOHelper.setPoint(new Point(400, 50), (RectGO)iSecurity);
            this.m_Diagram.connectTo((Node)iSecurity, RelType.Owns);
            this.m_SubGO.setSubDiagram(this.m_Diagram);
        }
        this.m_Diagram.setDataSource(compositeDataSource);
        iSecurity = (ISecurity)compositeDataSource.getAdapter(ISecurity.class);
        DiagramExtras.getWrapper((Diagram)this.m_Diagram).setEditable(!iSecurity.isReadOnly());
        DiagramExtras.getWrapper((Diagram)this.m_Diagram).getCommandManager().addChangeListener(this);
        this.m_Canvas = new DiagramCanvas(new EnsembleKeyTool(this), (Diagram)this.m_Diagram);
        this.m_Canvas.setCanvasContext(this.m_Context);
        this.m_Panel.add(this.scroll(this.m_Canvas));
        this.buildToolBar();
        SwingUtil.setupDropTarget(this.m_Canvas, this.m_DTL);
    }

    public Diagram getDiagram() {
        return this.m_Diagram;
    }

    public void cut() {
        if (DiagramExtras.getWrapper((Diagram)this.m_Diagram).isEditable()) {
            CutAction cutAction = new CutAction();
            cutAction.actionPerformed(null);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void copy() {
        if (DiagramExtras.getWrapper((Diagram)this.m_Diagram).isEditable()) {
            CopyAction copyAction = new CopyAction();
            copyAction.actionPerformed(null);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void paste() {
        if (DiagramExtras.getWrapper((Diagram)this.m_Diagram).isEditable()) {
            PasteAction pasteAction = new PasteAction();
            pasteAction.actionPerformed(null);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public Component getComponent() {
        return this.m_Panel;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.m_DataSource.setDirty(true);
    }

    protected void buildToolBar() {
        String string = this.m_SubGO.getText();
        if (StringUtil.isEmpty(string)) {
            string = I18N.ENSEMBLE.getString("SubCanvasPanel.DefaultTitle");
        }
        this.m_ToolBar.add(new JLabel(string));
        this.m_ToolBar.addSeparator();
        new ToolBarBuilder(this.m_ToolBar, this.m_Canvas);
        this.m_ToolBar.addSeparator();
        this.m_ToolBar.add(new JLabel(I18N.ENSEMBLE.getString("CanvasPanel.ZOOM")));
        this.m_Zoom = new JComboBox<String>(ZOOM_LABELS);
        Dimension dimension = this.m_Zoom.getPreferredSize();
        dimension.width += 20;
        this.m_Zoom.setPreferredSize(dimension);
        this.m_Zoom.setMaximumSize(dimension);
        this.m_Zoom.setSelectedIndex(1);
        this.m_ToolBar.add(this.m_Zoom);
        this.m_Zoom.addItemListener(new ZoomListener());
        this.m_ToolBar.add(new CutAction());
        this.m_ToolBar.add(new CopyAction());
        this.m_ToolBar.add(new PasteAction());
        this.m_ToolBar.add(new CanvasPrintAction(this));
        this.m_ToolBar.addSeparator();
        this.m_ToolBar.add(new CloseAction());
    }

    protected void dropDataSource(FileObject fileObject, Point point) {
        DataSourceGO dataSourceGO = new DataSourceGO();
        String string = fileObject.getName();
        if (string.endsWith(".ds")) {
            string = string.substring(0, string.length() - 3);
        }
        dataSourceGO.setText(string);
        String string2 = fileObject.getPathString();
        dataSourceGO.setUserProperty("DataSource", string2);
        RectGOHelper.setPoint(point, (RectGO)dataSourceGO);
        this.m_Diagram.connectTo((Node)dataSourceGO, RelType.Owns);
        CreationCmd creationCmd = new CreationCmd(this.m_Canvas, null, (GO)dataSourceGO);
        DiagramExtras.getWrapper((Diagram)this.m_Diagram).doCommand(creationCmd);
    }

    private JScrollPane scroll(JComponent jComponent) {
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        jScrollPane.setBorder(null);
        return jScrollPane;
    }

    private class DTL
    implements DropTargetListener {
        private DTL() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (DiagramExtras.getWrapper((Diagram)SubCanvasPanel.this.m_Diagram).isEditable() && dropTargetDragEvent.isDataFlavorSupported(DataSourceFileType.DATASOURCE_FLAVOR())) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (DiagramExtras.getWrapper((Diagram)SubCanvasPanel.this.m_Diagram).isEditable() && dropTargetDragEvent.isDataFlavorSupported(DataSourceFileType.DATASOURCE_FLAVOR())) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (DiagramExtras.getWrapper((Diagram)SubCanvasPanel.this.m_Diagram).isEditable() && transferable.isDataFlavorSupported(DataSourceFileType.DATASOURCE_FLAVOR())) {
                try {
                    Path path = (Path)transferable.getTransferData(DataSourceFileType.DATASOURCE_FLAVOR());
                    Repository repository = (Repository)Elixir.get(Repository.class);
                    FileObject fileObject = repository.getFileJ(path.toString());
                    if (fileObject != null) {
                        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                        SubCanvasPanel.this.dropDataSource(fileObject, dropTargetDropEvent.getLocation());
                        dropTargetDropEvent.dropComplete(true);
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dropTargetDropEvent.rejectDrop();
            dropTargetDropEvent.dropComplete(false);
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }
    }

    private class EnsembleContext
    implements ICanvasContext {
        private EnsembleContext() {
        }

        @Override
        public void diagramOpened() {
        }

        @Override
        public void diagramChanged(int n) {
        }

        @Override
        public void displayWarning(String string) {
            ((IErrorHandler)Elixir.get(IErrorHandler.class)).warn(string);
        }

        @Override
        public JFrame getFrame() {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            return elixirFrame.getFrame();
        }
    }

    private class CutAction
    extends EnsembleAction {
        public CutAction() {
            super("CanvasPanel.Cut");
            this.setEnabled(DiagramExtras.getWrapper((Diagram)SubCanvasPanel.this.m_Diagram).isEditable());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = EnsembleOptions.allowDataStores();
            DiagramSelectionManager diagramSelectionManager = DiagramExtras.getWrapper((Diagram)SubCanvasPanel.this.m_Diagram).getSelectionManager();
            GO[] gOArray = diagramSelectionManager.getSelections();
            ArrayList<GO> arrayList = new ArrayList<GO>();
            for (int i = 0; i < gOArray.length; ++i) {
                boolean bl2 = true;
                if (gOArray[i] instanceof InputGO) {
                    bl2 = false;
                }
                if (gOArray[i] instanceof OutputGO) {
                    bl2 = false;
                } else if (!bl && gOArray[i] instanceof DataStoreGO) {
                    bl2 = false;
                }
                if (bl2) continue;
                arrayList.add(gOArray[i]);
                diagramSelectionManager.removeSelection(gOArray[i]);
            }
            XmlExtras.cutToClipboard((Diagram)SubCanvasPanel.this.m_Diagram);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                diagramSelectionManager.addSelection((GO)iterator.next());
            }
            SubCanvasPanel.this.m_Canvas.requestFocus();
        }
    }

    private class CopyAction
    extends EnsembleAction {
        public CopyAction() {
            super("CanvasPanel.Copy");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = EnsembleOptions.allowDataStores();
            DiagramSelectionManager diagramSelectionManager = DiagramExtras.getWrapper((Diagram)SubCanvasPanel.this.m_Diagram).getSelectionManager();
            GO[] gOArray = diagramSelectionManager.getSelections();
            ArrayList<GO> arrayList = new ArrayList<GO>();
            for (int i = 0; i < gOArray.length; ++i) {
                boolean bl2 = true;
                if (gOArray[i] instanceof InputGO) {
                    bl2 = false;
                }
                if (gOArray[i] instanceof OutputGO) {
                    bl2 = false;
                } else if (!bl && gOArray[i] instanceof DataStoreGO) {
                    bl2 = false;
                }
                if (bl2) continue;
                arrayList.add(gOArray[i]);
                diagramSelectionManager.removeSelection(gOArray[i]);
            }
            XmlExtras.copyToClipboard((Diagram)SubCanvasPanel.this.m_Diagram);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                diagramSelectionManager.addSelection((GO)iterator.next());
            }
            SubCanvasPanel.this.m_Canvas.requestFocus();
        }
    }

    private class PasteAction
    extends EnsembleAction {
        public PasteAction() {
            super("CanvasPanel.Paste");
            this.setEnabled(DiagramExtras.getWrapper((Diagram)SubCanvasPanel.this.m_Diagram).isEditable());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                XmlExtras.pasteFromClipboard((Diagram)SubCanvasPanel.this.m_Diagram);
                SubCanvasPanel.this.m_Canvas.requestFocus();
            }
            catch (Throwable throwable) {
                SubCanvasPanel.this.m_Context.displayWarning(I18N.ENSEMBLE.getString("CanvasPanel.CANT_PASTE") + " " + String.valueOf(throwable));
            }
        }
    }

    private class ZoomListener
    implements ItemListener {
        private ZoomListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = ZOOM_PERCENTS[SubCanvasPanel.this.m_Zoom.getSelectedIndex()];
            DiagramExtras.getWrapper((Diagram)SubCanvasPanel.this.m_Diagram).setZoomPercent(n);
        }
    }

    private class CloseAction
    extends EnsembleAction {
        public CloseAction() {
            super("SubCanvasPanel.Close");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
            DSPanel dSPanel = (DSPanel)iViewModel.getCurrentView();
            dSPanel.popCanvas();
        }
    }
}

