/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.toolbox;

import com.elixirtech.canvas.diagram.ICanvas;
import com.elixirtech.canvas.diagram.MouseTool;
import com.elixirtech.canvas.extras.DiagramExtras$;
import com.elixirtech.canvas.toolbox.IToolbox;
import com.elixirtech.canvas.toolbox.ToolBarBuilder$DefaultButton$;
import com.elixirtech.canvas.toolbox.ToolBarBuilder$ToolAction$;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class ToolBarBuilder
implements IToolbox {
    private final JToolBar m_ToolBar;
    private final ICanvas m_Canvas;
    private final ButtonGroup buttonGroup;
    private final Option defaultButton;

    public ToolBarBuilder(JToolBar m_ToolBar, ICanvas m_Canvas) {
        this.m_ToolBar = m_ToolBar;
        this.m_Canvas = m_Canvas;
        this.buttonGroup = new ButtonGroup();
        this.defaultButton = this.buildTools();
    }

    public ButtonGroup buttonGroup() {
        return this.buttonGroup;
    }

    public Option<DefaultButton> defaultButton() {
        return this.defaultButton;
    }

    public Component getComponent() {
        return this.m_ToolBar;
    }

    @Override
    public void setDefaultSelection() {
        this.defaultButton().foreach((Function1)(JProcedure1 & Serializable)db -> {
            db.button().setSelected(true);
            this.m_Canvas.setTool(db.tool());
        });
    }

    /*
     * WARNING - void declaration
     */
    public Option<DefaultButton> buildTools() {
        None$ none$;
        try {
            void var2_2;
            List choices = DiagramExtras$.MODULE$.getToolboxChoices().map((Function1 & Serializable)choice -> {
                String name = choice.getChoiceName();
                Icon icon = choice.getChoiceIcon();
                MouseTool tool = choice.getMouseTool();
                tool.setToolbox(this);
                AbstractButton button = this.addTool(name, tool, icon);
                return ToolBarBuilder$DefaultButton$.MODULE$.apply(button, tool);
            });
            Option ret = choices.headOption();
            ret.foreach((Function1)(JProcedure1 & Serializable)db -> this.m_Canvas.setTool(db.tool()));
            none$ = var2_2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private AbstractButton addTool(String name, MouseTool tool, Icon icon) {
        ToolAction action = ToolBarBuilder$ToolAction$.MODULE$.apply(this.m_Canvas, name, tool, icon);
        JToggleButton button = new JToggleButton(action);
        this.buttonGroup().add(button);
        this.m_ToolBar.add(button);
        return button;
    }

    public static final class DefaultButton
    implements Product,
    Serializable {
        private final AbstractButton button;
        private final MouseTool tool;

        public static DefaultButton apply(AbstractButton abstractButton, MouseTool mouseTool) {
            return ToolBarBuilder$DefaultButton$.MODULE$.apply(abstractButton, mouseTool);
        }

        public static DefaultButton fromProduct(Product product) {
            return ToolBarBuilder$DefaultButton$.MODULE$.fromProduct(product);
        }

        public static DefaultButton unapply(DefaultButton defaultButton) {
            return ToolBarBuilder$DefaultButton$.MODULE$.unapply(defaultButton);
        }

        public DefaultButton(AbstractButton button, MouseTool tool) {
            this.button = button;
            this.tool = tool;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DefaultButton)) return false;
            DefaultButton defaultButton = (DefaultButton)object;
            AbstractButton abstractButton = this.button();
            AbstractButton abstractButton2 = defaultButton.button();
            if (abstractButton == null) {
                if (abstractButton2 != null) {
                    return false;
                }
            } else if (!abstractButton.equals(abstractButton2)) return false;
            MouseTool mouseTool = this.tool();
            MouseTool mouseTool2 = defaultButton.tool();
            if (mouseTool == null) {
                if (mouseTool2 == null) return true;
                return false;
            } else {
                if (!mouseTool.equals(mouseTool2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DefaultButton;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DefaultButton";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "button";
            }
            if (1 == n2) {
                return "tool";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public AbstractButton button() {
            return this.button;
        }

        public MouseTool tool() {
            return this.tool;
        }

        public DefaultButton copy(AbstractButton button, MouseTool tool) {
            return new DefaultButton(button, tool);
        }

        public AbstractButton copy$default$1() {
            return this.button();
        }

        public MouseTool copy$default$2() {
            return this.tool();
        }

        public AbstractButton _1() {
            return this.button();
        }

        public MouseTool _2() {
            return this.tool();
        }
    }

    public static final class ToolAction
    extends AbstractAction
    implements Product {
        private final ICanvas canvas;
        private final String name;
        private final MouseTool tool;
        private final Icon icon;

        public static ToolAction apply(ICanvas iCanvas, String string, MouseTool mouseTool, Icon icon) {
            return ToolBarBuilder$ToolAction$.MODULE$.apply(iCanvas, string, mouseTool, icon);
        }

        public static ToolAction fromProduct(Product product) {
            return ToolBarBuilder$ToolAction$.MODULE$.fromProduct(product);
        }

        public static ToolAction unapply(ToolAction toolAction) {
            return ToolBarBuilder$ToolAction$.MODULE$.unapply(toolAction);
        }

        public ToolAction(ICanvas canvas, String name, MouseTool tool, Icon icon) {
            this.canvas = canvas;
            this.name = name;
            this.tool = tool;
            this.icon = icon;
            super(null, icon);
            this.putValue("ShortDescription", name);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ToolAction)) return false;
            ToolAction toolAction = (ToolAction)object;
            ICanvas iCanvas = this.canvas();
            ICanvas iCanvas2 = toolAction.canvas();
            if (iCanvas == null) {
                if (iCanvas2 != null) {
                    return false;
                }
            } else if (!iCanvas.equals(iCanvas2)) return false;
            String string = this.name();
            String string2 = toolAction.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            MouseTool mouseTool = this.tool();
            MouseTool mouseTool2 = toolAction.tool();
            if (mouseTool == null) {
                if (mouseTool2 != null) {
                    return false;
                }
            } else if (!mouseTool.equals(mouseTool2)) return false;
            Icon icon = this.icon();
            Icon icon2 = toolAction.icon();
            if (icon == null) {
                if (icon2 == null) return true;
                return false;
            } else {
                if (!icon.equals(icon2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ToolAction;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "ToolAction";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "canvas";
                }
                case 1: {
                    return "name";
                }
                case 2: {
                    return "tool";
                }
                case 3: {
                    return "icon";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ICanvas canvas() {
            return this.canvas;
        }

        public String name() {
            return this.name;
        }

        public MouseTool tool() {
            return this.tool;
        }

        public Icon icon() {
            return this.icon;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.canvas().setTool(this.tool());
        }

        public ToolAction copy(ICanvas canvas, String name, MouseTool tool, Icon icon) {
            return new ToolAction(canvas, name, tool, icon);
        }

        public ICanvas copy$default$1() {
            return this.canvas();
        }

        public String copy$default$2() {
            return this.name();
        }

        public MouseTool copy$default$3() {
            return this.tool();
        }

        public Icon copy$default$4() {
            return this.icon();
        }

        public ICanvas _1() {
            return this.canvas();
        }

        public String _2() {
            return this.name();
        }

        public MouseTool _3() {
            return this.tool();
        }

        public Icon _4() {
            return this.icon();
        }
    }
}

