/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.util;

import com.elixirtech.canvas.geometry.RectangleEx;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class Arrow {
    public static void drawLineOpenArrow(Graphics graphics, Point point, Point point2, double d, double d2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (point.equals(point2)) {
            return;
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        graphics2D.translate(point2.x, point2.y);
        double d3 = point.y - point2.y;
        double d4 = point.x - point2.x;
        double d5 = 0.0;
        if (d4 != 0.0) {
            d5 = Math.atan(d3 / d4);
        } else {
            double d6 = d5 = d3 < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (d4 < 0.0) {
            d5 -= Math.PI;
        }
        graphics2D.rotate(d5);
        double d7 = d * Math.PI / 180.0;
        int n = (int)(d2 * Math.cos(d7));
        int n2 = (int)(d2 * Math.sin(d7));
        graphics.drawLine(0, 0, n, n2);
        graphics.drawLine(0, 0, n, -n2);
        graphics2D.setTransform(affineTransform);
    }

    public static void drawLineFilledArrow(Graphics graphics, Point point, Point point2, double d, double d2, Color color) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (point.equals(point2)) {
            return;
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        graphics2D.translate(point2.x, point2.y);
        double d3 = point.y - point2.y;
        double d4 = point.x - point2.x;
        double d5 = 0.0;
        if (d4 != 0.0) {
            d5 = Math.atan(d3 / d4);
        } else {
            double d6 = d5 = d3 < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (d4 < 0.0) {
            d5 -= Math.PI;
        }
        graphics2D.rotate(d5);
        double d7 = d * Math.PI / 180.0;
        int n = (int)(d2 * Math.cos(d7));
        int n2 = (int)(d2 * Math.sin(d7));
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(n, n2);
        polygon.addPoint(n, -n2);
        graphics.setColor(color);
        graphics.fillPolygon(polygon);
        graphics2D.setTransform(affineTransform);
    }

    public static RectangleEx getRectangle(Point point, Point point2, double d, double d2) {
        if (point.equals(point2)) {
            return new RectangleEx(point, point2);
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(point2.x, point2.y);
        double d3 = point.y - point2.y;
        double d4 = point.x - point2.x;
        double d5 = 0.0;
        if (d4 != 0.0) {
            d5 = Math.atan(d3 / d4);
        } else {
            double d6 = d5 = d3 < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (d4 < 0.0) {
            d5 -= Math.PI;
        }
        affineTransform.rotate(d5);
        double d7 = d * Math.PI / 180.0;
        int n = (int)(d2 * Math.cos(d7));
        int n2 = (int)(d2 * Math.sin(d7));
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(n, n2);
        generalPath.lineTo(n, -n2);
        generalPath.closePath();
        try {
            Shape shape = generalPath.createTransformedShape(affineTransform.createInverse());
            Rectangle rectangle = shape.getBounds();
            return new RectangleEx(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new RectangleEx(point, point2);
        }
    }
}

