/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.composite.plot.ui;

import com.elixirtech.arch.categorytype.CategoryTypeSelectionPanel;
import com.elixirtech.arch.categorytype.ICategoryType;
import com.elixirtech.arch.categorytype.ICategoryTypeRegistry;
import com.elixirtech.chart2.composite.plot.ui.SubPlotRegistryCategory;
import com.elixirtech.chart2.composite.plot.ui.SubPlotRegistryXY;
import com.elixirtech.chart2.composite.plot.ui.SubPlotWizard;
import com.elixirtech.chart2.model.CategoryType;
import com.elixirtech.chart2.model.CategoryUi;
import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.ControlSourceList;
import com.elixirtech.chart2.model.SubPlot;
import com.elixirtech.chart2.model.XYType;
import com.elixirtech.chart2.model.XYUi;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.WizardPage;
import java.awt.BorderLayout;

public class ChooseSubPlotPage
extends WizardPage
implements IFinishPage {
    public static final String NAME = "ChooseSubChartPage";
    private SubPlotWizard m_ChartSubChartWiz;
    private SubPlot m_SubPlot;
    protected CategoryTypeSelectionPanel m_CategoryTypeSelectionPanel;
    protected ICategoryType m_CategoryType = new CT();
    protected ICategoryTypeRegistry m_CategoryRegistry;
    protected boolean m_Initialized;

    public ChooseSubPlotPage() {
        super(NAME, "Data");
        this.setTitle(Messages.getString("ChooseChartPage.CHART_TYPE_SELECTION"));
        this.setMessage(Messages.getString("ChooseChartPage.MESSAGE"));
    }

    @Override
    public void doFinish() {
        if (this.m_Initialized) {
            this.updateChartType();
        }
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_ChartSubChartWiz = (SubPlotWizard)iWizard;
        this.m_SubPlot = this.m_ChartSubChartWiz.getSubPlot();
        String string = this.m_ChartSubChartWiz.getCompositeChartType();
        this.m_CategoryTypeSelectionPanel = string.endsWith("CategoryPlot") ? new SubPlotCategoryTypePanel(this.m_CategoryType, SubPlotRegistryCategory.REGISTRY) : new SubPlotCategoryTypePanel(this.m_CategoryType, SubPlotRegistryXY.REGISTRY);
        this.m_Component.setLayout(new BorderLayout());
        this.m_Component.add("Center", this.m_CategoryTypeSelectionPanel);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            if (!this.m_Initialized) {
                ChartType chartType = this.m_SubPlot.getChartType();
                if (chartType == null) {
                    this.updateChartType();
                }
                this.m_Initialized = true;
            }
            this.m_CategoryTypeSelectionPanel.setEnabled(!this.m_Wizard.isReadOnly());
        } else if (this.m_Initialized) {
            this.updateChartType();
        }
        this.m_CategoryTypeSelectionPanel.updateFields();
    }

    private void updateChartType() {
        String string = this.m_SubPlot.getCompositeChart().getType();
        com.elixirtech.chart2.model.ICategoryType iCategoryType = (com.elixirtech.chart2.model.ICategoryType)this.m_SubPlot.getChartType();
        if (string.endsWith("XYPlot")) {
            XYType xYType = null;
            if (iCategoryType == null || !(iCategoryType instanceof XYType)) {
                xYType = new XYType();
                xYType.setKeySource(new ControlSource());
                xYType.setValueSource(new ControlSourceList());
                XYUi xYUi = new XYUi();
                xYUi.init();
                xYType.setXYUi(xYUi);
                this.m_SubPlot.setChartType((ChartType)xYType);
                this.m_SubPlot.setCategory("XY-Category");
                this.m_SubPlot.setType("XY-Line");
            }
        } else {
            CategoryType categoryType = null;
            if (iCategoryType == null || !(iCategoryType instanceof CategoryType)) {
                categoryType = new CategoryType();
                categoryType.setKeySource(new ControlSource());
                categoryType.setValueSource(new ControlSourceList());
                CategoryUi categoryUi = new CategoryUi();
                categoryUi.init();
                categoryType.setCategoryUi(categoryUi);
                this.m_SubPlot.setChartType((ChartType)categoryType);
                this.m_SubPlot.setCategory("Column-Category");
                this.m_SubPlot.setType("Column");
            }
        }
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.getNextPage() != null;
    }

    @Override
    public boolean isPageComplete() {
        if (!this.m_Initialized) {
            return false;
        }
        this.setError(null);
        boolean bl = true;
        if (this.m_CategoryType.getCategory() == null) {
            this.setError(Messages.getString("ChooseChartPage.REMINDER1"));
            bl = false;
        } else if (this.m_CategoryType.getType() == null) {
            this.setError(Messages.getString("ChooseChartPage.REMINDER2"));
            bl = false;
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }

    public com.elixirtech.chart2.model.ICategoryType getChartType() {
        return (com.elixirtech.chart2.model.ICategoryType)this.m_SubPlot.getChartType();
    }

    private class CT
    implements ICategoryType {
        private CT() {
        }

        @Override
        public String getCategory() {
            return ChooseSubPlotPage.this.m_SubPlot.getCategory();
        }

        @Override
        public void setCategory(String string) {
            ChooseSubPlotPage.this.m_SubPlot.setCategory(string);
            ChooseSubPlotPage.this.m_Wizard.getContainer().updateButtons();
        }

        @Override
        public String getType() {
            return ChooseSubPlotPage.this.m_SubPlot.getType();
        }

        @Override
        public void setType(String string) {
            ChooseSubPlotPage.this.m_SubPlot.setType(string);
            ChooseSubPlotPage.this.m_Wizard.getContainer().updateButtons();
        }
    }

    static class SubPlotCategoryTypePanel
    extends CategoryTypeSelectionPanel {
        public SubPlotCategoryTypePanel(ICategoryType iCategoryType, ICategoryTypeRegistry iCategoryTypeRegistry) {
            super(iCategoryType, iCategoryTypeRegistry);
        }
    }
}

