/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.composite.plot.ui;

import com.elixirtech.arch.wizard.TabbedWizardPage;
import com.elixirtech.chart2.composite.plot.ui.ChooseSubPlotPage;
import com.elixirtech.chart2.composite.plot.ui.SubPlotWizard;
import com.elixirtech.chart2.model.ICategoryType;
import com.elixirtech.chart2.model.SubPlot;
import com.elixirtech.chart2.ui.DataListTab;
import com.elixirtech.chart2.ui.DataTab;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizard;

public class DataPage
extends TabbedWizardPage
implements IFinishPage {
    public static final String NAME = "Data";
    private SubPlotWizard m_SubPlotWizard;
    private DataTab m_DataTab;
    private DataListTab m_ValuesTab;
    private boolean m_Initialized;

    public DataPage() {
        super(NAME, null);
        this.setTitle(Messages.getString("DataPage.TITLE"));
        this.setMessage(Messages.getString("DataPage.MESSAGE"));
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_SubPlotWizard = (SubPlotWizard)this.m_Wizard;
        this.buildTabs();
    }

    protected void updatePanels() {
        this.m_DataTab.updatePanels(this.m_Wizard);
        this.m_ValuesTab.updatePanels(this.m_Wizard);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            SubPlot subPlot = this.m_SubPlotWizard.getSubPlot();
            boolean bl2 = subPlot.getCategory().startsWith("XY");
            this.m_DataTab.setShowDate(bl2);
            this.m_DataTab.setShowNumeric(bl2);
            this.updatePanels();
            if (!this.m_Initialized) {
                this.init((ICategoryType)subPlot.getChartType());
                this.m_Initialized = true;
            }
        }
    }

    protected void init(ICategoryType iCategoryType) {
        this.m_DataTab.setControlSource(iCategoryType.getKeySource());
        this.m_ValuesTab.setControlSourceList(iCategoryType.getValueSource());
    }

    protected void buildTabs() {
        this.m_DataTab = new DataTab(Messages.getString("CategoryPage.KEY"), 5, false){

            @Override
            public void exited() {
                ChooseSubPlotPage chooseSubPlotPage = (ChooseSubPlotPage)DataPage.this.getWizard().getPage("ChooseSubChartPage");
                ICategoryType iCategoryType = chooseSubPlotPage.getChartType();
                iCategoryType.setKeySource(this.getControlSource());
            }
        };
        this.addTab(this.m_DataTab);
        this.m_ValuesTab = new DataListTab(this.m_Wizard, Messages.getString("CategoryPage.VALUES"), this.getValuesTypes());
        this.addTab(this.m_ValuesTab);
    }

    @Override
    public void doFinish() {
        this.m_DataTab.exited();
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    protected int getValuesTypes() {
        return 135;
    }
}

