/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.composite.plot.ui;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.IChartData;
import com.elixirtech.chart2.model.SubPlot;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.ensemble.wizard.result.ResultSchemaPanel;
import com.elixirtech.erd.reportdesigner.data.AddDataSourceWizard;
import com.elixirtech.erd.util.ReportUtil;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.WizardPage;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.chart.IReportInfoProvider;
import com.elixirtech.wizard.data.FieldPanel;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;

public class DataSourcePage
extends WizardPage
implements IChartData,
IFinishPage {
    public static final String NAME = "DataSource";
    private SubPlot m_ChartElement;
    private IReportInfoProvider m_ReportInfo;
    private DataSchema m_Schema;
    private boolean m_Initialized;
    private JComboBox m_DataSources;
    private JRadioButton m_OverRecord;
    private JRadioButton m_OverGroup;
    private JRadioButton m_OverAll;
    private ResultSchemaPanel m_SchemaPanel;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DataSourcePage.class);

    public DataSourcePage(SubPlot subPlot, IReportInfoProvider iReportInfoProvider) {
        super(NAME, "ChooseSubChartPage");
        this.m_ReportInfo = iReportInfoProvider;
        this.m_ChartElement = subPlot;
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        ArchLayout archLayout = new ArchLayout();
        this.m_Component.setLayout(archLayout);
        this.m_Component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Component.add(SwingFactory.newLabel("DS.label"));
        this.m_DataSources = SwingFactory.newComboBox("ds", this.getDataSources());
        this.m_Component.add(this.m_DataSources);
        this.m_DataSources.addItemListener(new CodeBlock((Object)this, "dsSelection"));
        this.m_Component.add(SwingFactory.newButton("ADD.dots", new CodeBlock((Object)this, "addDataSource")));
        this.m_OverAll = SwingFactory.newRadioButton("DSGROUP.over-all");
        this.m_Component.add(this.m_OverAll);
        this.m_OverGroup = SwingFactory.newRadioButton("DSGROUP.over-group");
        this.m_Component.add(this.m_OverGroup);
        this.m_OverRecord = SwingFactory.newRadioButton("DSGROUP.over-record");
        this.m_Component.add(this.m_OverRecord);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_OverGroup);
        buttonGroup.add(this.m_OverAll);
        buttonGroup.add(this.m_OverRecord);
        this.m_SchemaPanel = new ResultSchemaPanel(true);
        this.m_SchemaPanel.setEnabled(false);
        this.m_SchemaPanel.setRowSelectionAllowed(false);
        this.m_Component.add("schema", this.m_SchemaPanel);
        archLayout.stickLeft("DS.label");
        archLayout.stickTop("ds");
        archLayout.vCenter("DS.label", "ds");
        archLayout.putRight("ds", "DS.label", 10);
        archLayout.stickTop("ADD.dots");
        archLayout.stickRight("ADD.dots");
        archLayout.setHeight("ADD.dots", "ds");
        archLayout.putLeft("ds", "ADD.dots");
        archLayout.alignBelow("DSGROUP.over-all", "ds", 5);
        archLayout.putRight("DSGROUP.over-group", "DSGROUP.over-all", 10);
        archLayout.putRight("DSGROUP.over-record", "DSGROUP.over-group", 10);
        archLayout.putBelow("DSGROUP.over-group", "ds", 5);
        archLayout.putBelow("DSGROUP.over-record", "ds", 5);
        archLayout.putBelow("schema", "DSGROUP.over-record", 5);
        archLayout.stickLeft("schema");
        archLayout.stickRight("schema");
        archLayout.stickBottom("schema");
        I18N.ERD_MAP.injectComponents("DataSourcePage.", this.m_Component);
        I18N.ERD_MAP.injectObject(null, this, "DataSourcePage");
    }

    @Override
    public boolean canFlipToNextPage() {
        return true;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!this.m_Initialized && bl) {
            String string = this.m_ChartElement.getDataScope().getDataSourceName();
            if (StringUtil.isEmpty(string)) {
                string = FieldPanel.SECTION_DATASOURCE_UI;
            }
            this.m_DataSources.setSelectedItem(string);
            String string2 = this.m_ChartElement.getDataScope().getRange();
            if ("All".equals(string2)) {
                this.m_OverAll.setSelected(true);
            } else if ("Group".equals(string2)) {
                this.m_OverGroup.setSelected(true);
            } else if ("Record".equals(string2)) {
                this.m_OverRecord.setSelected(true);
            }
            this.dsSelection();
            this.m_Initialized = true;
        }
    }

    public String getDataSourcePath() {
        String string = (String)this.m_DataSources.getSelectedItem();
        DataSource dataSource = this.m_ReportInfo.getRawReport().getDataSource(string);
        if (dataSource != null) {
            return dataSource.getDataSourceName();
        }
        return null;
    }

    public String getDataSourceRange() {
        if (this.m_OverAll.isSelected()) {
            return "All";
        }
        if (this.m_OverGroup.isSelected()) {
            return "Group";
        }
        return "Record";
    }

    public DataSchema getSchema() {
        return this.m_Schema;
    }

    public void addDataSource() {
        DataSource dataSource = new DataSource();
        dataSource.setName(ReportUtil.getNextDataSourceName(this.m_ReportInfo.getRawReport()));
        AddDataSourceWizard addDataSourceWizard = new AddDataSourceWizard(this.m_ReportInfo.getRawReport(), dataSource);
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        elixirFrame.showWizard(addDataSourceWizard);
        if (addDataSourceWizard.isFinished()) {
            this.m_DataSources.setModel(new DefaultComboBoxModel<String>(this.getDataSources()));
            this.m_DataSources.setSelectedItem(dataSource.getName());
            this.dsSelection();
        }
    }

    public void dsSelection() {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        String string = (String)this.m_DataSources.getSelectedItem();
        if (string != null) {
            this.m_Schema = null;
            if (FieldPanel.SECTION_DATASOURCE_UI.equals(string)) {
                string = this.getSection().getDataSource();
            }
            try {
                DataSource dataSource = this.m_ReportInfo.getRawReport().getDataSource(string);
                if (dataSource != null) {
                    IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, dataSource.getDataSourceName());
                    this.m_Schema = iDataSource.getSchema();
                }
            }
            catch (Throwable throwable) {
                m_Log.error((Object)(string + "error: " + throwable.toString()), throwable);
            }
        }
        this.m_SchemaPanel.setSchema(this.m_Schema, new HashSet<String>());
        if (this.m_Schema != null && this.m_Schema.getColumnCount() > 0) {
            this.m_SchemaPanel.setSelectedName(this.m_Schema.getColumnName(0));
        }
        if (this.m_Wizard.getContainer() != null) {
            this.m_Wizard.getContainer().updateButtons();
        }
    }

    protected Vector<String> getDataSources() {
        Vector<String> vector = new Vector<String>();
        if (this.m_ReportInfo != null) {
            int n = this.m_ReportInfo.getRawReport().getDataSourceCount();
            for (int i = 0; i < n; ++i) {
                vector.addElement(this.m_ReportInfo.getRawReport().getDataSource(i).getName());
            }
            if (StringUtil.notEmpty(this.getSection().getDataSource())) {
                vector.add(0, FieldPanel.SECTION_DATASOURCE_UI);
            }
        }
        return vector;
    }

    protected Section getSection() {
        Chunk chunk = this.m_ReportInfo.getChunk();
        return chunk.getSection();
    }

    @Override
    public void doFinish() {
        if (this.m_Initialized) {
            String string = (String)this.m_DataSources.getSelectedItem();
            if (FieldPanel.SECTION_DATASOURCE_UI.equals(string)) {
                this.m_ChartElement.getDataScope().setDataSourceName("");
            } else {
                this.m_ChartElement.getDataScope().setDataSourceName(string);
            }
            String string2 = null;
            string2 = this.m_OverAll.isSelected() ? "All" : (this.m_OverGroup.isSelected() ? "Group" : "Record");
            this.m_ChartElement.getDataScope().setRange(string2);
        }
    }
}

