/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.composite.plot.ui;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.IChartData;
import com.elixirtech.chart2.IChartHolder;
import com.elixirtech.chart2.IChartWizard;
import com.elixirtech.chart2.composite.plot.ui.ChooseSubPlotPage;
import com.elixirtech.chart2.composite.plot.ui.DataPage;
import com.elixirtech.chart2.composite.plot.ui.DataSourcePage;
import com.elixirtech.chart2.model.SubPlot;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.icons.ChartIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.wizard.chart.IReportInfoProvider;

public class SubPlotWizard
extends Wizard
implements IChartWizard,
IChartData {
    public static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(SubPlotWizard.class);
    private IReportInfoProvider m_Report;
    private SubPlot m_SubPlot;
    private String m_CompositeChartType;

    public SubPlotWizard(IReportInfoProvider iReportInfoProvider, SubPlot subPlot, String string, boolean bl) {
        super(I18N.ERD.getString("ChartWizard.title"));
        m_Log.debug((Object)"Construction");
        this.setReadOnly(bl);
        this.m_SubPlot = subPlot;
        this.m_Report = iReportInfoProvider;
        this.m_CompositeChartType = string;
        this.buildPages();
    }

    protected void buildPages() {
        this.addPage(new DataSourcePage(this.m_SubPlot, this.m_Report));
        this.addPage(new ChooseSubPlotPage());
        this.addPage(new DataPage());
        for (IWizardPage iWizardPage : this.m_Pages) {
            m_Log.debug((Object)("setWizard page: " + iWizardPage.getName()));
            iWizardPage.setWizard(this);
            iWizardPage.setIcon(ChartIcons.CHART_IMAGE);
        }
    }

    private void addPage(IWizardPage iWizardPage) {
        m_Log.debug((Object)("Adding page: " + iWizardPage.getName()));
        this.m_Pages.add(iWizardPage);
    }

    public IChartHolder getChartHolder() {
        return null;
    }

    public String getDataSourcePath() {
        DataSourcePage dataSourcePage = (DataSourcePage)this.getPage("DataSource");
        return dataSourcePage.getDataSourcePath();
    }

    public String getDataSourceRange() {
        DataSourcePage dataSourcePage = (DataSourcePage)this.getPage("DataSource");
        return dataSourcePage.getDataSourceRange();
    }

    public DataSchema getSchema() {
        DataSourcePage dataSourcePage = (DataSourcePage)this.getPage("DataSource");
        return dataSourcePage.getSchema();
    }

    public SubPlot getSubPlot() {
        return this.m_SubPlot;
    }

    public String getCompositeChartType() {
        return this.m_CompositeChartType;
    }

    @Override
    public boolean canFinish() {
        if (this.isReadOnly()) {
            return false;
        }
        IWizardPage iWizardPage = this.getPage("ChooseSubChartPage");
        return iWizardPage.isPageComplete();
    }

    @Override
    public boolean performFinish() {
        super.performFinish();
        DataSourcePage dataSourcePage = (DataSourcePage)this.getPage("DataSource");
        dataSourcePage.doFinish();
        ChooseSubPlotPage chooseSubPlotPage = (ChooseSubPlotPage)this.getPage("ChooseSubChartPage");
        chooseSubPlotPage.doFinish();
        DataPage dataPage = (DataPage)this.getPage("Data");
        dataPage.doFinish();
        return true;
    }
}

