/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.composite.ui;

import com.elixirtech.chart2.composite.ui.ChooseCompositeChartPage;
import com.elixirtech.chart2.composite.ui.CompositeAxesValueTab;
import com.elixirtech.chart2.composite.ui.TitleTab;
import com.elixirtech.chart2.model.CompositeChart;
import com.elixirtech.chart2.model.CompositeChartType;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.Legend;
import com.elixirtech.chart2.model.Title;
import com.elixirtech.chart2.ui.IPreviewTab;
import com.elixirtech.chart2.ui.LegendPaintTab;
import com.elixirtech.chart2.ui.LegendTab;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.ScriptTab;
import com.elixirtech.chart2.ui.TypeSpecificPage;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.util.ClassUtil;

public class ChartConfigPage
extends TypeSpecificPage
implements IFinishPage {
    public static String NAME = "Config";
    private CompositeAxesValueTab m_CompositeAxesValueTab;
    private TitleTab m_TitleTab;
    private LegendTab m_LegendTab;
    private LegendPaintTab m_LegendPaintTab;

    public ChartConfigPage() {
        super(NAME);
        this.setTitle(Messages.getString("ChartConfigPage.TITLE"));
        this.setMessage(Messages.getString("ChartConfigPage.MESSAGE"));
    }

    @Override
    protected void init(IChart iChart) {
        Title title = iChart.getChartType().getTitle();
        this.m_TitleTab.setTitle(title);
        Legend legend = iChart.getChartType().getLegend();
        this.m_LegendTab.setLegend(legend);
        this.m_LegendPaintTab.setLegend(legend);
        this.m_CompositeAxesValueTab.init(iChart);
        super.init(iChart);
        this.updatePanels();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            IChart iChart = this.getChart();
            if (!this.m_Initialized) {
                this.init(iChart);
            }
        }
        super.setVisible(bl);
    }

    @Override
    protected void buildTabs() {
        this.m_TitleTab = new TitleTab(){

            @Override
            public void exited() {
                CompositeChart compositeChart = (CompositeChart)ChartConfigPage.this.getChart();
                compositeChart.getChartType().setTitle(ChartConfigPage.this.m_TitleTab.getTitle());
            }
        };
        this.addTab(this.m_TitleTab);
        this.m_LegendTab = new LegendTab(){

            @Override
            public void exited() {
                CompositeChart compositeChart = (CompositeChart)ChartConfigPage.this.getChart();
                compositeChart.getChartType().setLegend(ChartConfigPage.this.m_LegendTab.getLegend());
            }
        };
        this.addTab(this.m_LegendTab);
        this.m_LegendPaintTab = new LegendPaintTab(){

            @Override
            public void exited() {
                CompositeChart compositeChart = (CompositeChart)ChartConfigPage.this.getChart();
                ChartConfigPage.this.m_LegendPaintTab.updateLegend(compositeChart.getChartType().getLegend());
            }
        };
        this.addTab(this.m_LegendPaintTab);
        this.m_CompositeAxesValueTab = new CompositeAxesValueTab();
        this.addTab(this.m_CompositeAxesValueTab);
        this.m_ScriptTab = new ScriptTab(this);
        this.addTab(this.m_ScriptTab);
        this.m_PreviewTab = (IPreviewTab)ClassUtil.newInstance("com.elixirtech.chart2.composite.ui.CompositeChartPreviewTab");
        if (this.m_PreviewTab != null) {
            this.m_PreviewTab.setWizard(this.m_Wizard);
            this.addTab(this.m_PreviewTab);
        }
    }

    @Override
    protected void ensureChartType(IChart iChart) {
    }

    @Override
    public IChart getChart() {
        ChooseCompositeChartPage chooseCompositeChartPage = (ChooseCompositeChartPage)this.m_Wizard.getPage("ChooseCompositeChart");
        return chooseCompositeChartPage.getChart();
    }

    public void updatePanels() {
        this.m_TitleTab.updatePanels(this.m_Wizard);
        this.m_LegendTab.updatePanels(this.m_Wizard);
        this.m_LegendPaintTab.updatePanels(this.m_Wizard);
        this.m_ScriptTab.updatePanels(this.m_Wizard);
        this.m_CompositeAxesValueTab.updatePanels(this.m_Wizard);
    }

    @Override
    protected void applyChanges(IChart iChart) {
        if (this.m_Initialized) {
            if (this.m_Current != null) {
                this.m_Current.exited();
            }
            CompositeChartType compositeChartType = (CompositeChartType)iChart.getChartType();
            compositeChartType.setTitle(this.m_TitleTab.getTitle());
            compositeChartType.setLegend(this.m_LegendTab.getLegend());
            this.m_LegendPaintTab.updateLegend(compositeChartType.getLegend());
            this.m_CompositeAxesValueTab.exited();
            super.applyChanges(iChart);
        }
    }
}

