/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.composite.ui;

import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.categorytype.CategoryTypeSelectionPanel;
import com.elixirtech.arch.categorytype.ICategoryType;
import com.elixirtech.arch.categorytype.ICategoryTypeRegistry;
import com.elixirtech.chart2.IChartHolder;
import com.elixirtech.chart2.composite.ui.CompositeChartRegistry;
import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.CompositeChart;
import com.elixirtech.chart2.model.CompositeChartSAX;
import com.elixirtech.chart2.model.CompositeChartType;
import com.elixirtech.chart2.model.CompositeChartUi;
import com.elixirtech.chart2.ui.ChooseChartPage;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.jdom.output.SAXOutputter;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.wizard.chart.CompositeChartWizard;
import java.awt.BorderLayout;
import org.xml.sax.ContentHandler;

public class ChooseCompositeChartPage
extends ChooseChartPage
implements IFinishPage {
    public static final String NAME = "ChooseCompositeChart";
    private CompositeCategoryTypePanel m_CompositeCategoryTypePanel;

    public ChooseCompositeChartPage() {
        super(NAME, "SubChartPlot");
        this.setTitle(Messages.getString("ChooseCompositeChartPage.CHART_TYPE_SELECTION"));
        this.setMessage(Messages.getString("ChooseCompositeChartPage.MESSAGE"));
        this.m_CategoryRegistry = CompositeChartRegistry.REGISTRY;
    }

    @Override
    public void setWizard(IWizard iWizard) {
        this.m_Wizard = iWizard;
        this.m_CompositeCategoryTypePanel = new CompositeCategoryTypePanel(this.m_CategoryType, this.m_CategoryRegistry, "1234567890134512345");
        this.m_Panel = this.m_CompositeCategoryTypePanel;
        this.m_Component.setLayout(new BorderLayout());
        this.m_Component.add("Center", this.m_Panel);
    }

    @Override
    public IWizardPage getNextPage() {
        return this.m_Wizard.getPage(this.m_NextPage);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && !this.m_Initialized) {
            SAXOutputter sAXOutputter;
            CompositeChartSAX compositeChartSAX;
            IChartHolder iChartHolder = ((CompositeChartWizard)this.m_Wizard).getChartHolder();
            Document document = iChartHolder.getChartDocument();
            if (document != null) {
                compositeChartSAX = new CompositeChartSAX();
                sAXOutputter = new SAXOutputter((ContentHandler)compositeChartSAX);
                try {
                    sAXOutputter.output(document);
                    this.m_Chart = (CompositeChart)compositeChartSAX.getObject();
                    this.m_Chart.loaded();
                    this.m_Panel.updateFields();
                }
                catch (JDOMException jDOMException) {
                    ElixirJ.error(Messages.getString("ChooseChartPage.ERROR1"), jDOMException);
                }
            }
            if (this.m_Chart == null) {
                this.m_Chart = new CompositeChart();
                this.m_Chart.setCategory("Combo");
                this.m_Chart.setType("Combo-CategoryPlot");
                this.m_Panel.updateFields();
                this.m_Panel.setEnabled(!this.m_Wizard.isReadOnly());
                compositeChartSAX = new CompositeChartType(this.m_Chart);
                sAXOutputter = new CompositeChartUi();
                compositeChartSAX.setCompositeChartUi((CompositeChartUi)sAXOutputter);
                sAXOutputter.init();
            } else {
                this.m_CompositeCategoryTypePanel.setEnabled(false);
            }
            this.m_Initialized = true;
        }
    }

    @Override
    public void doFinish() {
        if (this.m_Initialized) {
            ChartType chartType = this.m_Chart.getChartType();
            if (chartType == null) {
                CompositeChartType compositeChartType = new CompositeChartType(this.m_Chart);
                CompositeChartUi compositeChartUi = new CompositeChartUi();
                compositeChartType.setCompositeChartUi(compositeChartUi);
                compositeChartUi.init();
            }
            super.doFinish();
        }
    }

    private class CompositeCategoryTypePanel
    extends CategoryTypeSelectionPanel {
        public CompositeCategoryTypePanel(ICategoryType iCategoryType, ICategoryTypeRegistry iCategoryTypeRegistry, String string) {
            super(iCategoryType, iCategoryTypeRegistry, string);
        }

        public void setEnableListSelection(boolean bl) {
            this.setEnabled(bl);
        }
    }
}

