/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.composite.ui;

import com.elixirtech.chart2.model.Axis;
import com.elixirtech.chart2.model.CategoryUi;
import com.elixirtech.chart2.model.CompositeChartType;
import com.elixirtech.chart2.model.CompositeChartUi;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.ui.CategoryTab;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.ui.wizard.IWizard;

public class CompositeAxesValueTab
extends CategoryTab {
    private CompositeChartType m_CompositeType;

    @Override
    public void init(IChart iChart) {
        this.m_Chart = iChart;
        this.m_CompositeType = (CompositeChartType)iChart.getChartType();
        CompositeChartUi compositeChartUi = this.m_CompositeType.getCompositeChartUi();
        this.init((CategoryUi)compositeChartUi);
        Axis axis = this.m_CategoryUi.getKeyAxis();
        Axis axis2 = this.m_CategoryUi.getValueAxis();
        this.m_XAxisPanel.setAxis(axis);
        this.m_YAxisPanel.setAxis(axis2);
        this.updateAxisTickType();
        this.m_AxisTickLabelAnglePanel.setAxis(axis);
        this.m_ValuePanel.setValue(this.m_CategoryUi.getValue());
        this.m_Key.setVisible(false);
        this.m_AddSubCategory.setVisible(false);
        this.m_ValuePanel.setInverted(this.m_CompositeType.isInverted());
        this.m_RetainKeyOrder.setSelected(this.m_CompositeType.isRetainKeyOrder());
        this.m_DomainGridlinesVisible.setSelected(this.m_CategoryUi.isDomainGridlinesVisible());
        this.m_RangeGridlinesVisible.setSelected(this.m_CategoryUi.isRangeGridlinesVisible());
    }

    private void updateAxisTickType() {
        if (this.m_Chart.getType().endsWith("-XYPlot")) {
            this.m_ValuePanel.invertEnabled(false);
            this.m_AxisTickLabelAnglePanel.setDomainTickVertical(true);
        } else {
            this.m_ValuePanel.invertEnabled(true);
            this.m_AxisTickLabelAnglePanel.setDomainTickVertical(false);
        }
    }

    @Override
    public void entered() {
        this.updateAxisTickType();
    }

    @Override
    public void exited() {
        this.m_CategoryUi.setPlotBackground(this.m_Background.getColor());
        Axis axis = this.m_XAxisPanel.getAxis();
        Axis axis2 = this.m_YAxisPanel.getAxis();
        this.m_CategoryUi.setKeyAxis(axis);
        this.m_CategoryUi.setValueAxis(axis2);
        this.m_AxisTickLabelAnglePanel.updateAxis(axis);
        this.m_CategoryUi.setValue(this.m_ValuePanel.getValue());
        this.m_CompositeType.setInverted(this.m_ValuePanel.isInverted());
        this.m_CompositeType.setRetainKeyOrder(this.m_RetainKeyOrder.isSelected());
        this.m_CategoryUi.setDomainGridlinesVisible(this.m_DomainGridlinesVisible.isSelected());
        this.m_CategoryUi.setRangeGridlinesVisible(this.m_RangeGridlinesVisible.isSelected());
    }

    @Override
    public void updatePanels(IWizard iWizard) {
        super.updatePanels(iWizard);
    }

    @Override
    public String getMessage() {
        return Messages.getString("CompositeAxesValueTab.MESSAGE");
    }

    @Override
    public String getName() {
        return Messages.getString("CompositeAxesValueTab.TITLE");
    }
}

