/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.composite.ui;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.chart2.I18N;
import com.elixirtech.chart2.composite.plot.ui.SubPlotWizard;
import com.elixirtech.chart2.composite.ui.ChooseCompositeChartPage;
import com.elixirtech.chart2.model.CompositeChart;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.SubPlot;
import com.elixirtech.chart2.ui.IChartProvider;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.Name;
import com.elixirtech.ui.NumberDocument;
import com.elixirtech.ui.OrderedEditableTable;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.WizardPage;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.chart.CompositeChartWizard;
import com.elixirtech.wizard.chart.IReportInfoProvider;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;

public class SubPlotPage
extends WizardPage
implements IFinishPage,
IChartProvider {
    public static final String NAME = "SubChartPlot";
    public static String[] AXIS_LOCATIONS = new String[]{"top_or_left", "top_or_right", "bottom_or_left", "bottom_or_right"};
    public static String[] AXIS_18N_LOCATIONS = new String[]{"MultiAxis.TOP_LEFT", "MultiAxis.TOP_RIGHT", "MultiAxis.BOTTOM_LEFT", "MultiAxis.BOTTOM_RIGHT"};
    private HashMap<String, Name> m_MapNames = new HashMap();
    private Name[] m_Names;
    private I18NComboBox m_AxisChoice;
    private boolean m_Init;
    private JPanel m_Panel;
    private String m_ChartCategory;
    private CompositeChart m_CompositeChart;
    private SubChartPlotTable m_Table;
    private SubChartPlotModel m_ChartModel;
    private IReportInfoProvider m_Report;
    private JRadioButton m_Domain;
    private JRadioButton m_Range;
    private JTextField m_Gap;
    private JPanel m_GapPanel;

    public SubPlotPage(String string) {
        super(NAME, string);
        this.setTitle(Messages.getString("SubPlotPage.TITLE"));
        this.setMessage(Messages.getString("SubPlotPage.MESSAGE"));
    }

    private void buildUI() {
        this.m_Panel = (JPanel)this.getComponent();
        this.m_Panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 2, 5));
        this.m_Panel.setLayout(new BorderLayout());
        this.m_ChartModel = new SubChartPlotModel();
        this.m_Table = new SubChartPlotTable();
        this.m_Panel.add("Center", this.m_Table);
        this.m_Domain = new JRadioButton(I18N.CHART_UI.getString("CompositeAxis.DOMAIN"));
        this.m_Range = new JRadioButton(I18N.CHART_UI.getString("CompositeAxis.RANGE"));
        JLabel jLabel = SwingFactory.newLabel("gap");
        jLabel.setText(I18N.CHART_UI.getString("SubPlotPage.GAP"));
        this.m_Gap = new JTextField(5);
        this.m_Gap.setDocument(new NumberDocument());
        this.m_GapPanel = new JPanel();
        this.m_GapPanel.setLayout(new FlowLayout(2));
        this.m_GapPanel.add(jLabel);
        this.m_GapPanel.add(this.m_Gap);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_Domain);
        buttonGroup.add(this.m_Range);
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.m_Domain);
        jPanel.add(this.m_Range);
        jPanel.add(this.m_GapPanel);
        this.m_Panel.add("South", jPanel);
        this.m_Names = I18NComboBox.buildNames(AXIS_LOCATIONS, I18N.CHART_UI, AXIS_18N_LOCATIONS);
        for (int i = 0; i < this.m_Names.length; ++i) {
            this.m_MapNames.put(this.m_Names[i].getName(), this.m_Names[i]);
        }
        this.m_AxisChoice = I18NComboBox.apply(this.m_Names);
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        CompositeChartWizard compositeChartWizard = (CompositeChartWizard)iWizard;
        this.m_Report = compositeChartWizard.getReportProvider();
        this.buildUI();
    }

    @Override
    public void setVisible(boolean bl) {
        Serializable serializable;
        ChooseCompositeChartPage chooseCompositeChartPage = (ChooseCompositeChartPage)this.getPreviousPage();
        this.m_CompositeChart = (CompositeChart)chooseCompositeChartPage.getChart();
        this.m_ChartCategory = this.m_CompositeChart.getCategory();
        if (!this.m_Init) {
            if ("Range".equals(this.m_CompositeChart.getDomainRangeType())) {
                this.m_Range.setSelected(true);
            } else {
                this.m_Domain.setSelected(true);
            }
            if (this.m_ChartCategory.equals("Combo")) {
                serializable = this.m_CompositeChart.getSubPlotGap();
                if (serializable != null && (Double)serializable >= 0.0) {
                    this.m_Gap.setText(((Double)serializable).toString());
                }
                this.m_GapPanel.setVisible(true);
            } else {
                this.m_GapPanel.setVisible(false);
            }
        }
        serializable = this.m_Table.getTable().getColumnModel().getColumn(1);
        if (this.m_ChartCategory.equals("Combo")) {
            JTextField jTextField = new JTextField();
            jTextField.setDocument(new NumberDocument());
            ((TableColumn)serializable).setCellEditor(new DefaultCellEditor(jTextField));
        } else {
            ((TableColumn)serializable).setCellEditor(new DefaultCellEditor(this.m_AxisChoice));
        }
        this.m_Table.invalidate();
        this.m_Init = true;
    }

    @Override
    public IChart getChart() {
        return this.m_CompositeChart;
    }

    @Override
    public void doFinish() {
        if (this.m_CompositeChart != null) {
            if (this.m_Range.isSelected()) {
                this.m_CompositeChart.setDomainRangeType("Range");
            } else {
                this.m_CompositeChart.setDomainRangeType("Domain");
            }
            if (this.m_ChartCategory.equals("Combo")) {
                String string = this.m_Gap.getText();
                if (!StringUtil.isEmpty(string)) {
                    try {
                        Double d = Double.valueOf(string);
                        if (d > 0.0) {
                            this.m_CompositeChart.setSubPlotGap(d);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    this.m_CompositeChart.setSubPlotGap(null);
                }
            }
        }
    }

    private String[] getResources(String string) {
        String[] stringArray = new String[]{"SubPlotPage.CHART", "SubPlotPage.WEIGHT_LOC", "SubPlotPage.ENABLED", "SubPlotPage.NAME"};
        return stringArray;
    }

    class SubChartPlotModel
    extends ElxTableModel {
        public SubChartPlotModel() {
            super(Messages.RESOURCE_BUNDLE, SubPlotPage.this.getResources(SubPlotPage.this.m_ChartCategory));
        }

        @Override
        public int getRowCount() {
            if (SubPlotPage.this.m_CompositeChart == null) {
                return 0;
            }
            return SubPlotPage.this.m_CompositeChart.getSubPlotCount();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 2) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            SubPlot subPlot = SubPlotPage.this.m_CompositeChart.getSubPlot(n);
            if (n2 == 1) {
                if ("Combo".equals(SubPlotPage.this.m_ChartCategory)) {
                    int n3 = 1;
                    try {
                        n3 = Integer.valueOf(object.toString());
                        if (n3 < 1) {
                            n3 = 1;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    subPlot.setWeight(Integer.valueOf(n3));
                } else {
                    subPlot.setAxisLocation(((Name)object).getName());
                }
            } else if (n2 == 2) {
                Boolean bl = (Boolean)object;
                subPlot.setEnabled(bl.booleanValue());
            } else if (n2 == 3 && object != null) {
                subPlot.setName(object.toString());
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SubPlot subPlot = SubPlotPage.this.m_CompositeChart.getSubPlot(n);
            if (n2 == 0) {
                String string = subPlot.getType();
                return I18N.CHART.getString(string);
            }
            if (n2 == 1) {
                if ("Combo".equals(SubPlotPage.this.m_ChartCategory)) {
                    return subPlot.getWeight().toString();
                }
                return SubPlotPage.this.m_MapNames.get(subPlot.getAxisLocation());
            }
            if (n2 == 2) {
                return subPlot.isEnabled();
            }
            if (n2 == 3) {
                return subPlot.getName();
            }
            return null;
        }
    }

    class SubChartPlotTable
    extends OrderedEditableTable {
        private SubPlot m_CopySubPlot;

        public SubChartPlotTable() {
            super(SubPlotPage.this.m_ChartModel, true, true);
            this.setAutoResizeMode(4);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("plus".equals(string)) {
                this.addPlot();
            } else if ("minus".equals(string)) {
                this.removePlot();
            } else if ("copy".equals(string)) {
                this.copyPlot();
            } else if ("edit".equals(string)) {
                this.editPlot();
            } else if ("paste".equals(string)) {
                this.pastePlot();
            } else if ("up".equals(string)) {
                this.moveUp();
            } else if ("down".equals(string)) {
                this.moveDown();
            }
        }

        private void moveUp() {
            int n = this.getSelectedRow();
            SubPlot subPlot = (SubPlot)SubPlotPage.this.m_CompositeChart.getSubPlotList().remove(n);
            SubPlotPage.this.m_CompositeChart.getSubPlotList().add(--n, subPlot);
            SubPlotPage.this.m_ChartModel.fireTableDataChanged();
            this.select(n);
        }

        private void moveDown() {
            int n = this.getSelectedRow();
            SubPlot subPlot = (SubPlot)SubPlotPage.this.m_CompositeChart.getSubPlotList().remove(n);
            SubPlotPage.this.m_CompositeChart.getSubPlotList().add(++n, subPlot);
            SubPlotPage.this.m_ChartModel.fireTableDataChanged();
            this.select(n);
        }

        private void pastePlot() {
            if (this.m_CopySubPlot != null) {
                SubPlotPage.this.m_CompositeChart.addSubPlot(this.m_CopySubPlot.deepCopy());
            }
            SubPlotPage.this.m_ChartModel.fireTableDataChanged();
        }

        private void copyPlot() {
            int n = this.getSelectedRow();
            this.m_CopySubPlot = (SubPlot)SubPlotPage.this.m_CompositeChart.getSubPlotList().get(n);
            SubPlotPage.this.m_ChartModel.fireTableDataChanged();
        }

        private void removePlot() {
            int n = this.getSelectedRow();
            if (n >= 0) {
                SubPlotPage.this.m_CompositeChart.getSubPlotList().remove(n);
            }
            SubPlotPage.this.m_ChartModel.fireTableDataChanged();
        }

        private void editPlot() {
            int n = this.getSelectedRow();
            SubPlot subPlot = SubPlotPage.this.m_CompositeChart.getSubPlot(n);
            this.showWiz(subPlot);
            SubPlotPage.this.m_ChartModel.fireTableDataChanged();
        }

        private void addPlot() {
            SubPlot subPlot = new SubPlot();
            SubPlotWizard subPlotWizard = this.showWiz(subPlot);
            if (subPlotWizard.isFinished()) {
                SubPlotPage.this.m_CompositeChart.addSubPlot(subPlot);
            }
            SubPlotPage.this.m_ChartModel.fireTableDataChanged();
        }

        private SubPlotWizard showWiz(SubPlot subPlot) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.setWaitCursor();
            subPlot.setCompositeChart(SubPlotPage.this.m_CompositeChart);
            SubPlotWizard subPlotWizard = new SubPlotWizard(SubPlotPage.this.m_Report, subPlot, SubPlotPage.this.m_CompositeChart.getType(), false);
            elixirFrame.showWizard(subPlotWizard);
            elixirFrame.setArrowCursor();
            return subPlotWizard;
        }
    }
}

