/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.model.AbstractFormat;
import com.elixirtech.chart2.model.Axis;
import com.elixirtech.chart2.model.Format;
import com.elixirtech.chart2.model.Label;
import com.elixirtech.chart2.model.Tick;
import com.elixirtech.chart2.ui.ChartAction;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.ui.FontChooserDialog;
import com.elixirtech.ui.FormatDialog;
import com.elixirtech.ui.JColorChooserEx;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.util.format.IFormat;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jfree.chart.JFreeChart;

public class AxisPanel
implements ItemListener {
    private boolean m_StyleEditing;
    private String m_Name;
    private JTextField m_Label;
    private JButton m_FontButton;
    private JButton m_ColorButton;
    private JCheckBox m_TickVisible;
    private JButton m_TickFontButton;
    private JButton m_TickColorButton;
    private JButton m_TickFormatButton;
    private com.elixirtech.chart2.model.Font m_LabelFont;
    private com.elixirtech.chart2.model.Font m_TickFont;
    private AbstractFormat m_TickFormat;
    private ChartAction m_FormatAction;

    public AxisPanel(String string, boolean bl, ChartAction chartAction) {
        this(string, bl);
        this.m_FormatAction = chartAction;
    }

    public AxisPanel(String string, boolean bl) {
        this.m_StyleEditing = bl;
        this.m_Name = string;
        this.m_Label = new JTextField();
        this.m_TickVisible = new JCheckBox(Messages.getString("AxisPanel.TICK"));
        this.m_TickVisible.addItemListener(this);
    }

    public AxisPanel(String string) {
        this(string, true);
    }

    public void build(Container container, String string) {
        if (this.m_StyleEditing) {
            this.m_FontButton = this.button(new LabelFontAction());
            this.m_ColorButton = this.button(new LabelColorAction());
            this.m_TickFontButton = this.button(new TickFontAction());
            this.m_TickColorButton = this.button(new TickColorAction());
        }
        if (this.m_FormatAction == null) {
            this.m_FormatAction = new FormatAction();
        }
        this.m_TickFormatButton = this.button(this.m_FormatAction);
        String string2 = string + "-name";
        String string3 = string + "-label";
        String string4 = string + "-font";
        String string5 = string + "-color";
        String string6 = string + "-tick";
        String string7 = string + "-tfont";
        String string8 = string + "-tcolor";
        String string9 = string + "-tformat";
        container.add(string2, new JLabel(this.m_Name + ":"));
        container.add(string3, this.m_Label);
        if (this.m_StyleEditing) {
            container.add(string4, this.m_FontButton);
            container.add(string5, this.m_ColorButton);
            container.add(string6, this.m_TickVisible);
            container.add(string7, this.m_TickFontButton);
            container.add(string8, this.m_TickColorButton);
        }
        container.add(string9, this.m_TickFormatButton);
        ArchLayout archLayout = (ArchLayout)container.getLayout();
        archLayout.stickLeft(string2);
        if (this.m_StyleEditing) {
            archLayout.stickRight(string9);
            archLayout.putLeft(string8, string9);
            archLayout.putLeft(string7, string8);
            archLayout.putLeft(string6, string7, -5);
            archLayout.putLeft(string5, string6, -10);
            archLayout.putLeft(string4, string5);
            archLayout.putLeft(string3, string4);
            archLayout.setHeight(string4, string3);
            archLayout.setHeight(string5, string3);
            archLayout.setHeight(string7, string3);
            archLayout.setHeight(string8, string3);
            archLayout.setHeight(string9, string3);
            archLayout.vCenter(string2, string3);
            archLayout.vCenter(string4, string3);
            archLayout.vCenter(string5, string3);
            archLayout.vCenter(string6, string3);
            archLayout.vCenter(string7, string3);
            archLayout.vCenter(string8, string3);
            archLayout.vCenter(string9, string3);
        } else {
            archLayout.putLeft(string3, string9, -10);
            archLayout.stickRight(string9);
            archLayout.vCenter(string2, string3);
            archLayout.vCenter(string9, string3);
        }
    }

    public void setAxis(Axis axis) {
        if (axis != null) {
            Tick tick;
            Label label = axis.getLabel();
            if (label != null) {
                this.m_Label.setText(label.getText());
                this.m_LabelFont = label.getFont();
            }
            if ((tick = axis.getTick()) != null) {
                this.m_TickVisible.setSelected(tick.isTickMarkVisible());
                this.m_TickFont = tick.getFont();
                this.m_TickFormat = tick.getFormat();
            } else {
                this.m_TickVisible.setSelected(true);
            }
        } else {
            this.m_TickVisible.setSelected(true);
        }
        this.checkEnabled();
    }

    public Axis getAxis() {
        Axis axis = new Axis();
        Label label = new Label();
        label.setText(this.m_Label.getText());
        label.setFont(this.m_LabelFont);
        axis.setLabel(label);
        Tick tick = new Tick();
        tick.setTickMarkVisible(this.m_TickVisible.isSelected());
        tick.setFont(this.m_TickFont);
        tick.setFormat(this.m_TickFormat);
        axis.setTick(tick);
        return axis;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.checkEnabled();
    }

    public void setEnabled(boolean bl) {
        this.m_Label.setEnabled(bl);
        this.m_TickFormatButton.setEnabled(bl);
        if (this.m_StyleEditing) {
            this.m_FontButton.setEnabled(bl);
            this.m_ColorButton.setEnabled(bl);
            this.m_TickVisible.setEnabled(bl);
            this.m_TickFontButton.setEnabled(bl);
            this.m_TickColorButton.setEnabled(bl);
        }
    }

    protected void checkEnabled() {
        boolean bl;
        boolean bl2 = bl = this.m_TickVisible.isSelected() && this.m_TickVisible.isEnabled();
        if (this.m_StyleEditing) {
            this.m_TickFontButton.setEnabled(bl);
            this.m_TickColorButton.setEnabled(bl);
        }
        this.m_TickFormatButton.setEnabled(bl);
    }

    protected JButton button(ChartAction chartAction) {
        JButton jButton = new JButton(chartAction);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }

    public void setFormatComponentVisible(boolean bl) {
        this.m_TickFormatButton.setVisible(bl);
    }

    private class LabelFontAction
    extends ChartAction {
        public LabelFontAction() {
            super("Chart.Font");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            Font font = null;
            font = AxisPanel.this.m_LabelFont != null ? AxisPanel.this.m_LabelFont.getAWTFont() : new Font("SansSerif", 0, 12);
            FontChooserDialog fontChooserDialog = new FontChooserDialog((Frame)elixirFrame.getFrame(), font);
            fontChooserDialog.setTitle(Messages.getString("AxisPanel.LABEL_FONT"));
            fontChooserDialog.pack();
            fontChooserDialog.setLocationRelativeTo(elixirFrame.getFrame());
            elixirFrame.showModal(fontChooserDialog);
            if (fontChooserDialog.isOk()) {
                font = fontChooserDialog.getSelectedFont();
                String string = null;
                if (AxisPanel.this.m_LabelFont != null) {
                    string = AxisPanel.this.m_LabelFont.getFontColor();
                }
                AxisPanel.this.m_LabelFont = new com.elixirtech.chart2.model.Font(font);
                AxisPanel.this.m_LabelFont.setFontColor(string);
            }
        }
    }

    private class LabelColorAction
    extends ChartAction {
        public LabelColorAction() {
            super("Chart.Color");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            String string = AxisPanel.this.m_LabelFont != null ? AxisPanel.this.m_LabelFont.getFontColor() : "Black";
            Color color = StandardColor.lookup(string);
            color = JColorChooserEx.showDialog(elixirFrame.getFrame(), Messages.getString("AxisPanel.LABEL_COLOR"), color);
            if (AxisPanel.this.m_LabelFont == null) {
                AxisPanel.this.m_LabelFont = new com.elixirtech.chart2.model.Font(JFreeChart.DEFAULT_TITLE_FONT);
            }
            AxisPanel.this.m_LabelFont.setFontColor(StandardColor.getColorName(color));
        }
    }

    private class TickFontAction
    extends ChartAction {
        public TickFontAction() {
            super("Chart.Font");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            Font font = null;
            font = AxisPanel.this.m_TickFont != null ? AxisPanel.this.m_TickFont.getAWTFont() : new Font("SansSerif", 0, 10);
            FontChooserDialog fontChooserDialog = new FontChooserDialog((Frame)elixirFrame.getFrame(), font);
            fontChooserDialog.setTitle(Messages.getString("AxisPanel.TICK_FONT"));
            fontChooserDialog.pack();
            fontChooserDialog.setLocationRelativeTo(elixirFrame.getFrame());
            elixirFrame.showModal(fontChooserDialog);
            if (fontChooserDialog.isOk()) {
                font = fontChooserDialog.getSelectedFont();
                String string = null;
                if (AxisPanel.this.m_TickFont != null) {
                    string = AxisPanel.this.m_TickFont.getFontColor();
                }
                AxisPanel.this.m_TickFont = new com.elixirtech.chart2.model.Font(font);
                AxisPanel.this.m_TickFont.setFontColor(string);
            }
        }
    }

    private class TickColorAction
    extends ChartAction {
        public TickColorAction() {
            super("Chart.Color");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            String string = AxisPanel.this.m_TickFont != null ? AxisPanel.this.m_TickFont.getFontColor() : "Black";
            Color color = StandardColor.lookup(string);
            color = JColorChooserEx.showDialog(elixirFrame.getFrame(), Messages.getString("AxisPanel.TICK_COLOR"), color);
            if (AxisPanel.this.m_TickFont == null) {
                AxisPanel.this.m_TickFont = new com.elixirtech.chart2.model.Font(JFreeChart.DEFAULT_TITLE_FONT);
            }
            AxisPanel.this.m_TickFont.setFontColor(StandardColor.getColorName(color));
        }
    }

    private class FormatAction
    extends ChartAction {
        public FormatAction() {
            super("Chart.Format");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            FormatDialog formatDialog = new FormatDialog(elixirFrame.getFrame(), Messages.getString("AxisPanel.AXIS_FORMAT"), (IFormat)((Format)AxisPanel.this.m_TickFormat), Format.class);
            formatDialog.setLocationRelativeTo(elixirFrame.getFrame());
            elixirFrame.showModal(formatDialog);
            if (formatDialog.isOk()) {
                AxisPanel.this.m_TickFormat = (Format)formatDialog.getFormat();
            }
        }
    }
}

