/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.model.Axis;
import com.elixirtech.chart2.model.Tick;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.ui.NumberDocument;
import com.elixirtech.util.StringUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class AxisTickLabelAnglePanel
extends JPanel {
    public static String UNIT_DEGREE = "degree";
    private AnglePanel m_AngleX;

    public AxisTickLabelAnglePanel() {
        ArchLayout archLayout = new ArchLayout();
        this.setLayout(archLayout);
        this.m_AngleX = new AnglePanel("X", false);
        this.add("domain", this.m_AngleX);
        archLayout.stickTop("domain");
        archLayout.stickLeft("domain");
    }

    public void setDomainTickVisible(boolean bl) {
        this.m_AngleX.setVisible(bl);
    }

    public void setDomainTickVertical(boolean bl) {
        this.m_AngleX.build(bl);
    }

    public void setAxis(Axis axis) {
        this.m_AngleX.setTickAngle(axis.getTick());
    }

    public void updateAxis(Axis axis) {
        axis.getTick().setLabelAngle(this.m_AngleX.getRadianAngle());
        axis.getTick().setLabelRotation(this.m_AngleX.getOrientation());
    }

    static class AnglePanel
    extends JPanel {
        private JRadioButton m_Up;
        private JRadioButton m_Down;
        private boolean m_UseVerticalTick;
        private JCheckBox m_Vertical;
        private JTextField m_Angle;
        private String m_Name;

        AnglePanel(String string, boolean bl) {
            this.m_Name = string;
            this.setLayout(new FlowLayout(0, 5, 1));
            this.m_Angle = new JTextField(6);
            this.m_Angle.setDocument(new NumberDocument());
            this.m_Vertical = new JCheckBox();
            this.m_Up = new JRadioButton(Messages.getString("AxisTickLabelAnglePanel.ROTATE_UP"));
            this.m_Down = new JRadioButton(Messages.getString("AxisTickLabelAnglePanel.ROTATE_DOWN"));
            this.m_Up.setSelected(true);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.m_Up);
            buttonGroup.add(this.m_Down);
            this.build(bl);
        }

        public void build(boolean bl) {
            this.m_UseVerticalTick = bl;
            this.removeAll();
            JLabel jLabel = null;
            jLabel = this.m_UseVerticalTick ? new JLabel(Messages.getString("AxisTickLabelAnglePanel.VERTICAL_TICK")) : new JLabel(Messages.getString("AxisTickLabelAnglePanel.LABEL_ANGLE") + " ");
            this.add(jLabel);
            if (this.m_UseVerticalTick) {
                this.add((Component)this.m_Vertical, "Center");
            } else {
                this.add(this.m_Angle);
                this.add(this.m_Up);
                this.add(this.m_Down);
            }
        }

        public void setTickAngle(Tick tick) {
            if (this.m_UseVerticalTick) {
                this.m_Vertical.setSelected(tick.getLabelAngle() != 0.0);
            } else {
                double d = tick.getLabelAngle();
                double d2 = d / Math.PI * 180.0;
                this.m_Angle.setText(Double.toString(d2));
            }
            if ("down".equals(tick.getLabelRotation())) {
                this.m_Down.setSelected(true);
            } else {
                this.m_Up.setSelected(true);
            }
        }

        public double getRadianAngle() {
            if (this.m_UseVerticalTick) {
                if (this.m_Vertical.isSelected()) {
                    return 0.25;
                }
            } else {
                String string = this.m_Angle.getText();
                if (StringUtil.isEmpty(string)) {
                    return 0.0;
                }
                double d = Double.parseDouble(string);
                double d2 = d / 180.0 * Math.PI;
                return d2;
            }
            return 0.0;
        }

        public String getOrientation() {
            if (this.m_Up.isSelected()) {
                return "up";
            }
            return "down";
        }
    }
}

