/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.model.BubbleType;
import com.elixirtech.chart2.model.BubbleUi;
import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.ICategory3dGroupOnValueType;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.Legend;
import com.elixirtech.chart2.ui.BubbleTab;
import com.elixirtech.chart2.ui.DataTab;
import com.elixirtech.chart2.ui.LegendPaintTab;
import com.elixirtech.chart2.ui.LegendTab;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.TitleTab;
import com.elixirtech.chart2.ui.TypeSpecificPage;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.wizard.IFinishPage;

public class BubblePage
extends TypeSpecificPage
implements IFinishPage {
    public static String NAME = "Bubble";
    private BubbleTab m_BubbleTab;
    private TitleTab m_TitleTab;
    private LegendTab m_LegendTab;
    private LegendPaintTab m_LegendPaintTab;
    private DataTab m_XTab;
    private DataTab m_YTab;
    private DataTab m_ZTab;
    private DataTab m_GroupOnTab;

    public BubblePage() {
        super(NAME);
        this.setTitle(Messages.getString("BubblePage.TITLE"));
    }

    @Override
    protected void init(IChart iChart) {
        BubbleType bubbleType = (BubbleType)iChart.getChartType();
        this.m_XTab.setControlSource(bubbleType.getXSource());
        this.m_YTab.setControlSource(bubbleType.getYSource());
        this.m_ZTab.setControlSource(bubbleType.getZSource());
        this.m_GroupOnTab.setControlSource(bubbleType.getGroupOnSource());
        this.m_TitleTab.setTitle(bubbleType.getTitle());
        Legend legend = bubbleType.getLegend();
        this.m_LegendTab.setLegend(legend);
        this.m_LegendPaintTab.setLegend(legend);
        this.m_BubbleTab.init(iChart);
        super.init(iChart);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            IChart iChart = this.getChart();
            this.ensureChartType(iChart);
            this.updatePanels();
            if (!this.m_Initialized) {
                this.init(iChart);
            }
        }
        super.setVisible(bl);
    }

    @Override
    protected void buildTabs() {
        this.m_XTab = new DataTab(Messages.getString("3DCategoryPage.X"), 7, false){

            @Override
            public void exited() {
                ICategory3dGroupOnValueType iCategory3dGroupOnValueType = (ICategory3dGroupOnValueType)BubblePage.this.getChart().getChartType();
                iCategory3dGroupOnValueType.setXSource(this.getControlSource());
            }
        };
        this.m_XTab.setShowNumeric(true);
        this.addTab(this.m_XTab);
        this.m_YTab = new DataTab(Messages.getString("3DCategoryPage.Y"), 7, false){

            @Override
            public void exited() {
                ICategory3dGroupOnValueType iCategory3dGroupOnValueType = (ICategory3dGroupOnValueType)BubblePage.this.getChart().getChartType();
                iCategory3dGroupOnValueType.setYSource(this.getControlSource());
            }
        };
        this.m_YTab.setShowNumeric(true);
        this.addTab(this.m_YTab);
        this.m_ZTab = new DataTab(Messages.getString("BubblePage.VALUE"), 7, false){

            @Override
            public void exited() {
                ICategory3dGroupOnValueType iCategory3dGroupOnValueType = (ICategory3dGroupOnValueType)BubblePage.this.getChart().getChartType();
                iCategory3dGroupOnValueType.setZSource(this.getControlSource());
            }
        };
        this.m_ZTab.setShowNumeric(true);
        this.addTab(this.m_ZTab);
        this.m_GroupOnTab = new DataTab(Messages.getString("BubblePage.GROUPON"), 1, false){

            @Override
            public void exited() {
                ICategory3dGroupOnValueType iCategory3dGroupOnValueType = (ICategory3dGroupOnValueType)BubblePage.this.getChart().getChartType();
                iCategory3dGroupOnValueType.setGroupOnSource(this.getControlSource());
            }
        };
        this.addTab(this.m_GroupOnTab);
        this.m_BubbleTab = new BubbleTab();
        this.addTab(this.m_BubbleTab);
        this.m_TitleTab = new TitleTab(){

            @Override
            public void exited() {
                ChartType chartType = BubblePage.this.getChart().getChartType();
                chartType.setTitle(BubblePage.this.m_TitleTab.getTitle());
            }
        };
        this.addTab(this.m_TitleTab);
        this.m_LegendTab = new LegendTab(){

            @Override
            public void exited() {
                ChartType chartType = BubblePage.this.getChart().getChartType();
                Legend legend = BubblePage.this.m_LegendTab.getLegend();
                chartType.setLegend(legend);
                BubblePage.this.m_LegendPaintTab.updateLegend(legend);
            }
        };
        this.addTab(this.m_LegendTab);
        this.m_LegendPaintTab = new LegendPaintTab(){

            @Override
            public void exited() {
                ChartType chartType = BubblePage.this.getChart().getChartType();
                BubblePage.this.m_LegendPaintTab.updateLegend(chartType.getLegend());
            }
        };
        this.addTab(this.m_LegendPaintTab);
        super.buildTabs();
    }

    protected void updatePanels() {
        this.m_XTab.updatePanels(this.m_Wizard);
        this.m_YTab.updatePanels(this.m_Wizard);
        this.m_ZTab.updatePanels(this.m_Wizard);
        this.m_GroupOnTab.updatePanels(this.m_Wizard);
        this.m_LegendPaintTab.updatePanels(this.m_Wizard);
        this.m_LegendTab.updatePanels(this.m_Wizard);
        this.m_TitleTab.updatePanels(this.m_Wizard);
    }

    @Override
    protected void ensureChartType(IChart iChart) {
        if (!(iChart.getChartType() instanceof BubbleType)) {
            BubbleType bubbleType = new BubbleType();
            bubbleType.setXSource(new ControlSource());
            bubbleType.setYSource(new ControlSource());
            bubbleType.setZSource(new ControlSource());
            bubbleType.setGroupOnSource(new ControlSource());
            BubbleUi bubbleUi = new BubbleUi();
            bubbleUi.init();
            bubbleType.setBubbleUi(bubbleUi);
            iChart.setChartType((ChartType)bubbleType);
        }
    }

    @Override
    protected void applyChanges(IChart iChart) {
        if (this.m_Current != null) {
            this.m_Current.exited();
        }
        super.applyChanges(iChart);
        BubbleType bubbleType = (BubbleType)iChart.getChartType();
        bubbleType.setXSource(this.m_XTab.getControlSource());
        bubbleType.setYSource(this.m_YTab.getControlSource());
        bubbleType.setZSource(this.m_ZTab.getControlSource());
        bubbleType.setGroupOnSource(this.m_GroupOnTab.getControlSource());
        bubbleType.setTitle(this.m_TitleTab.getTitle());
        Legend legend = this.m_LegendTab.getLegend();
        bubbleType.setLegend(legend);
        this.m_LegendPaintTab.updateLegend(legend);
    }
}

