/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.model.BubbleType;
import com.elixirtech.chart2.model.BubbleUi;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.ui.AxisPanel;
import com.elixirtech.chart2.ui.ColorPanel;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.ValuePanel;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.ui.NumberDocument;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.IWizard;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class BubbleTab
extends TabComponent {
    public static final String NAME = "Bubble";
    public static final String BG_BUTTON = "bg-button";
    public static final String LABELS = "x-name,y-name,bg-name";
    public static final String X_LABEL = "x-label";
    public static final String Y_LABEL = "y-label";
    public static final String V_VALUE = "v-value";
    public static final String SCALE_AXIS_LABEL = "scale-axis-label";
    public static final String SCALE_AXIS = "scale-axis";
    public static final String DIAMETER_RATIO_LABEL = "diameter-ratio-label";
    public static final String DIAMETER_RATIO = "diameter-ratio";
    public static final String GRIDLINES_LABEL = "gridlines-label";
    public static final String DOMAIN_GRIDLINES = "domain-gridlines";
    public static final String RANGE_GRIDLINES = "range-gridlines";
    private I18NComboBox m_AxisScale;
    private JTextField m_DiameterRatio;
    private ColorPanel m_Background;
    private ArchLayout m_Layout = new ArchLayout();
    private AxisPanel m_XAxisPanel;
    private AxisPanel m_YAxisPanel;
    private BubbleUi m_BubbleUi;
    private ValuePanel m_ValuePanel;
    protected JCheckBox m_DomainGridlinesVisible;
    protected JCheckBox m_RangeGridlinesVisible;
    static final String[] KEYS = new String[]{"BubbleTab.SCALE_ON_BOTH_AXIS", "BubbleTab.SCALE_ON_DOMAIN_AXIS", "BubbleTab.SCALE_ON_RANGE_AXIS"};

    public BubbleTab() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(this.m_Layout);
        this.m_Background = new ColorPanel(Messages.getString("CategoryTab.PLOT_BACKGROUND"));
        this.m_XAxisPanel = new AxisPanel(Messages.getString("CategoryTab.X_AXIS"));
        this.m_YAxisPanel = new AxisPanel(Messages.getString("CategoryTab.Y_AXIS"));
        this.m_ValuePanel = new ValuePanel(Messages.getString("CategoryTab.VALUES"));
        this.m_DomainGridlinesVisible = new JCheckBox(Messages.getString("CategoryTab.DOMAIN_GRIDLINES"));
        this.m_RangeGridlinesVisible = new JCheckBox(Messages.getString("CategoryTab.RANGE_GRIDLINES"));
        this.m_Background.build(this, "bg");
        this.m_XAxisPanel.build(this, "x");
        this.m_YAxisPanel.build(this, "y");
        this.m_ValuePanel.build(this, "v");
        this.m_ValuePanel.invertEnabled(false);
        this.m_Layout.stickTop(BG_BUTTON);
        this.m_Layout.putRight(BG_BUTTON, LABELS, 10);
        this.m_Layout.alignBelow(X_LABEL, BG_BUTTON, 5);
        this.m_Layout.alignBelow(Y_LABEL, X_LABEL, 5);
        this.m_Layout.alignBelow(V_VALUE, Y_LABEL, 5);
        this.add(SCALE_AXIS_LABEL, new JLabel(Messages.getString("BubbleTab.SCALE_AXIS")));
        this.m_AxisScale = I18NComboBox.apply(BubbleType.SCALES, "i18n/chart-ui", KEYS);
        this.m_AxisScale.setName(SCALE_AXIS);
        this.add(this.m_AxisScale);
        this.m_Layout.alignBelow(SCALE_AXIS, V_VALUE, 5);
        this.m_Layout.stickLeft(SCALE_AXIS_LABEL);
        this.m_Layout.vCenter(SCALE_AXIS_LABEL, SCALE_AXIS);
        this.add(DIAMETER_RATIO_LABEL, new JLabel(Messages.getString("BubbleTab.DIAMETER_RATIO")));
        this.m_DiameterRatio = new JTextField(15);
        this.m_DiameterRatio.setText("1.0");
        this.m_DiameterRatio.setDocument(new NumberDocument());
        this.m_DiameterRatio.setName(DIAMETER_RATIO);
        this.add(this.m_DiameterRatio);
        this.m_Layout.alignBelow(DIAMETER_RATIO, SCALE_AXIS, 5);
        this.m_Layout.stickLeft(DIAMETER_RATIO_LABEL);
        this.m_Layout.vCenter(DIAMETER_RATIO_LABEL, DIAMETER_RATIO);
        this.add(GRIDLINES_LABEL, new JLabel(Messages.getString("CategoryTab.SHOW_GRIDLINES")));
        this.add(DOMAIN_GRIDLINES, this.m_DomainGridlinesVisible);
        this.add(RANGE_GRIDLINES, this.m_RangeGridlinesVisible);
        this.m_Layout.stickLeft(GRIDLINES_LABEL);
        this.m_Layout.alignBelow(DOMAIN_GRIDLINES, DIAMETER_RATIO, 5);
        this.m_Layout.putRight(RANGE_GRIDLINES, DOMAIN_GRIDLINES, 5);
        this.m_Layout.vCenter(GRIDLINES_LABEL, DOMAIN_GRIDLINES);
        this.m_Layout.vCenter(RANGE_GRIDLINES, DOMAIN_GRIDLINES);
    }

    public void init(IChart iChart) {
        BubbleType bubbleType = (BubbleType)iChart.getChartType();
        this.m_BubbleUi = bubbleType.getBubbleUi();
        this.m_Background.setColor(this.m_BubbleUi.getPlotBackground());
        this.m_XAxisPanel.setAxis(this.m_BubbleUi.getXAxis());
        this.m_YAxisPanel.setAxis(this.m_BubbleUi.getYAxis());
        this.m_ValuePanel.setValue(this.m_BubbleUi.getValue());
        this.m_AxisScale.setSelectedId(this.m_BubbleUi.getAxisScale());
        double d = this.m_BubbleUi.getDiameterRatio();
        this.m_DiameterRatio.setText(Double.toString(d));
        this.m_DomainGridlinesVisible.setSelected(this.m_BubbleUi.isDomainGridlinesVisible());
        this.m_RangeGridlinesVisible.setSelected(this.m_BubbleUi.isRangeGridlinesVisible());
    }

    public void updatePanels(IWizard iWizard) {
        boolean bl = !iWizard.isReadOnly();
        this.m_Background.setEnabled(bl);
        this.m_XAxisPanel.setEnabled(bl);
        this.m_YAxisPanel.setEnabled(bl);
        this.m_ValuePanel.setEnabled(bl);
        this.m_AxisScale.setEnabled(bl);
        this.m_DiameterRatio.setEditable(bl);
        this.m_DomainGridlinesVisible.setEnabled(bl);
        this.m_RangeGridlinesVisible.setEnabled(bl);
    }

    @Override
    public void exited() {
        this.m_BubbleUi.setPlotBackground(this.m_Background.getColor());
        this.m_BubbleUi.setXAxis(this.m_XAxisPanel.getAxis());
        this.m_BubbleUi.setYAxis(this.m_YAxisPanel.getAxis());
        this.m_BubbleUi.setValue(this.m_ValuePanel.getValue());
        this.m_BubbleUi.setAxisScale(this.m_AxisScale.getSelectedId());
        this.m_BubbleUi.setDiameterRatio(Double.parseDouble(this.m_DiameterRatio.getText()));
        this.m_BubbleUi.setDomainGridlinesVisible(this.m_DomainGridlinesVisible.isSelected());
        this.m_BubbleUi.setRangeGridlinesVisible(this.m_RangeGridlinesVisible.isSelected());
    }

    @Override
    public String getMessage() {
        return Messages.getString("BubbleTab.MESSAGE");
    }

    @Override
    public String getName() {
        return Messages.getString("BubbleTab.BUBBLE");
    }

    @Override
    public void performFinish() {
    }
}

