/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.model.CategoryType;
import com.elixirtech.chart2.model.CategoryUi;
import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.ControlSourceList;
import com.elixirtech.chart2.model.ICategoryType;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.IGroupSourceProvider;
import com.elixirtech.chart2.model.IntervalMarker;
import com.elixirtech.chart2.model.Legend;
import com.elixirtech.chart2.ui.DataListTab;
import com.elixirtech.chart2.ui.DataTab;
import com.elixirtech.chart2.ui.IntervalMarkerTab;
import com.elixirtech.chart2.ui.LegendPaintTab;
import com.elixirtech.chart2.ui.LegendTab;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.TitleTab;
import com.elixirtech.chart2.ui.TypeSpecificPage;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.wizard.IFinishPage;

public abstract class CategoryPage
extends TypeSpecificPage
implements IFinishPage {
    private DataTab m_DataTab;
    private DataListTab m_ValuesTab;
    protected TitleTab m_TitleTab;
    protected LegendTab m_LegendTab;
    protected LegendPaintTab m_LegendPaintTab;
    protected IntervalMarkerTab m_IntervalMarkerTab;

    public CategoryPage(String string) {
        super(string);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            IChart iChart = this.getChart();
            this.ensureChartType(iChart);
            this.updatePanels();
            if (!this.m_Initialized) {
                this.init(iChart);
            }
        }
        super.setVisible(bl);
    }

    @Override
    protected void buildTabs() {
        this.m_DataTab = new DataTab(Messages.getString("CategoryPage.KEY"), 5, false){

            @Override
            public void exited() {
                IGroupSourceProvider iGroupSourceProvider;
                ControlSource controlSource;
                ICategoryType iCategoryType = (ICategoryType)CategoryPage.this.getChart().getChartType();
                iCategoryType.setKeySource(this.getControlSource());
                if (iCategoryType instanceof IGroupSourceProvider && (controlSource = (iGroupSourceProvider = (IGroupSourceProvider)iCategoryType).getGroupOnSource()) != null) {
                    iGroupSourceProvider.setGroupOnSource(this.getControlSource());
                }
            }
        };
        this.addTab(this.m_DataTab);
        this.m_ValuesTab = new DataListTab(this.m_Wizard, Messages.getString("CategoryPage.VALUES"), this.getValuesTypes());
        this.addTab(this.m_ValuesTab);
        this.buildCategoryTabs();
        this.m_TitleTab = new TitleTab(){

            @Override
            public void exited() {
                ChartType chartType = CategoryPage.this.getChart().getChartType();
                chartType.setTitle(CategoryPage.this.m_TitleTab.getTitle());
            }
        };
        this.addTab(this.m_TitleTab);
        this.m_LegendTab = new LegendTab(){

            @Override
            public void exited() {
                ChartType chartType = CategoryPage.this.getChart().getChartType();
                Legend legend = CategoryPage.this.m_LegendTab.getLegend();
                chartType.setLegend(legend);
                CategoryPage.this.m_LegendPaintTab.updateLegend(legend);
            }
        };
        this.addTab(this.m_LegendTab);
        this.m_LegendPaintTab = new LegendPaintTab(){

            @Override
            public void exited() {
                ChartType chartType = CategoryPage.this.getChart().getChartType();
                CategoryPage.this.m_LegendPaintTab.updateLegend(chartType.getLegend());
            }
        };
        this.addTab(this.m_LegendPaintTab);
        if (this.hasIntervalMarker()) {
            this.m_IntervalMarkerTab = new IntervalMarkerTab(){

                @Override
                public void exited() {
                    ChartType chartType = CategoryPage.this.getChart().getChartType();
                    if (chartType instanceof CategoryType) {
                        CategoryType categoryType = (CategoryType)chartType;
                        categoryType.removeAllIntervalMarkers();
                        categoryType.addIntervalMarker(CategoryPage.this.m_IntervalMarkerTab.getIntervalMaker());
                    }
                }
            };
            this.addTab(this.m_IntervalMarkerTab);
        }
        super.buildTabs();
    }

    protected int getValuesTypes() {
        return 135;
    }

    protected abstract void buildCategoryTabs();

    protected void updatePanels() {
        this.m_DataTab.updatePanels(this.m_Wizard);
        this.m_ValuesTab.updatePanels(this.m_Wizard);
        this.m_TitleTab.updatePanels(this.m_Wizard);
        this.m_LegendTab.updatePanels(this.m_Wizard);
        this.m_LegendPaintTab.updatePanels(this.m_Wizard);
        this.m_ScriptTab.updatePanels(this.m_Wizard);
        if (this.hasIntervalMarker()) {
            this.m_IntervalMarkerTab.updatePanels(this.m_Wizard);
        }
    }

    @Override
    protected void init(IChart iChart) {
        ICategoryType iCategoryType = (ICategoryType)iChart.getChartType();
        this.m_DataTab.setControlSource(iCategoryType.getKeySource());
        this.m_ValuesTab.setControlSourceList(iCategoryType.getValueSource());
        this.m_TitleTab.setTitle(iCategoryType.getTitle());
        Legend legend = iCategoryType.getLegend();
        this.m_LegendTab.setLegend(legend);
        this.m_LegendPaintTab.setLegend(legend);
        if (iCategoryType instanceof CategoryType && this.hasIntervalMarker()) {
            CategoryType categoryType = (CategoryType)iCategoryType;
            IntervalMarker intervalMarker = null;
            intervalMarker = categoryType.getIntervalMarkerCount() > 0 ? categoryType.getIntervalMarker(0) : new IntervalMarker();
            this.m_IntervalMarkerTab.setIntervalMaker(intervalMarker);
        }
        super.init(iChart);
    }

    protected void setDataTabShowNumeric(boolean bl) {
        this.m_DataTab.setShowNumeric(bl);
    }

    @Override
    protected void applyChanges(IChart iChart) {
        if (this.m_Current != null) {
            this.m_Current.exited();
        }
        super.applyChanges(iChart);
        ICategoryType iCategoryType = (ICategoryType)iChart.getChartType();
        iCategoryType.setKeySource(this.m_DataTab.getControlSource());
        iCategoryType.setValueSource(this.m_ValuesTab.getControlSourceList());
        iCategoryType.setTitle(this.m_TitleTab.getTitle());
        iCategoryType.setLegend(this.m_LegendTab.getLegend());
        this.m_LegendPaintTab.updateLegend(iCategoryType.getLegend());
    }

    @Override
    protected void ensureChartType(IChart iChart) {
        if (!(iChart.getChartType() instanceof CategoryType)) {
            CategoryType categoryType = new CategoryType();
            categoryType.setKeySource(new ControlSource());
            categoryType.setValueSource(new ControlSourceList());
            CategoryUi categoryUi = new CategoryUi();
            categoryUi.init();
            categoryType.setCategoryUi(categoryUi);
            iChart.setChartType((ChartType)categoryType);
        }
    }

    public boolean hasIntervalMarker() {
        return true;
    }
}

