/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.I18N;
import com.elixirtech.chart2.model.CategoryType;
import com.elixirtech.chart2.model.CategoryUi;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.Position;
import com.elixirtech.chart2.ui.AxisPanel;
import com.elixirtech.chart2.ui.AxisTickLabelAnglePanel;
import com.elixirtech.chart2.ui.ChartAction;
import com.elixirtech.chart2.ui.ColorPanel;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.PositionDialog;
import com.elixirtech.chart2.ui.ValuePanel;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public abstract class CategoryTab
extends TabComponent {
    public static final String BG_BUTTON = "bg-button";
    public static final String LABELS = "x-name,y-name,bg-name,key-label,pos-label,neg-label";
    public static final String X_LABEL = "x-label";
    public static final String Y_LABEL = "y-label";
    public static final String KEY_LABEL = "key-label";
    public static final String KEY = "key";
    public static final String V_VALUE = "v-value";
    public static final String POS_LABEL = "pos-label";
    public static final String NEG_LABEL = "neg-label";
    public static final String POS = "pos";
    public static final String POS_DESC = "pos-desc";
    public static final String NEG = "neg";
    public static final String NEG_DESC = "neg-desc";
    public static final String TICK_ANGLE = "tick-angle";
    public static final String SUB_CATEGORY = "sub-category";
    public static final String GRIDLINES_LABEL = "gridlines-label";
    public static final String DOMAIN_GRIDLINES = "domain-gridlines";
    public static final String RANGE_GRIDLINES = "range-gridlines";
    protected boolean m_OldSortOrder;
    protected ArchLayout m_Layout = new ArchLayout();
    protected ColorPanel m_Background;
    protected AxisPanel m_XAxisPanel;
    protected AxisPanel m_YAxisPanel;
    protected AxisTickLabelAnglePanel m_AxisTickLabelAnglePanel;
    protected JCheckBox m_RetainKeyOrder;
    protected ValuePanel m_ValuePanel;
    protected JButton m_PositiveButton;
    protected JButton m_NegativeButton;
    protected JLabel m_PositiveDescription;
    protected JLabel m_NegativeDescription;
    protected IChart m_Chart;
    protected CategoryUi m_CategoryUi;
    protected JLabel m_Key;
    protected JCheckBox m_AddSubCategory;
    protected JCheckBox m_DomainGridlinesVisible;
    protected JCheckBox m_RangeGridlinesVisible;

    public CategoryTab() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(this.m_Layout);
        this.m_Background = new ColorPanel(Messages.getString("CategoryTab.PLOT_BACKGROUND"));
        this.m_XAxisPanel = new AxisPanel(Messages.getString("CategoryTab.X_AXIS"));
        this.m_YAxisPanel = new AxisPanel(Messages.getString("CategoryTab.Y_AXIS"));
        this.m_RetainKeyOrder = new JCheckBox(Messages.getString("CategoryTab.RETAIN_KEY_ORDER"));
        this.m_DomainGridlinesVisible = new JCheckBox(Messages.getString("CategoryTab.DOMAIN_GRIDLINES"));
        this.m_RangeGridlinesVisible = new JCheckBox(Messages.getString("CategoryTab.RANGE_GRIDLINES"));
        this.m_ValuePanel = new ValuePanel(Messages.getString("CategoryTab.VALUES"));
        this.m_AxisTickLabelAnglePanel = new AxisTickLabelAnglePanel();
        this.m_Background.build(this, "bg");
        this.m_XAxisPanel.build(this, "x");
        this.m_YAxisPanel.build(this, "y");
        this.m_ValuePanel.build(this, "v");
        this.m_PositiveButton = this.button(new PositivePositionAction());
        this.m_NegativeButton = this.button(new NegativePositionAction());
        this.m_PositiveDescription = new JLabel();
        this.m_NegativeDescription = new JLabel();
        this.m_PositiveDescription.setBorder(BorderFactory.createEtchedBorder());
        this.m_NegativeDescription.setBorder(BorderFactory.createEtchedBorder());
        this.m_Key = new JLabel(Messages.getString("CategoryTab.KEYS"));
        this.add(KEY_LABEL, this.m_Key);
        this.add(KEY, this.m_RetainKeyOrder);
        this.m_AddSubCategory = new JCheckBox(Messages.getString("CategoryTab.ADD_SUBCATEGORY"));
        this.add(SUB_CATEGORY, this.m_AddSubCategory);
        this.add(POS_LABEL, new JLabel(Messages.getString("CategoryTab.POSITIVE_VALUES")));
        this.add(POS, this.m_PositiveButton);
        this.add(POS_DESC, this.m_PositiveDescription);
        this.add(NEG_LABEL, new JLabel(Messages.getString("CategoryTab.NEGATIVE_VALUES")));
        this.add(NEG, this.m_NegativeButton);
        this.add(NEG_DESC, this.m_NegativeDescription);
        this.add(TICK_ANGLE, this.m_AxisTickLabelAnglePanel);
        this.add(GRIDLINES_LABEL, new JLabel(Messages.getString("CategoryTab.SHOW_GRIDLINES")));
        this.add(DOMAIN_GRIDLINES, this.m_DomainGridlinesVisible);
        this.add(RANGE_GRIDLINES, this.m_RangeGridlinesVisible);
        this.m_Layout.stickTop(BG_BUTTON);
        this.m_Layout.putRight(BG_BUTTON, LABELS, 10);
        this.m_Layout.alignBelow(X_LABEL, BG_BUTTON, 3);
        this.m_Layout.alignBelow(TICK_ANGLE, X_LABEL);
        this.m_Layout.alignBelow(Y_LABEL, TICK_ANGLE);
        this.m_Layout.stickLeft(KEY_LABEL);
        this.m_Layout.vCenter(KEY_LABEL, KEY);
        this.m_Layout.alignBelow(KEY, Y_LABEL, 2);
        this.m_Layout.putRight(SUB_CATEGORY, KEY, 10);
        this.m_Layout.vCenter(SUB_CATEGORY, KEY);
        this.m_Layout.alignBelow(V_VALUE, KEY, 6);
        this.m_Layout.stickLeft(POS_LABEL);
        this.m_Layout.stickLeft(NEG_LABEL);
        this.m_Layout.vCenter(POS_LABEL, POS);
        this.m_Layout.vCenter(NEG_LABEL, NEG);
        this.m_Layout.vCenter(POS_DESC, POS);
        this.m_Layout.vCenter(NEG_DESC, NEG);
        this.m_Layout.alignBelow(POS, V_VALUE, 5);
        this.m_Layout.alignBelow(NEG, POS, 2);
        this.m_Layout.putRight(POS_DESC, POS, 2);
        this.m_Layout.putRight(NEG_DESC, NEG, 3);
        this.m_Layout.setHeight(POS_DESC, POS);
        this.m_Layout.setHeight(NEG_DESC, NEG);
        this.m_Layout.stickRight(POS_DESC);
        this.m_Layout.stickRight(NEG_DESC);
        this.m_Layout.stickLeft(GRIDLINES_LABEL);
        this.m_Layout.alignBelow(DOMAIN_GRIDLINES, NEG, 3);
        this.m_Layout.putRight(RANGE_GRIDLINES, DOMAIN_GRIDLINES, 2);
        this.m_Layout.vCenter(GRIDLINES_LABEL, DOMAIN_GRIDLINES);
        this.m_Layout.vCenter(RANGE_GRIDLINES, DOMAIN_GRIDLINES);
        this.m_AddSubCategory.addActionListener(new SelectAddCategory());
    }

    public void init(IChart iChart) {
        this.m_Chart = iChart;
        CategoryType categoryType = (CategoryType)iChart.getChartType();
        this.init(categoryType.getCategoryUi());
        boolean bl = categoryType.getGroupOnSource() != null;
        this.m_AddSubCategory.setSelected(bl);
        this.m_ValuePanel.setInverted(categoryType.isInverted());
        this.m_RetainKeyOrder.setSelected(categoryType.isRetainKeyOrder());
        this.m_OldSortOrder = this.m_RetainKeyOrder.isSelected();
        if (bl) {
            this.m_ValuePanel.invertEnabled(false);
            this.m_RetainKeyOrder.setEnabled(false);
            this.m_RetainKeyOrder.setSelected(true);
        } else {
            this.m_ValuePanel.invertEnabled(true);
            this.m_RetainKeyOrder.setEnabled(true);
        }
    }

    protected void init(CategoryUi categoryUi) {
        this.m_CategoryUi = categoryUi;
        this.m_Background.setColor(this.m_CategoryUi.getPlotBackground());
        this.m_PositiveDescription.setText(this.describe(this.m_CategoryUi.getPositivePosition()));
        this.m_NegativeDescription.setText(this.describe(this.m_CategoryUi.getNegativePosition()));
        this.m_DomainGridlinesVisible.setSelected(categoryUi.isDomainGridlinesVisible());
        this.m_RangeGridlinesVisible.setSelected(categoryUi.isRangeGridlinesVisible());
    }

    public void updatePanels(IWizard iWizard) {
        boolean bl = !iWizard.isReadOnly();
        this.m_AddSubCategory.setEnabled(bl);
        this.m_Background.setEnabled(bl);
        this.m_XAxisPanel.setEnabled(bl);
        this.m_YAxisPanel.setEnabled(bl);
        this.m_RetainKeyOrder.setEnabled(bl);
        this.m_ValuePanel.setEnabled(bl);
        this.m_PositiveButton.setEnabled(bl);
        this.m_NegativeButton.setEnabled(bl);
        this.m_AxisTickLabelAnglePanel.setEnabled(bl);
        this.m_DomainGridlinesVisible.setEnabled(bl);
        this.m_RangeGridlinesVisible.setEnabled(bl);
    }

    protected JButton button(ChartAction chartAction) {
        JButton jButton = new JButton(chartAction);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }

    private boolean showSubCategory(String string) {
        return string.startsWith("Column") || string.startsWith("Bar");
    }

    @Override
    public abstract String getName();

    @Override
    public abstract String getMessage();

    @Override
    public void entered() {
        this.m_AddSubCategory.setVisible(this.showSubCategory(this.m_Chart.getType()));
    }

    @Override
    public void exited() {
        this.m_CategoryUi.setPlotBackground(this.m_Background.getColor());
        CategoryType categoryType = (CategoryType)this.m_Chart.getChartType();
        categoryType.setInverted(this.m_ValuePanel.isInverted());
        categoryType.setRetainKeyOrder(this.m_RetainKeyOrder.isSelected());
        if (this.m_AddSubCategory.isSelected() && this.m_AddSubCategory.isVisible()) {
            categoryType.setGroupOnSource(categoryType.getKeySource());
        } else {
            categoryType.setGroupOnSource(null);
        }
        this.m_CategoryUi.setDomainGridlinesVisible(this.m_DomainGridlinesVisible.isSelected());
        this.m_CategoryUi.setRangeGridlinesVisible(this.m_RangeGridlinesVisible.isSelected());
    }

    @Override
    public void performFinish() {
    }

    protected String describe(Position position) {
        if (position == null) {
            return "";
        }
        String string = I18N.CHART_UI.getString("Anchor." + position.getPosition());
        return string + ", " + Messages.getString("CategoryTab.ANGLE") + position.getAngle();
    }

    protected void doPositivePosition() {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        Position position = this.m_CategoryUi.getPositivePosition();
        String string = this.m_Chart.getType();
        PositionDialog positionDialog = new PositionDialog(elixirFrame.getFrame(), Messages.getString("CategoryTab.POSITIVE_POSITION"), position, string, true);
        positionDialog.setLocationRelativeTo(elixirFrame.getFrame());
        elixirFrame.showModal(positionDialog);
        if (positionDialog.isOk()) {
            position = positionDialog.getPosition();
            this.m_CategoryUi.setPositivePosition(position);
            this.m_PositiveDescription.setText(this.describe(position));
        }
    }

    protected void doNegativePosition() {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        Position position = this.m_CategoryUi.getNegativePosition();
        String string = this.m_Chart.getType();
        PositionDialog positionDialog = new PositionDialog(elixirFrame.getFrame(), Messages.getString("CategoryTab.NEGATIVE_POSITION"), position, string, false);
        positionDialog.setLocationRelativeTo(elixirFrame.getFrame());
        elixirFrame.showModal(positionDialog);
        if (positionDialog.isOk()) {
            position = positionDialog.getPosition();
            this.m_CategoryUi.setNegativePosition(position);
            this.m_NegativeDescription.setText(this.describe(position));
        }
    }

    private class PositivePositionAction
    extends ChartAction {
        public PositivePositionAction() {
            super("Chart.Position");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CategoryTab.this.doPositivePosition();
        }
    }

    private class NegativePositionAction
    extends ChartAction {
        public NegativePositionAction() {
            super("Chart.Position");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CategoryTab.this.doNegativePosition();
        }
    }

    private class SelectAddCategory
    implements ActionListener {
        private SelectAddCategory() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (CategoryTab.this.m_AddSubCategory.isSelected()) {
                CategoryTab.this.m_OldSortOrder = CategoryTab.this.m_RetainKeyOrder.isSelected();
                CategoryTab.this.m_ValuePanel.invertEnabled(false);
                CategoryTab.this.m_RetainKeyOrder.setEnabled(false);
                CategoryTab.this.m_RetainKeyOrder.setSelected(true);
            } else {
                CategoryTab.this.m_ValuePanel.invertEnabled(true);
                CategoryTab.this.m_RetainKeyOrder.setEnabled(true);
                CategoryTab.this.m_RetainKeyOrder.setSelected(CategoryTab.this.m_OldSortOrder);
            }
        }
    }
}

