/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.categorytype.CategoryTypeSelectionPanel;
import com.elixirtech.arch.categorytype.ICategoryType;
import com.elixirtech.arch.categorytype.ICategoryTypeRegistry;
import com.elixirtech.chart2.ChartRegistry;
import com.elixirtech.chart2.IChartHolder;
import com.elixirtech.chart2.IChartWizard;
import com.elixirtech.chart2.model.Chart;
import com.elixirtech.chart2.model.ChartSAX;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.sax.CMLSAXOut;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.TypeSpecificPage;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.jdom.input.SAXHandler;
import com.elixirtech.jdom.output.SAXOutputter;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.ui.wizard.WizardPage;
import com.elixirtech.util.StringUtil;
import java.awt.BorderLayout;
import org.xml.sax.ContentHandler;

public class ChooseChartPage
extends WizardPage
implements IFinishPage {
    public static final String NAME = "ChooseChart";
    protected CategoryTypeSelectionPanel m_Panel;
    protected ICategoryType m_CategoryType = new CT();
    protected ICategoryTypeRegistry m_CategoryRegistry;
    protected IChart m_Chart;
    protected boolean m_Initialized;

    public ChooseChartPage() {
        super(NAME, "<dynamic>");
        this.setTitle(Messages.getString("ChooseChartPage.CHART_TYPE_SELECTION"));
        this.setMessage(Messages.getString("ChooseChartPage.MESSAGE"));
        this.m_CategoryRegistry = ChartRegistry.CHART_REGISTRY;
    }

    public ChooseChartPage(String[] stringArray) {
        this();
    }

    public ChooseChartPage(String string, String string2) {
        super(string, string2);
    }

    @Override
    public void doFinish() {
        if (this.m_Initialized) {
            IFinishPage iFinishPage = (IFinishPage)this.getNextPage();
            if (iFinishPage != null) {
                iFinishPage.doFinish();
            }
            SAXHandler sAXHandler = new SAXHandler();
            sAXHandler.setIgnoringElementContentWhitespace(true);
            new CMLSAXOut((ContentHandler)sAXHandler, (Object)this.m_Chart, false);
            IChartHolder iChartHolder = ((IChartWizard)this.m_Wizard).getChartHolder();
            iChartHolder.setChartDocument(sAXHandler.getDocument());
        }
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Panel = new CategoryTypeSelectionPanel(this.m_CategoryType, this.m_CategoryRegistry);
        this.m_Component.setLayout(new BorderLayout());
        this.m_Component.add("Center", this.m_Panel);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            if (!this.m_Initialized) {
                IChartHolder iChartHolder = ((IChartWizard)this.m_Wizard).getChartHolder();
                Document document = iChartHolder.getChartDocument();
                if (document != null) {
                    ChartSAX chartSAX = new ChartSAX();
                    SAXOutputter sAXOutputter = new SAXOutputter((ContentHandler)chartSAX);
                    try {
                        sAXOutputter.output(document);
                        this.m_Chart = (Chart)chartSAX.getObject();
                        this.m_Chart.loaded();
                        this.m_Panel.updateFields();
                    }
                    catch (JDOMException jDOMException) {
                        ElixirJ.error(Messages.getString("ChooseChartPage.ERROR1"), jDOMException);
                    }
                }
                if (this.m_Chart == null) {
                    this.m_Chart = new Chart();
                    this.m_Chart.setCategory("Column-Category");
                    this.m_Chart.setType("Column");
                    this.m_Panel.updateFields();
                }
                this.m_Initialized = true;
            }
            this.m_Panel.setEnabled(!this.m_Wizard.isReadOnly());
        }
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.getNextPage() != null;
    }

    @Override
    public IWizardPage getNextPage() {
        String string = this.lookupNextPage(this.m_Chart.getCategory(), this.m_Chart.getType());
        if (StringUtil.notEmpty(string)) {
            IWizardPage iWizardPage = this.m_Wizard.getPage(string);
            if (iWizardPage instanceof TypeSpecificPage) {
                ((TypeSpecificPage)iWizardPage).ensureChartType(this.m_Chart);
            }
            return iWizardPage;
        }
        return null;
    }

    @Override
    public boolean isPageComplete() {
        if (!this.m_Initialized) {
            return false;
        }
        this.setError(null);
        boolean bl = true;
        if (this.m_CategoryType.getCategory() == null) {
            this.setError(Messages.getString("ChooseChartPage.REMINDER1"));
            bl = false;
        } else if (this.m_CategoryType.getType() == null) {
            this.setError(Messages.getString("ChooseChartPage.REMINDER2"));
            bl = false;
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }

    public IChart getChart() {
        return this.m_Chart;
    }

    protected String lookupNextPage(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        if (string.startsWith("Meter")) {
            return "Meter";
        }
        if (string.startsWith("Analysis") && string2.startsWith("XY-DataAnalysis")) {
            return "XY-DataAnalysis";
        }
        if (string.startsWith("Bar")) {
            if (string2.equals("Gantt")) {
                return "Gantt";
            }
            return "Bar";
        }
        if (string.startsWith("Column")) {
            return "Column";
        }
        if (string.startsWith("Pie")) {
            if (string2.equals("Pie")) {
                return "Pie";
            }
            if (string2.equals("Pie-Ring")) {
                return "Pie";
            }
            if (string2.equals("Pie-3D")) {
                return "Pie";
            }
            return "MultiPie";
        }
        if (string.startsWith("Area")) {
            return "Area";
        }
        if (string.startsWith("Line")) {
            if (string2.equals("Wind")) {
                return "Wind";
            }
            return "Line";
        }
        if (string.startsWith("Waterfall")) {
            return "Waterfall";
        }
        if (string.startsWith("Polar")) {
            if (string2.equals("WindRose")) {
                return "WindRose";
            }
            return "Polar";
        }
        if (string.startsWith("Stocks")) {
            if (string2.equals("Stocks-High-Low-Open-Close-Volume")) {
                return "HighLow";
            }
            return "Candlestick";
        }
        if (string.startsWith("XY")) {
            if (string2.startsWith("XY")) {
                return "XY";
            }
            if (string2.startsWith("Bubble")) {
                return "Bubble";
            }
            if (string2.equals("HeatMapXY")) {
                return "HeatMapXY";
            }
        }
        if (string.startsWith("3D")) {
            if (string2.equals("3D-Column")) {
                return "3DColumn";
            }
            if (string2.equals("3D-Area")) {
                return "3DArea";
            }
            if (string2.equals("3D-Line")) {
                return "3DLine";
            }
            if (string2.equals("3D-Surface")) {
                return "3DSurface";
            }
            if (string2.equals("3D-Scatter")) {
                return "3DScatter";
            }
        }
        return null;
    }

    private class CT
    implements ICategoryType {
        private CT() {
        }

        @Override
        public String getCategory() {
            return ChooseChartPage.this.m_Chart.getCategory();
        }

        @Override
        public void setCategory(String string) {
            ChooseChartPage.this.m_Chart.setCategory(string);
            ChooseChartPage.this.m_Wizard.getContainer().updateButtons();
        }

        @Override
        public String getType() {
            return ChooseChartPage.this.m_Chart.getType();
        }

        @Override
        public void setType(String string) {
            ChooseChartPage.this.m_Chart.setType(string);
            ChooseChartPage.this.m_Wizard.getContainer().updateButtons();
        }
    }
}

