/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.ui.ChartAction;
import com.elixirtech.ui.JColorChooserEx;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ColorPanel {
    private String m_Name;
    private String m_Color;
    private JButton m_Button;
    private JLabel m_ColorLabel;
    private View m_View;
    private boolean m_SolidColors;

    public ColorPanel(String string) {
        this.m_Name = string;
        this.m_View = new View();
    }

    public void setSolidColors(boolean bl) {
        this.m_SolidColors = bl;
    }

    public void build(Container container, String string) {
        String string2 = string + "-name";
        String string3 = string + "-button";
        String string4 = string + "-view";
        this.m_ColorLabel = new JLabel(this.m_Name + ":");
        container.add(string2, this.m_ColorLabel);
        this.m_Button = new JButton(new ColorAction());
        this.m_Button.setMargin(new Insets(0, 0, 0, 0));
        container.add(string3, this.m_Button);
        container.add(string4, this.m_View);
        ArchLayout archLayout = (ArchLayout)container.getLayout();
        archLayout.stickLeft(string2);
        archLayout.vCenter(string2, string3);
        archLayout.vCenter(string4, string3);
        archLayout.putRight(string4, string3, 5);
        archLayout.setHeight(string4, string3);
        archLayout.stickRight(string4);
    }

    public void setColor(String string) {
        this.m_Color = string;
        this.m_View.repaint();
    }

    public String getColor() {
        return this.m_Color;
    }

    public void setEnabled(boolean bl) {
        this.m_Button.setEnabled(bl);
    }

    protected void popup() {
        Color color;
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        Color color2 = StandardColor.lookup(this.m_Color, (Color)null);
        if (color2 != (color = JColorChooserEx.showDialog(elixirFrame.getFrame(), this.m_Name, color2, this.m_SolidColors))) {
            this.m_Color = StandardColor.getColorName(color);
            this.m_View.repaint();
        }
    }

    private class View
    extends JComponent {
        private View() {
        }

        @Override
        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(Color.gray);
            int n = dimension.height / 2;
            boolean bl = true;
            for (int i = 0; i < dimension.width; i += n) {
                if (bl) {
                    graphics.fillRect(i, 0, n, n);
                } else {
                    graphics.fillRect(i, n, n, n + 1);
                }
                bl = !bl;
            }
            Color color = StandardColor.lookup(ColorPanel.this.m_Color, (Color)null);
            if (color != null) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            }
        }
    }

    private class ColorAction
    extends ChartAction {
        public ColorAction() {
            super("Chart.Color");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColorPanel.this.popup();
        }
    }
}

