/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.ui.StandardColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ColorSelector
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor {
    private int m_ClickCount = 1;
    private JPanel m_DisplayPanel = new JPanel(new BorderLayout());
    private JLabel m_ColorDisplay = new JLabel("   ");
    private JTextField m_Text = new JTextField();
    private JButton m_ColorBtn = new JButton("...");
    private Color m_Color;

    public ColorSelector() {
        this.m_ColorDisplay.setBorder(BorderFactory.createEtchedBorder());
        this.m_ColorDisplay.setOpaque(true);
        this.m_ColorBtn.addActionListener(new AL());
        this.m_Text.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.m_DisplayPanel.add("West", this.m_ColorDisplay);
        this.m_DisplayPanel.add("Center", this.m_Text);
        this.m_DisplayPanel.add("East", this.m_ColorBtn);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            this.m_Text.setForeground(jTable.getSelectionForeground());
            this.m_Text.setBackground(jTable.getSelectionBackground());
            this.m_DisplayPanel.setBackground(jTable.getSelectionBackground());
        } else {
            this.m_Text.setForeground(jTable.getForeground());
            Color color = jTable.getBackground();
            if (color == null) {
                color = Color.WHITE;
            }
            if (n % 2 == 0) {
                color = UIManager.getColor("Table.alternateRowColor");
            }
            Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue());
            this.m_Text.setBackground(color2);
            this.m_DisplayPanel.setBackground(color2);
        }
        this.m_Color = StandardColor.lookup((String)object);
        this.setDisplayColor(this.m_Color);
        this.m_Text.setText((String)object);
        return this.m_DisplayPanel;
    }

    protected void setDisplayColor(Color color) {
        this.m_ColorDisplay.setBackground(this.m_Color);
        this.m_ColorDisplay.setForeground(this.m_Color);
        this.m_ColorDisplay.repaint();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        String string = (String)object;
        this.m_Color = StandardColor.lookup(string);
        this.m_Text.setText(string);
        this.setDisplayColor(this.m_Color);
        this.m_ColorDisplay.validate();
        return this.m_DisplayPanel;
    }

    @Override
    public Object getCellEditorValue() {
        return this.m_Text.getText();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= this.m_ClickCount;
        }
        return true;
    }

    public void setClickCount(int n) {
        this.m_ClickCount = n;
    }

    final class AL
    implements ActionListener {
        AL() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String string = Messages.getString("ColorSelector.CHOOSE_COLOR");
                    Color color = JColorChooser.showDialog(ColorSelector.this.m_Text, string, ColorSelector.this.m_Color);
                    if (color != null) {
                        ColorSelector.this.m_Color = color;
                        ColorSelector.this.m_Text.setText(StandardColor.getColorName(color));
                        ColorSelector.this.setDisplayColor(color);
                    }
                }
            });
        }
    }
}

