/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.ui.DataTab;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.DoubleClickListener;
import com.elixirtech.ui.EscapableDialog;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ControlSourceDialog
extends EscapableDialog
implements ActionListener,
DoubleClickListener,
ChangeListener {
    private DataTab m_DataTab;
    private JButton m_Ok;
    private JButton m_Cancel;
    private boolean m_IsOk;

    public ControlSourceDialog(IWizard iWizard, JFrame jFrame, String string, ControlSource controlSource, int n, boolean bl) {
        super(jFrame, string, true);
        this.m_DataTab = new DataTab(string, n, bl);
        this.getContentPane().add(this.m_DataTab);
        this.m_DataTab.updatePanels(iWizard);
        this.m_DataTab.setControlSource(controlSource);
        this.m_DataTab.addDoubleClickListener(this);
        this.m_DataTab.addChangeListener(this);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.m_Ok = SwingFactory.newOkButton(this);
        this.m_Cancel = SwingFactory.newCancelButton(this);
        jPanel.add(this.m_Ok);
        jPanel.add(this.m_Cancel);
        Bundle.ARCH_MAP.injectComponents("ControlSourceDialog.", jPanel);
        this.getContentPane().add((Component)jPanel, "South");
        this.setSize(500, 400);
        this.setLocationRelativeTo(jFrame);
        this.checkEnabled();
    }

    public ControlSource getControlSource() {
        return this.m_DataTab.getControlSource();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_Ok) {
            this.m_IsOk = true;
        }
        this.dispose();
    }

    public boolean isOk() {
        return this.m_IsOk;
    }

    @Override
    public void doubleClick(MouseEvent mouseEvent) {
        this.m_IsOk = true;
        this.dispose();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.checkEnabled();
    }

    private void checkEnabled() {
        this.m_Ok.setEnabled(this.m_DataTab.isOk());
    }
}

