/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.chart2.model.ControlSourceList;
import com.elixirtech.chart2.ui.ControlSourceDialog;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.TopLeftLayoutManager;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DataListTab
extends TabComponent
implements ActionListener,
ListSelectionListener {
    private IWizard m_Wizard;
    private String m_Name;
    private int m_TypeMask;
    private JTable m_DataTable;
    private Model m_Model;
    private ControlSourceList m_ControlSourceList = new ControlSourceList();
    private JButton m_Add;
    private JButton m_Edit;
    private JButton m_MoveUp;
    private JButton m_MoveDown;
    private JButton m_Delete;
    private static final String[] COLUMNS = new String[]{"TableModel.Name", "TableModel.Type"};

    public DataListTab(IWizard iWizard, String string, int n) {
        this.m_Wizard = iWizard;
        this.m_Name = string;
        this.m_TypeMask = n;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.m_Model = new Model(COLUMNS);
        this.m_DataTable = SwingFactory.newTable();
        this.m_DataTable.setModel(this.m_Model);
        this.m_DataTable.addMouseListener(new ML());
        ListSelectionModel listSelectionModel = this.m_DataTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.add((Component)new JScrollPane(this.m_DataTable), "Center");
        this.add((Component)this.buildButtonBox(), "West");
        this.checkEnabled();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getMessage() {
        return Messages.getString("DataListTab.MESSAGE");
    }

    @Override
    public void entered() {
        this.checkEnabled();
    }

    @Override
    public void performFinish() {
    }

    public void setControlSourceList(ControlSourceList controlSourceList) {
        this.m_ControlSourceList = controlSourceList;
        this.m_Model.fireTableDataChanged();
        this.checkEnabled();
    }

    public ControlSourceList getControlSourceList() {
        return this.m_ControlSourceList;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_Add) {
            this.add();
        } else if (object == this.m_Edit) {
            this.edit();
        } else if (object == this.m_MoveUp) {
            this.moveUp();
        } else if (object == this.m_MoveDown) {
            this.moveDown();
        } else if (object == this.m_Delete) {
            this.delete();
        }
        this.checkEnabled();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.checkEnabled();
    }

    public void updatePanels(IWizard iWizard) {
        boolean bl = !iWizard.isReadOnly();
        this.setEnabled(bl);
        this.m_DataTable.setEnabled(bl);
        this.checkEnabled();
    }

    protected void add() {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        ControlSource controlSource = new ControlSource();
        ControlSourceDialog controlSourceDialog = new ControlSourceDialog(this.m_Wizard, elixirFrame.getFrame(), this.m_Name, controlSource, this.m_TypeMask, true);
        elixirFrame.showModal(controlSourceDialog);
        if (controlSourceDialog.isOk()) {
            this.m_ControlSourceList.addControlSource(controlSourceDialog.getControlSource());
            int n = this.m_ControlSourceList.getControlSourceCount() - 1;
            this.m_Model.fireTableDataChanged();
            this.m_DataTable.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    protected void edit() {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        int n = this.m_DataTable.getSelectedRow();
        ControlSource controlSource = this.m_ControlSourceList.getControlSource(n);
        ControlSourceDialog controlSourceDialog = new ControlSourceDialog(this.m_Wizard, elixirFrame.getFrame(), this.m_Name, controlSource, this.m_TypeMask, true);
        elixirFrame.showModal(controlSourceDialog);
        if (controlSourceDialog.isOk()) {
            List list = this.m_ControlSourceList.getControlSourceList();
            list.set(n, controlSourceDialog.getControlSource());
            this.m_Model.fireTableDataChanged();
            this.m_DataTable.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    protected void moveUp() {
        int n = this.m_DataTable.getSelectedRow();
        List list = this.m_ControlSourceList.getControlSourceList();
        ControlSource controlSource = this.m_ControlSourceList.getControlSource(n);
        this.m_ControlSourceList.removeControlSource(controlSource);
        list.add(--n, controlSource);
        this.m_Model.fireTableDataChanged();
        this.m_DataTable.getSelectionModel().setSelectionInterval(n, n);
    }

    protected void moveDown() {
        int n = this.m_DataTable.getSelectedRow();
        List list = this.m_ControlSourceList.getControlSourceList();
        ControlSource controlSource = this.m_ControlSourceList.getControlSource(n);
        this.m_ControlSourceList.removeControlSource(controlSource);
        list.add(++n, controlSource);
        this.m_Model.fireTableDataChanged();
        this.m_DataTable.getSelectionModel().setSelectionInterval(n, n);
    }

    protected void delete() {
        int n = this.m_DataTable.getSelectedRow();
        ControlSource controlSource = this.m_ControlSourceList.getControlSource(n);
        this.m_ControlSourceList.removeControlSource(controlSource);
        n = Math.min(n, this.m_DataTable.getRowCount() - 1);
        this.m_Model.fireTableDataChanged();
        if (n >= 0) {
            this.m_DataTable.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    protected JComponent buildButtonBox() {
        this.m_Add = new JButton(StandardIcons.NEW);
        this.m_Add.setToolTipText(Messages.getString("DataListTab.ADD"));
        this.m_Add.addActionListener(this);
        this.m_Edit = new JButton(StandardIcons.PROPERTIES);
        this.m_Edit.setToolTipText(Messages.getString("DataListTab.EDIT"));
        this.m_Edit.addActionListener(this);
        this.m_MoveUp = new JButton(StandardIcons.UP);
        this.m_MoveUp.setToolTipText(Messages.getString("DataListTab.MOVE_UP"));
        this.m_MoveUp.addActionListener(this);
        this.m_MoveDown = new JButton(StandardIcons.DOWN);
        this.m_MoveDown.setToolTipText(Messages.getString("DataListTab.MOVE_DOWN"));
        this.m_MoveDown.addActionListener(this);
        this.m_Delete = new JButton(StandardIcons.DELETE);
        this.m_Delete.setToolTipText(Messages.getString("DataListTab.DELETE"));
        this.m_Delete.addActionListener(this);
        JPanel jPanel = new JPanel(new GridLayout(5, 0));
        jPanel.add(this.m_Add);
        jPanel.add(this.m_Edit);
        jPanel.add(this.m_MoveUp);
        jPanel.add(this.m_MoveDown);
        jPanel.add(this.m_Delete);
        JPanel jPanel2 = new JPanel(new TopLeftLayoutManager());
        jPanel2.add(jPanel);
        return jPanel2;
    }

    protected void checkEnabled() {
        boolean bl = this.isEnabled();
        boolean bl2 = this.m_Model.getRowCount() > 0;
        int n = this.m_DataTable.getSelectedRow();
        this.m_Add.setEnabled(bl);
        this.m_Edit.setEnabled(bl && n >= 0 && bl2);
        this.m_MoveUp.setEnabled(bl && n > 0);
        this.m_MoveDown.setEnabled(bl && n >= 0 && n < this.m_DataTable.getRowCount() - 1);
        this.m_Delete.setEnabled(bl && n >= 0 && bl2);
    }

    private class Model
    extends ElxTableModel {
        public Model(String[] stringArray) {
            super(I18N.ERD, COLUMNS);
        }

        @Override
        public int getRowCount() {
            return DataListTab.this.m_ControlSourceList.getControlSourceCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ControlSource controlSource = DataListTab.this.m_ControlSourceList.getControlSource(n);
            if (n2 == 0) {
                return controlSource.getDisplayNameValue();
            }
            return I18N.ERD.getString("ControlSource." + controlSource.getType().toUpperCase(Locale.ENGLISH));
        }
    }

    private class ML
    extends MouseAdapter {
        private ML() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                DataListTab.this.edit();
            }
        }
    }
}

