/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.I18N;
import com.elixirtech.chart2.ui.FieldPanel;
import com.elixirtech.chart2.ui.IDataPanel;
import com.elixirtech.chart2.ui.LiteralPanel;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.OperationPanel;
import com.elixirtech.chart2.ui.ScriptPanel;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.I18NName;
import com.elixirtech.i18n.Name;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.DoubleClickListener;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DataTab
extends TabComponent
implements ItemListener,
ChangeListener {
    public static final int FIELD_MASK = 1;
    public static final int OPERATION_MASK = 2;
    public static final int SCRIPT_MASK = 4;
    public static final int LITERAL_MASK = 8;
    public static final int ALL_MASK = 15;
    public static final int SCRIPT_SHOWS_OPERATION = 128;
    public static final String[] TYPES = new String[]{"Field", "Operation", "Script", "Literal"};
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String NAME_LABEL = "name-label";
    private static final String TYPE_LABEL = "type-label";
    protected String m_Name;
    protected int m_TypeMask;
    protected boolean m_ShowDisplayName;
    protected I18NComboBox m_Type;
    protected JTextField m_DisplayName;
    protected CardLayout m_CardLayout;
    protected JPanel m_Center;
    protected IDataPanel[] m_Panels;
    protected boolean m_IsNumeric;
    protected boolean m_IsDate;
    private List<ChangeListener> m_Listeners = new ArrayList<ChangeListener>();

    public DataTab(String string, int n, boolean bl) {
        this.m_Name = string;
        this.m_TypeMask = n;
        this.m_ShowDisplayName = bl;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        JPanel jPanel = this.buildNorth();
        this.add((Component)jPanel, "North");
        this.buildPanels();
        this.m_CardLayout = new CardLayout();
        this.m_Center = new JPanel(this.m_CardLayout);
        for (int i = 0; i < this.m_Panels.length; ++i) {
            this.m_Center.add(TYPES[i], (JPanel)((Object)this.m_Panels[i]));
        }
        this.add((Component)this.m_Center, "Center");
        this.m_Type.addItemListener(this);
    }

    public void setControlSource(ControlSource controlSource) {
        if (this.m_ShowDisplayName) {
            this.m_DisplayName.setText(controlSource.getDisplayName());
        }
        for (int i = 0; i < this.m_Panels.length; ++i) {
            this.m_Panels[i].setControlSource(controlSource);
        }
        this.m_Type.setSelectedId(controlSource.getType());
        if (this.m_Type.getSelectedIndex() < 0) {
            this.m_Type.setSelectedIndex(0);
        }
    }

    public void setShowNumeric(boolean bl) {
        this.m_IsNumeric = bl;
        for (int i = 0; i < this.m_Panels.length; ++i) {
            if (!(this.m_Panels[i] instanceof FieldPanel)) continue;
            ((FieldPanel)this.m_Panels[i]).setShowNumeric(bl);
        }
    }

    public void setShowDate(boolean bl) {
        this.m_IsDate = bl;
        for (int i = 0; i < this.m_Panels.length; ++i) {
            if (!(this.m_Panels[i] instanceof FieldPanel)) continue;
            ((FieldPanel)this.m_Panels[i]).setShowDate(bl);
        }
    }

    public void addDoubleClickListener(DoubleClickListener doubleClickListener) {
        for (int i = 0; i < this.m_Panels.length; ++i) {
            this.m_Panels[i].addDoubleClickListener(doubleClickListener);
        }
    }

    public boolean isOk() {
        int n = this.m_Type.getSelectedIndex();
        if (n >= 0) {
            return this.m_Panels[n].isOk();
        }
        return false;
    }

    public void updatePanels(IWizard iWizard) {
        boolean bl;
        for (bl = false; bl < this.m_Panels.length; bl += 1) {
            this.m_Panels[bl].update(iWizard);
        }
        bl = !iWizard.isReadOnly();
        this.m_Type.setEnabled(bl);
        if (this.m_DisplayName != null) {
            this.m_DisplayName.setEnabled(bl);
        }
    }

    public void update() {
        int n = this.m_Type.getSelectedIndex();
        if (n >= 0) {
            this.m_CardLayout.show(this.m_Center, TYPES[this.m_Type.getSelectedIndex()]);
        }
        this.fireChanged();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (int i = 0; i < this.m_Panels.length; ++i) {
            SwingUtil.setEnabled((JPanel)((Object)this.m_Panels[i]), bl);
        }
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getMessage() {
        if (this.m_IsNumeric) {
            return Messages.getString("DataTab.NUMERIC_MESSAGE");
        }
        return Messages.getString("DataTab.MESSAGE");
    }

    public ControlSource getControlSource() {
        ControlSource controlSource = this.m_Panels[this.m_Type.getSelectedIndex()].getControlSource();
        if (this.m_ShowDisplayName) {
            controlSource.setDisplayName(this.m_DisplayName.getText());
        }
        return controlSource;
    }

    @Override
    public void performFinish() {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.update();
        this.fireChanged();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChanged();
    }

    protected JPanel buildNorth() {
        ArchLayout archLayout = new ArchLayout();
        JPanel jPanel = new JPanel(archLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        jPanel.add(TYPE_LABEL, new JLabel(Messages.getString("DataTab.FIELD_TYPE")));
        this.m_Type = I18NComboBox.apply(this.getTypeNames());
        jPanel.add(TYPE, this.m_Type);
        if (this.m_ShowDisplayName) {
            jPanel.add(NAME_LABEL, new JLabel(Messages.getString("DataTab.DISPLAY_NAME")));
            this.m_DisplayName = new JTextField();
            jPanel.add(NAME, this.m_DisplayName);
            archLayout.stickTop(NAME);
            archLayout.setHeight(TYPE, NAME);
            archLayout.vCenter(TYPE_LABEL, NAME);
            archLayout.vCenter(TYPE, NAME);
            archLayout.vCenter(NAME_LABEL, NAME);
            archLayout.stickLeft(TYPE_LABEL);
            archLayout.putRight(TYPE, TYPE_LABEL, 10);
            archLayout.putRight(NAME_LABEL, TYPE, 10);
            archLayout.putRight(NAME, NAME_LABEL, 10);
            archLayout.stickRight(NAME);
        } else {
            archLayout.stickTop(TYPE);
            archLayout.vCenter(TYPE_LABEL, TYPE);
            archLayout.stickLeft(TYPE_LABEL);
            archLayout.putRight(TYPE, TYPE_LABEL, 10);
        }
        return jPanel;
    }

    protected void buildPanels() {
        JPanel jPanel;
        ArrayList<JPanel> arrayList = new ArrayList<JPanel>();
        if ((this.m_TypeMask & 1) != 0) {
            jPanel = new FieldPanel();
            ((FieldPanel)jPanel).addChangeListener(this);
            arrayList.add(jPanel);
        }
        if ((this.m_TypeMask & 2) != 0) {
            jPanel = new OperationPanel();
            ((OperationPanel)jPanel).addChangeListener(this);
            arrayList.add(jPanel);
        }
        if ((this.m_TypeMask & 4) != 0) {
            arrayList.add(new ScriptPanel((this.m_TypeMask & 0x80) != 0));
        }
        if ((this.m_TypeMask & 8) != 0) {
            arrayList.add(new LiteralPanel());
        }
        this.m_Panels = new IDataPanel[arrayList.size()];
        arrayList.toArray(this.m_Panels);
    }

    protected Name[] getTypeNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((this.m_TypeMask & 1) != 0) {
            arrayList.add("Field");
        }
        if ((this.m_TypeMask & 2) != 0) {
            arrayList.add("Operation");
        }
        if ((this.m_TypeMask & 4) != 0) {
            arrayList.add("Script");
        }
        if ((this.m_TypeMask & 8) != 0) {
            arrayList.add("Literal");
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        Name[] nameArray = new Name[stringArray.length];
        for (int i = 0; i < nameArray.length; ++i) {
            nameArray[i] = I18NName.apply((String)stringArray[i], (ResourceBundle)I18N.CHART_UI, (String)("FieldType." + stringArray[i]));
        }
        return nameArray;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.m_Listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.m_Listeners.remove(changeListener);
    }

    private void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.m_Listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

