/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.IChartData;
import com.elixirtech.chart2.ui.IDataPanel;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.ensemble.wizard.result.ResultSchemaPanel;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.DoubleClickListener;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FieldPanel
extends JPanel
implements IDataPanel,
ListSelectionListener {
    private boolean m_ShowNumeric;
    private boolean m_ShowDate;
    private ResultSchemaPanel m_SchemaPanel;
    private List<ChangeListener> m_Listeners = new ArrayList<ChangeListener>();

    public FieldPanel() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.m_SchemaPanel = new ResultSchemaPanel(true);
        this.m_SchemaPanel.addListSelectionListener(this);
        this.add((Component)this.m_SchemaPanel, "Center");
    }

    public void setShowDate(boolean bl) {
        this.m_ShowDate = bl;
    }

    public void setShowNumeric(boolean bl) {
        this.m_ShowNumeric = bl;
    }

    @Override
    public void setControlSource(ControlSource controlSource) {
        String string = controlSource.getField();
        this.m_SchemaPanel.setSelectedName(string);
    }

    @Override
    public void update(IWizard iWizard) {
        DataSchema dataSchema = ((IChartData)iWizard).getSchema();
        if (dataSchema != null) {
            String string = this.m_SchemaPanel.getSelectedName();
            HashSet<String> hashSet = new HashSet<String>();
            if (this.m_ShowNumeric | this.m_ShowDate) {
                dataSchema = this.filter(dataSchema);
            }
            this.m_SchemaPanel.setSchema(dataSchema, hashSet);
            this.m_SchemaPanel.setSelectedName(string);
        }
        this.m_SchemaPanel.setEnabled(!iWizard.isReadOnly());
    }

    @Override
    public ControlSource getControlSource() {
        ControlSource controlSource = new ControlSource();
        controlSource.setType("Field");
        String string = this.m_SchemaPanel.getSelectedName();
        controlSource.setField(string);
        return controlSource;
    }

    @Override
    public void addDoubleClickListener(DoubleClickListener doubleClickListener) {
        this.m_SchemaPanel.addDoubleClickListener(doubleClickListener);
    }

    public void removeDoubleClickListener(DoubleClickListener doubleClickListener) {
        this.m_SchemaPanel.removeDoubleClickListener(doubleClickListener);
    }

    @Override
    public boolean isOk() {
        return this.m_SchemaPanel.getSelection() >= 0;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.fireChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.m_Listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.m_Listeners.remove(changeListener);
    }

    public DataSchema filter(DataSchema dataSchema) {
        SchemaBuilder schemaBuilder = new SchemaBuilder(dataSchema.isCaseSensitive());
        int n = dataSchema.getColumnCount();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            DataType dataType = dataSchema.getColumnType(i);
            if (dataType.isNumeric() && this.m_ShowNumeric) {
                schemaBuilder.add(dataSchema.getColumnName(i), dataType, dataSchema.getAttributes(i));
            }
            if (!(bl = dataType.getTypeId() == 4 | dataType.getTypeId() == 12 | dataType.getTypeId() == 13) || !this.m_ShowDate) continue;
            schemaBuilder.add(dataSchema.getColumnName(i), dataType, dataSchema.getAttributes(i));
        }
        return schemaBuilder.getSchema();
    }

    private void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.m_Listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

