/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.GanttTaskType;
import com.elixirtech.chart2.model.GanttTaskUi;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.Legend;
import com.elixirtech.chart2.ui.GanttTab;
import com.elixirtech.chart2.ui.GanttUiTab;
import com.elixirtech.chart2.ui.IChartProvider;
import com.elixirtech.chart2.ui.LegendTab;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.TitleTab;
import com.elixirtech.chart2.ui.TypeSpecificPage;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.wizard.IFinishPage;

public class GanttPage
extends TypeSpecificPage
implements IFinishPage,
IChartProvider {
    public static final String NAME = "Gantt";
    protected GanttTab m_GanttTab;
    protected GanttUiTab m_GanttUiTab;
    protected TitleTab m_TitleTab;
    protected LegendTab m_LegendTab;

    protected GanttPage(String string) {
        super(string);
    }

    public GanttPage() {
        super(NAME);
        this.setTitle(Messages.getString("GanttPage.TITLE"));
    }

    public String getChartTypeName() {
        return Messages.getString("GanttPage.Gantt");
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            IChart iChart = this.getChart();
            this.ensureChartType(iChart);
            this.updatePanels();
            if (!this.m_Initialized) {
                this.init(iChart);
            }
        }
        super.setVisible(bl);
    }

    @Override
    protected void buildTabs() {
        this.m_GanttTab = new GanttTab(this);
        this.m_GanttUiTab = new GanttUiTab();
        this.addTab(this.m_GanttTab);
        this.addTab(this.m_GanttUiTab);
        this.m_TitleTab = new TitleTab(){

            @Override
            public void exited() {
                ChartType chartType = GanttPage.this.getChart().getChartType();
                chartType.setTitle(GanttPage.this.m_TitleTab.getTitle());
            }
        };
        this.addTab(this.m_TitleTab);
        this.m_LegendTab = new LegendTab(){

            @Override
            public void exited() {
                ChartType chartType = GanttPage.this.getChart().getChartType();
                Legend legend = GanttPage.this.m_LegendTab.getLegend();
                chartType.setLegend(legend);
            }
        };
        this.addTab(this.m_LegendTab);
        super.buildTabs();
    }

    protected void updatePanels() {
        this.m_GanttTab.updatePanels(this.m_Wizard);
        this.m_GanttUiTab.updatePanels(this.m_Wizard);
        this.m_TitleTab.updatePanels(this.m_Wizard);
        this.m_LegendTab.updatePanels(this.m_Wizard);
        this.m_ScriptTab.updatePanels(this.m_Wizard);
    }

    @Override
    protected void init(IChart iChart) {
        this.m_GanttTab.init(iChart);
        this.m_GanttUiTab.init(iChart);
        GanttTaskType ganttTaskType = (GanttTaskType)iChart.getChartType();
        this.m_TitleTab.setTitle(ganttTaskType.getTitle());
        Legend legend = ganttTaskType.getLegend();
        this.m_LegendTab.setLegend(legend);
        super.init(iChart);
    }

    @Override
    protected void applyChanges(IChart iChart) {
        if (this.m_Current != null) {
            this.m_Current.exited();
        }
        super.applyChanges(iChart);
        GanttTaskType ganttTaskType = (GanttTaskType)iChart.getChartType();
        ganttTaskType.setTitle(this.m_TitleTab.getTitle());
        ganttTaskType.setLegend(this.m_LegendTab.getLegend());
        super.applyChanges(iChart);
    }

    @Override
    protected void ensureChartType(IChart iChart) {
        if (!(iChart.getChartType() instanceof GanttTaskType)) {
            GanttTaskType ganttTaskType = new GanttTaskType();
            ganttTaskType.setGroup(new ControlSource());
            ganttTaskType.setTask(new ControlSource());
            ganttTaskType.setStart(new ControlSource());
            ganttTaskType.setEnd(new ControlSource());
            ganttTaskType.setPercent(new ControlSource());
            GanttTaskUi ganttTaskUi = new GanttTaskUi();
            ganttTaskUi.init();
            ganttTaskType.setGanttTaskUi(ganttTaskUi);
            iChart.setChartType((ChartType)ganttTaskType);
        }
    }
}

