/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.IChartData;
import com.elixirtech.chart2.model.GanttTaskType;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.ui.IChartProvider;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.IWizard;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

class GanttTab
extends TabComponent {
    private static final String GROUP = "group";
    private static final String TASK = "task";
    private static final String START = "start";
    private static final String END = "end";
    private static final String PERCENT = "percent";
    private IChartProvider m_Page;
    private JComboBox m_Group;
    private JComboBox m_Task;
    private JComboBox m_Start;
    private JComboBox m_End;
    private JComboBox m_Percent;

    public GanttTab(IChartProvider iChartProvider) {
        this.m_Page = iChartProvider;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ArchLayout archLayout = new ArchLayout();
        this.setLayout(archLayout);
        this.m_Group = archLayout.addCombo(this, GROUP, new JLabel(Messages.getString("GanttTab.GROUP")));
        this.m_Task = archLayout.addCombo(this, TASK, new JLabel(Messages.getString("GanttTab.TASK")));
        this.m_Start = archLayout.addCombo(this, START, new JLabel(Messages.getString("GanttTab.START")));
        this.m_End = archLayout.addCombo(this, END, new JLabel(Messages.getString("GanttTab.END")));
        this.m_Percent = archLayout.addCombo(this, PERCENT, new JLabel(Messages.getString("GanttTab.PERCENT")));
        archLayout.stickTop(GROUP);
        archLayout.putRight(GROUP, "group-label,task-label,start-label,end-label,percent-label", 10);
        archLayout.alignBelow(TASK, GROUP);
        archLayout.alignBelow(START, TASK);
        archLayout.alignBelow(END, START);
        archLayout.alignBelow(PERCENT, END);
    }

    public void updatePanels(IWizard iWizard) {
        String[] stringArray;
        DataSchema dataSchema = ((IChartData)iWizard).getSchema();
        if (dataSchema == null) {
            return;
        }
        int n = dataSchema.getColumnCount();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        arrayList.add("");
        arrayList4.add("");
        for (int i = 0; i < n; ++i) {
            stringArray = dataSchema.getColumnType(i);
            if (stringArray.getTypeId() == 2) {
                arrayList.add(dataSchema.getColumnName(i));
                arrayList2.add(dataSchema.getColumnName(i));
                continue;
            }
            if (this.isTimeBased((DataType)stringArray)) {
                arrayList3.add(dataSchema.getColumnName(i));
                continue;
            }
            if (!stringArray.isNumeric()) continue;
            arrayList4.add(dataSchema.getColumnName(i));
        }
        String[] stringArray2 = new String[arrayList.size()];
        stringArray = new String[arrayList2.size()];
        String[] stringArray3 = new String[arrayList3.size()];
        String[] stringArray4 = new String[arrayList4.size()];
        arrayList.toArray(stringArray2);
        arrayList2.toArray(stringArray);
        arrayList3.toArray(stringArray3);
        arrayList4.toArray(stringArray4);
        this.setModel(this.m_Group, stringArray2);
        this.setModel(this.m_Task, stringArray);
        this.setModel(this.m_Start, stringArray3);
        this.setModel(this.m_End, stringArray3);
        this.setModel(this.m_Percent, stringArray4);
        boolean bl = !iWizard.isReadOnly();
        this.m_Group.setEnabled(bl);
        this.m_Task.setEnabled(bl);
        this.m_Start.setEnabled(bl);
        this.m_End.setEnabled(bl);
        this.m_Percent.setEnabled(bl);
    }

    protected void init(IChart iChart) {
        GanttTaskType ganttTaskType = (GanttTaskType)iChart.getChartType();
        this.setCombo(this.m_Group, ganttTaskType.getGroup());
        this.setCombo(this.m_Task, ganttTaskType.getTask());
        this.setCombo(this.m_Start, ganttTaskType.getStart());
        this.setCombo(this.m_End, ganttTaskType.getEnd());
        this.setCombo(this.m_Percent, ganttTaskType.getPercent());
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    @Override
    public void exited() {
        IChart iChart = this.m_Page.getChart();
        GanttTaskType ganttTaskType = (GanttTaskType)iChart.getChartType();
        ganttTaskType.setGroup(this.getControlSource(this.m_Group));
        ganttTaskType.setTask(this.getControlSource(this.m_Task));
        ganttTaskType.setStart(this.getControlSource(this.m_Start));
        ganttTaskType.setEnd(this.getControlSource(this.m_End));
        ganttTaskType.setPercent(this.getControlSource(this.m_Percent));
    }

    @Override
    public String getName() {
        return Messages.getString("GanttTab.DATA");
    }

    @Override
    public String getMessage() {
        return Messages.getString("GanttTab.CHOOSE_DATA_FIELDS");
    }

    @Override
    public void performFinish() {
    }

    private void setCombo(JComboBox jComboBox, ControlSource controlSource) {
        if (controlSource == null) {
            return;
        }
        jComboBox.setSelectedItem(controlSource.getField());
    }

    private ControlSource getControlSource(JComboBox jComboBox) {
        ControlSource controlSource = new ControlSource();
        controlSource.setType("Field");
        controlSource.setField((String)jComboBox.getSelectedItem());
        return controlSource;
    }

    private void setModel(JComboBox jComboBox, String[] stringArray) {
        Object object = jComboBox.getSelectedItem();
        jComboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
        jComboBox.setSelectedItem(object);
    }

    private boolean isTimeBased(DataType dataType) {
        int n = dataType.getTypeId();
        return n == 4 || n == 12 || n == 13;
    }
}

