/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.model.Axis;
import com.elixirtech.chart2.model.GanttTaskType;
import com.elixirtech.chart2.model.GanttTaskUi;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.ui.AxisPanel;
import com.elixirtech.chart2.ui.ColorPanel;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.IWizard;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class GanttUiTab
extends TabComponent {
    public static final String BG_BUTTON = "bg-button";
    public static final String LABELS = "x-name,y-name,bg-name";
    public static final String X_LABEL = "x-label";
    public static final String Y_LABEL = "y-label";
    public static final String GRIDLINES_LABEL = "gridlines-label";
    public static final String DOMAIN_GRIDLINES = "domain-gridlines";
    public static final String RANGE_GRIDLINES = "range-gridlines";
    protected ArchLayout m_Layout = new ArchLayout();
    protected ColorPanel m_Background;
    protected AxisPanel m_XAxisPanel;
    protected AxisPanel m_YAxisPanel;
    protected IChart m_Chart;
    protected GanttTaskUi m_GanttUi;
    protected JCheckBox m_DomainGridlinesVisible;
    protected JCheckBox m_RangeGridlinesVisible;

    public GanttUiTab() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(this.m_Layout);
        this.m_Background = new ColorPanel(Messages.getString("CategoryTab.PLOT_BACKGROUND"));
        this.m_XAxisPanel = new AxisPanel(Messages.getString("CategoryTab.X_AXIS"));
        this.m_YAxisPanel = new AxisPanel(Messages.getString("CategoryTab.Y_AXIS"));
        this.m_DomainGridlinesVisible = new JCheckBox(Messages.getString("CategoryTab.DOMAIN_GRIDLINES"));
        this.m_RangeGridlinesVisible = new JCheckBox(Messages.getString("CategoryTab.RANGE_GRIDLINES"));
        this.m_Background.build(this, "bg");
        this.m_XAxisPanel.build(this, "x");
        this.m_YAxisPanel.build(this, "y");
        this.add(GRIDLINES_LABEL, new JLabel(Messages.getString("CategoryTab.SHOW_GRIDLINES")));
        this.add(DOMAIN_GRIDLINES, this.m_DomainGridlinesVisible);
        this.add(RANGE_GRIDLINES, this.m_RangeGridlinesVisible);
        this.m_Layout.stickTop(BG_BUTTON);
        this.m_Layout.putRight(BG_BUTTON, LABELS, 10);
        this.m_Layout.alignBelow(X_LABEL, BG_BUTTON, 3);
        this.m_Layout.alignBelow(Y_LABEL, X_LABEL);
        this.m_Layout.stickLeft(GRIDLINES_LABEL);
        this.m_Layout.alignBelow(DOMAIN_GRIDLINES, Y_LABEL, 5);
        this.m_Layout.putRight(RANGE_GRIDLINES, DOMAIN_GRIDLINES, 2);
        this.m_Layout.vCenter(GRIDLINES_LABEL, DOMAIN_GRIDLINES);
        this.m_Layout.vCenter(RANGE_GRIDLINES, DOMAIN_GRIDLINES);
    }

    public void init(IChart iChart) {
        this.m_Chart = iChart;
        GanttTaskType ganttTaskType = (GanttTaskType)iChart.getChartType();
        this.init(ganttTaskType.getGanttTaskUi());
    }

    protected void init(GanttTaskUi ganttTaskUi) {
        this.m_GanttUi = ganttTaskUi;
        this.m_Background.setColor(this.m_GanttUi.getPlotBackground());
        Axis axis = this.m_GanttUi.getKeyAxis();
        Axis axis2 = this.m_GanttUi.getValueAxis();
        this.m_YAxisPanel.setAxis(axis);
        this.m_XAxisPanel.setAxis(axis2);
        this.m_DomainGridlinesVisible.setSelected(ganttTaskUi.isDomainGridlinesVisible());
        this.m_RangeGridlinesVisible.setSelected(ganttTaskUi.isRangeGridlinesVisible());
    }

    public void updatePanels(IWizard iWizard) {
        boolean bl = !iWizard.isReadOnly();
        this.m_Background.setEnabled(bl);
        this.m_XAxisPanel.setEnabled(bl);
        this.m_YAxisPanel.setEnabled(bl);
        this.m_DomainGridlinesVisible.setEnabled(bl);
        this.m_RangeGridlinesVisible.setEnabled(bl);
    }

    @Override
    public String getName() {
        return Messages.getString("GanttUiTab.TITLE");
    }

    @Override
    public String getMessage() {
        return Messages.getString("GanttUiTab.MESSAGE");
    }

    @Override
    public void exited() {
        super.exited();
        this.m_GanttUi.setPlotBackground(this.m_Background.getColor());
        Axis axis = this.m_YAxisPanel.getAxis();
        Axis axis2 = this.m_XAxisPanel.getAxis();
        this.m_GanttUi.setKeyAxis(axis);
        this.m_GanttUi.setValueAxis(axis2);
        this.m_GanttUi.setDomainGridlinesVisible(this.m_DomainGridlinesVisible.isSelected());
        this.m_GanttUi.setRangeGridlinesVisible(this.m_RangeGridlinesVisible.isSelected());
    }

    @Override
    public void performFinish() {
    }
}

