/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.I18N;
import com.elixirtech.chart2.model.HeatMapXYType;
import com.elixirtech.chart2.model.HeatMapXYUi;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.ui.AxisPanel;
import com.elixirtech.chart2.ui.ColorPanel;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.Name;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.IWizard;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HeatMapXYAxisTab
extends TabComponent {
    public static final String NAME = "Bubble";
    public static final String BG_BUTTON = "bg-button";
    public static final String LABELS = "x-name,y-name,bg-name";
    public static final String X_LABEL = "x-label";
    public static final String Y_LABEL = "y-label";
    public static final String SCALE_AXIS_LABEL = "scale-axis-label";
    public static final String SCALE_AXIS = "scale-axis";
    public static final String GRIDLINES_LABEL = "gridlines-label";
    public static final String DOMAIN_GRIDLINES = "domain-gridlines";
    public static final String RANGE_GRIDLINES = "range-gridlines";
    public static final String[] POSITION_IDS = new String[]{"top", "bottom", "left", "right"};
    public static final String[] POSITION_KEYS = new String[]{"Position.TOP", "Position.BOTTOM", "Position.LEFT", "Position.RIGHT"};
    private ColorPanel m_Background;
    private ArchLayout m_Layout = new ArchLayout();
    private AxisPanel m_XAxisPanel;
    private AxisPanel m_YAxisPanel;
    private IChart m_Chart;
    private HeatMapXYUi m_HeatMapXYUi;
    private PaintScaleLegend m_PaintScaleLegend;
    protected JCheckBox m_DomainGridlinesVisible;
    protected JCheckBox m_RangeGridlinesVisible;

    public HeatMapXYAxisTab() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 2, 2, 2));
        this.setLayout(this.m_Layout);
        this.m_Background = new ColorPanel(Messages.getString("CategoryTab.PLOT_BACKGROUND"));
        this.m_XAxisPanel = new AxisPanel(Messages.getString("CategoryTab.X_AXIS"));
        this.m_YAxisPanel = new AxisPanel(Messages.getString("CategoryTab.Y_AXIS"));
        this.m_PaintScaleLegend = new PaintScaleLegend();
        this.m_PaintScaleLegend.setName("paintscale");
        this.add(this.m_PaintScaleLegend);
        this.m_Background.build(this, "bg");
        this.m_XAxisPanel.build(this, "x");
        this.m_YAxisPanel.build(this, "y");
        this.m_DomainGridlinesVisible = new JCheckBox(Messages.getString("CategoryTab.DOMAIN_GRIDLINES"));
        this.m_RangeGridlinesVisible = new JCheckBox(Messages.getString("CategoryTab.RANGE_GRIDLINES"));
        this.add(GRIDLINES_LABEL, new JLabel(Messages.getString("CategoryTab.SHOW_GRIDLINES")));
        this.add(DOMAIN_GRIDLINES, this.m_DomainGridlinesVisible);
        this.add(RANGE_GRIDLINES, this.m_RangeGridlinesVisible);
        this.m_Layout.stickTop(BG_BUTTON);
        this.m_Layout.putRight(BG_BUTTON, LABELS, 4);
        this.m_Layout.alignBelow(X_LABEL, BG_BUTTON, 5);
        this.m_Layout.alignBelow(Y_LABEL, X_LABEL, 5);
        this.m_Layout.stickLeft(GRIDLINES_LABEL);
        this.m_Layout.alignBelow(DOMAIN_GRIDLINES, Y_LABEL, 5);
        this.m_Layout.putRight(RANGE_GRIDLINES, DOMAIN_GRIDLINES, 5);
        this.m_Layout.vCenter(GRIDLINES_LABEL, DOMAIN_GRIDLINES);
        this.m_Layout.vCenter(RANGE_GRIDLINES, DOMAIN_GRIDLINES);
        this.m_Layout.putBelow("paintscale", GRIDLINES_LABEL, 5);
        this.m_Layout.stickLeft("paintscale");
        this.m_Layout.stickRight("paintscale");
    }

    public void init(IChart iChart) {
        this.m_Chart = iChart;
        HeatMapXYType heatMapXYType = (HeatMapXYType)iChart.getChartType();
        this.m_HeatMapXYUi = heatMapXYType.getHeatMapXYUi();
        this.m_Background.setColor(this.m_HeatMapXYUi.getPlotBackground());
        this.m_XAxisPanel.setAxis(this.m_HeatMapXYUi.getXAxis());
        this.m_YAxisPanel.setAxis(this.m_HeatMapXYUi.getYAxis());
        this.m_PaintScaleLegend.init(this.m_HeatMapXYUi);
        this.m_DomainGridlinesVisible.setSelected(this.m_HeatMapXYUi.isDomainGridlinesVisible());
        this.m_RangeGridlinesVisible.setSelected(this.m_HeatMapXYUi.isRangeGridlinesVisible());
    }

    public void updatePanels(IWizard iWizard) {
        boolean bl = !iWizard.isReadOnly();
        this.m_Background.setEnabled(bl);
        this.m_XAxisPanel.setEnabled(bl);
        this.m_YAxisPanel.setEnabled(bl);
        this.m_PaintScaleLegend.setEnabled(bl);
        this.m_RangeGridlinesVisible.setEnabled(bl);
        this.m_DomainGridlinesVisible.setEnabled(bl);
    }

    @Override
    public void exited() {
        this.m_HeatMapXYUi.setPlotBackground(this.m_Background.getColor());
        this.m_HeatMapXYUi.setXAxis(this.m_XAxisPanel.getAxis());
        this.m_HeatMapXYUi.setYAxis(this.m_YAxisPanel.getAxis());
        this.m_PaintScaleLegend.update(this.m_HeatMapXYUi);
        this.m_HeatMapXYUi.setDomainGridlinesVisible(this.m_DomainGridlinesVisible.isSelected());
        this.m_HeatMapXYUi.setRangeGridlinesVisible(this.m_RangeGridlinesVisible.isSelected());
    }

    @Override
    public String getMessage() {
        return Messages.getString("HeatMapXYAxisTab.MESSAGE");
    }

    @Override
    public String getName() {
        return Messages.getString("HeatMapXYAxisTab.TITLE");
    }

    @Override
    public void performFinish() {
    }

    public static class PaintScaleLegend
    extends JPanel {
        private JCheckBox m_ShowLegend;
        private JTextField m_LegendName;
        private I18NComboBox m_LegendPosition;

        public PaintScaleLegend() {
            this.setBorder(BorderFactory.createTitledBorder(I18N.CHART_UI.getString("HeatMapXYAxisTab.PAINTSCALE_LEGEND")));
            ArchLayout archLayout = new ArchLayout();
            this.setLayout(archLayout);
            JLabel jLabel = SwingFactory.newLabel("name-label");
            jLabel.setText(I18N.CHART_UI.getString("PaintScaleLegend.NAME"));
            this.m_LegendName = SwingFactory.newTextField("name", 20);
            this.add(jLabel);
            this.add(this.m_LegendName);
            archLayout.stickTop("name-label");
            archLayout.stickLeft("name-label");
            archLayout.stickTop("name");
            archLayout.stickRight("name");
            archLayout.putRight("name", "name-label", 25);
            JLabel jLabel2 = SwingFactory.newLabel("position-label");
            jLabel2.setText(I18N.CHART_UI.getString("PaintScaleLegend.POSITION"));
            Name[] nameArray = I18NComboBox.buildNames(POSITION_IDS, I18N.CHART_UI, POSITION_KEYS);
            this.m_LegendPosition = SwingFactory.newI18NComboBox("position", nameArray);
            this.add(jLabel2);
            this.add(this.m_LegendPosition);
            archLayout.putBelow("position-label", "name-label", 10);
            archLayout.stickLeft("position-label");
            archLayout.putRight("position", "position-label", 10);
            archLayout.vCenter("position", "position-label");
            this.m_ShowLegend = SwingFactory.newCheckBox("show");
            this.m_ShowLegend.setText(I18N.CHART_UI.getString("PaintScaleLegend.SHOW"));
            this.add(this.m_ShowLegend);
            archLayout.putRight("show", "position", 10);
            archLayout.vCenter("show", "position");
        }

        public void init(HeatMapXYUi heatMapXYUi) {
            this.m_LegendName.setText(heatMapXYUi.getScaleLegendLabel());
            this.m_ShowLegend.setSelected(heatMapXYUi.isScaleLegendVisible());
            this.m_LegendPosition.setSelectedId(heatMapXYUi.getScaleLegendPosition());
        }

        public void update(HeatMapXYUi heatMapXYUi) {
            heatMapXYUi.setScaleLegendLabel(this.m_LegendName.getText());
            heatMapXYUi.setScaleLegendVisible(this.m_ShowLegend.isSelected());
            heatMapXYUi.setScaleLegendPosition(this.m_LegendPosition.getSelectedId());
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            SwingUtil.setEnabled(this, bl);
        }
    }
}

