/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.model.HeatMapLookupItem;
import com.elixirtech.chart2.model.HeatMapXYType;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.ui.ColorSelector;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.ui.NumberDocument;
import com.elixirtech.ui.OrderedEditableTable;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumn;

public class HeatMapXYConfigTab
extends TabComponent {
    private JTextField m_LowerBound;
    private JTextField m_UpperBound;
    private JRadioButton m_GreyScale;
    private JRadioButton m_LookUpScale;
    private LookUpPanel m_LookUpPanel;
    private HeatMapXYType m_HeatMapXYType;

    public HeatMapXYConfigTab() {
        this.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 1));
        this.setLayout(new BorderLayout());
        this.m_LookUpPanel = new LookUpPanel();
        this.add("Center", this.m_LookUpPanel);
        this.add("North", this.buildHeatMapConfig());
        this.m_GreyScale.setSelected(true);
        this.m_LookUpPanel.setVisible(false);
    }

    public void init(IChart iChart) {
        this.m_HeatMapXYType = (HeatMapXYType)iChart.getChartType();
        this.m_LookUpPanel.setHeatMapType(this.m_HeatMapXYType.deepCopy());
        this.m_LowerBound.setText(this.getStringValue(this.m_HeatMapXYType.getLowerBound()));
        this.m_UpperBound.setText(this.getStringValue(this.m_HeatMapXYType.getUpperBound()));
        if ("lookup-paintscale".equals(this.m_HeatMapXYType.getPaintScale())) {
            this.m_LookUpScale.setSelected(true);
        } else {
            this.m_GreyScale.setSelected(true);
        }
        this.showLookup();
    }

    private String getStringValue(double d) {
        return Double.toString(d);
    }

    public void updatePanels(IWizard iWizard) {
        SwingUtil.setEnabled(this, !iWizard.isReadOnly());
    }

    @Override
    public void exited() {
        JTable jTable = this.m_LookUpPanel.getTable();
        if (jTable.isEditing()) {
            jTable.getCellEditor().stopCellEditing();
        }
        this.m_HeatMapXYType.setLowerBound(Double.parseDouble(this.m_LowerBound.getText()));
        this.m_HeatMapXYType.setUpperBound(Double.parseDouble(this.m_UpperBound.getText()));
        if (this.m_LookUpScale.isSelected()) {
            this.m_HeatMapXYType.setPaintScale("lookup-paintscale");
        } else {
            this.m_HeatMapXYType.setPaintScale("gray-paintscale");
        }
        this.m_HeatMapXYType.setDefaultPaint(this.m_LookUpPanel.getColorString());
        this.m_HeatMapXYType.setHeatMapLookupItemList(this.m_LookUpPanel.getHeatMapLookupItemList());
    }

    private JPanel buildHeatMapConfig() {
        JLabel jLabel = SwingFactory.newLabel("start-label");
        jLabel.setText(Messages.getString("HeatMapXYConfigTab.start-label"));
        JLabel jLabel2 = SwingFactory.newLabel("end-label");
        jLabel2.setText(Messages.getString("HeatMapXYConfigTab.end-label"));
        this.m_LowerBound = SwingFactory.newTextField("start", 15);
        this.m_UpperBound = SwingFactory.newTextField("end", 15);
        this.m_LowerBound.setDocument(new NumberDocument());
        this.m_UpperBound.setDocument(new NumberDocument());
        NumberFieldWatcher numberFieldWatcher = new NumberFieldWatcher();
        this.m_LowerBound.getDocument().addDocumentListener(numberFieldWatcher);
        this.m_UpperBound.getDocument().addDocumentListener(numberFieldWatcher);
        ArchLayout archLayout = new ArchLayout();
        JPanel jPanel = new JPanel(archLayout);
        jPanel.setName("heatmap-config");
        jPanel.add(jLabel);
        jPanel.add(this.m_LowerBound);
        jPanel.add(this.m_UpperBound);
        jPanel.add(jLabel2);
        archLayout.stickTop("start-label");
        archLayout.stickTop("start");
        archLayout.stickTop("end-label");
        archLayout.stickTop("end");
        archLayout.stickRight("end");
        archLayout.stickLeft("start-label");
        archLayout.putRight("start", "start-label", 1);
        archLayout.putRight("end-label", "start", 1);
        archLayout.putRight("end", "end-label", 1);
        archLayout.setHeight("start-label", "start");
        archLayout.setHeight("start", "end-label");
        archLayout.setHeight("end-label", "end");
        this.m_GreyScale = new JRadioButton(Messages.getString("HeatMapXYConfigTab.GREYPAINTSCALE"));
        this.m_GreyScale.setName("gray");
        this.m_LookUpScale = new JRadioButton(Messages.getString("HeatMapXYConfigTab.LOOKUPPAINTSCALE"));
        this.m_LookUpScale.setName("lookup");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_GreyScale);
        buttonGroup.add(this.m_LookUpScale);
        PaintScaleSectionListener paintScaleSectionListener = new PaintScaleSectionListener();
        this.m_GreyScale.addActionListener(paintScaleSectionListener);
        this.m_LookUpScale.addActionListener(paintScaleSectionListener);
        jPanel.add(this.m_GreyScale);
        jPanel.add(this.m_LookUpScale);
        archLayout.alignBelow("gray", "start", 2);
        archLayout.alignBelow("lookup", "end-label", 2);
        archLayout.setHeight("gray", "lookup");
        return jPanel;
    }

    @Override
    public String getMessage() {
        return Messages.getString("HeatMapXYConfigTab.MESSAGE");
    }

    @Override
    public String getName() {
        return Messages.getString("HeatMapXYConfigTab.TITLE");
    }

    @Override
    public void performFinish() {
    }

    private void showLookup() {
        if (this.m_GreyScale.isSelected()) {
            this.m_LookUpPanel.setVisible(false);
        } else {
            this.m_LookUpPanel.setVisible(true);
        }
    }

    public static class LookUpPanel
    extends JPanel {
        private BoxIcon m_ColorIcon;
        private Color m_Color;
        private JLabel m_ColorDefault;
        private LookupItemTable m_LookupItemTable;

        public LookUpPanel() {
            ArchLayout archLayout = new ArchLayout();
            this.setLayout(archLayout);
            this.m_LookupItemTable = new LookupItemTable(new LookupItemModel());
            JLabel jLabel = new JLabel(Messages.getString("HeatMapXYConfigTab.DEFAULTCOLOR"));
            this.m_ColorDefault = new JLabel();
            this.m_ColorIcon = new BoxIcon(1);
            this.m_ColorDefault.setIcon(this.m_ColorIcon);
            JButton jButton = new JButton("...");
            jButton.addActionListener(new OpenColorDialog());
            this.add("table", this.m_LookupItemTable);
            this.add("lbl", jLabel);
            this.add("lbl-color", this.m_ColorDefault);
            this.add("btn-color", jButton);
            archLayout.stickLeft("lbl");
            archLayout.stickTop("lbl");
            archLayout.stickTop("lbl-color");
            archLayout.stickTop("btn-color");
            archLayout.putRight("lbl-color", "lbl", 5);
            archLayout.putRight("btn-color", "lbl-color", 5);
            archLayout.setHeight("btn-color", "lbl-color");
            archLayout.alignBelow("table", "lbl", 5);
            archLayout.stickRight("table");
            archLayout.stickBottom("table");
        }

        public JTable getTable() {
            return this.m_LookupItemTable.getTable();
        }

        public void setHeatMapType(HeatMapXYType heatMapXYType) {
            this.m_LookupItemTable.setHeatMapType(heatMapXYType);
            this.m_Color = StandardColor.lookup(heatMapXYType.getDefaultPaint(), "white");
            this.m_ColorIcon.setColor(this.m_Color);
            this.m_ColorDefault.setText(heatMapXYType.getDefaultPaint());
        }

        public String getColorString() {
            return this.m_ColorDefault.getText();
        }

        public List<HeatMapLookupItem> getHeatMapLookupItemList() {
            return this.m_LookupItemTable.getHeatMapLookupItemList();
        }

        class OpenColorDialog
        implements ActionListener {
            OpenColorDialog() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string = Messages.getString("HeatMapXYConfigTab.COLOR_DIALOG");
                        Color color = JColorChooser.showDialog(LookUpPanel.this.m_ColorDefault, string, LookUpPanel.this.m_Color);
                        if (color != null) {
                            LookUpPanel.this.m_ColorDefault.setText(StandardColor.getColorName(color));
                            LookUpPanel.this.m_Color = color;
                            LookUpPanel.this.m_ColorIcon.setColor(LookUpPanel.this.m_Color);
                            LookUpPanel.this.m_ColorDefault.repaint();
                        }
                    }
                });
            }
        }
    }

    class NumberFieldWatcher
    implements DocumentListener {
        private Color m_Right;

        NumberFieldWatcher() {
            this.m_Right = HeatMapXYConfigTab.this.m_LowerBound.getForeground();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        private void update() {
            block5: {
                String string = HeatMapXYConfigTab.this.m_LowerBound.getText();
                String string2 = HeatMapXYConfigTab.this.m_UpperBound.getText();
                if (!StringUtil.isEmpty(string) && !StringUtil.isEmpty(string2)) {
                    try {
                        double d = Double.parseDouble(string);
                        double d2 = Double.parseDouble(string2);
                        if (d2 >= d) {
                            this.correct();
                            break block5;
                        }
                        this.error();
                    }
                    catch (Exception exception) {
                        this.error();
                    }
                } else {
                    this.error();
                }
            }
        }

        private void error() {
            HeatMapXYConfigTab.this.m_LowerBound.setForeground(Color.RED);
            HeatMapXYConfigTab.this.m_UpperBound.setForeground(Color.RED);
        }

        private void correct() {
            HeatMapXYConfigTab.this.m_LowerBound.setForeground(this.m_Right);
            HeatMapXYConfigTab.this.m_UpperBound.setForeground(this.m_Right);
        }
    }

    class PaintScaleSectionListener
    implements ActionListener {
        PaintScaleSectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HeatMapXYConfigTab.this.showLookup();
        }
    }

    protected static class LookupItemModel
    extends ElxTableModel {
        private static String[] COLUMNS = new String[]{"HeatMapXYConfigTab.NAME", "HeatMapXYConfigTab.VALUE", "HeatMapXYConfigTab.COLOR"};
        private HeatMapXYType m_HeatMapXYType;

        public LookupItemModel() {
            super(Messages.RESOURCE_BUNDLE, COLUMNS);
        }

        public void setHeatMapType(HeatMapXYType heatMapXYType) {
            this.m_HeatMapXYType = heatMapXYType;
        }

        @Override
        public int getRowCount() {
            if (this.m_HeatMapXYType == null) {
                return 0;
            }
            return this.m_HeatMapXYType.getHeatMapLookupItemCount();
        }

        public Class getColumClass(int n) {
            if (n == 1) {
                return Double.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.m_HeatMapXYType.getHeatMapLookupItem(n).getName();
            }
            if (n2 == 1) {
                return this.m_HeatMapXYType.getHeatMapLookupItem(n).getValue();
            }
            if (n2 == 2) {
                return this.m_HeatMapXYType.getHeatMapLookupItem(n).getPaint();
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this.m_HeatMapXYType.getHeatMapLookupItem(n).setName((String)object);
            } else if (n2 == 1) {
                Double d = null;
                try {
                    d = Double.valueOf((String)object);
                }
                catch (Exception exception) {
                    d = 0.0;
                }
                this.m_HeatMapXYType.getHeatMapLookupItem(n).setValue(d.doubleValue());
            } else if (n2 == 2) {
                this.m_HeatMapXYType.getHeatMapLookupItem(n).setPaint((String)object);
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }

    protected static class LookupItemTable
    extends OrderedEditableTable {
        private HeatMapLookupItem m_Copy;
        private HeatMapXYType m_HeatMapXYType;
        private LookupItemModel m_LookupModel;

        public LookupItemTable(LookupItemModel lookupItemModel) {
            super(lookupItemModel, false, false);
            this.setAutoResizeMode(3);
            TableColumn tableColumn = this.getTable().getColumnModel().getColumn(2);
            tableColumn.setCellRenderer(new ColorSelector());
            tableColumn.setCellEditor(new ColorSelector());
            TableColumn tableColumn2 = this.getTable().getColumnModel().getColumn(1);
            JTextField jTextField = new JTextField();
            jTextField.setBorder(BorderFactory.createEmptyBorder());
            jTextField.setDocument(new NumberDocument());
            tableColumn2.setCellEditor(new DefaultCellEditor(jTextField));
            this.m_LookupModel = lookupItemModel;
        }

        public void setHeatMapType(HeatMapXYType heatMapXYType) {
            this.m_HeatMapXYType = heatMapXYType;
            this.m_LookupModel.setHeatMapType(heatMapXYType);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("plus".equals(string)) {
                this.addLookUpItem();
            } else if ("minus".equals(string)) {
                this.removeLookUpItem();
            } else if ("copy".equals(string)) {
                this.copy();
            } else if ("paste".equals(string)) {
                this.paste();
            } else if ("up".equals(string)) {
                this.moveUp();
            } else if ("down".equals(string)) {
                this.moveDown();
            }
        }

        private void addLookUpItem() {
            HeatMapLookupItem heatMapLookupItem = new HeatMapLookupItem();
            heatMapLookupItem.setName("");
            heatMapLookupItem.setPaint("white");
            heatMapLookupItem.setValue(Double.valueOf(0.0).doubleValue());
            this.m_HeatMapXYType.addHeatMapLookupItem(heatMapLookupItem);
            this.m_LookupModel.fireTableDataChanged();
        }

        private void removeLookUpItem() {
            int n = this.getSelectedRow();
            this.m_HeatMapXYType.getHeatMapLookupItemList().remove(n);
            this.m_LookupModel.fireTableDataChanged();
        }

        private void copy() {
            int n = this.getSelectedRow();
            this.m_Copy = this.m_HeatMapXYType.getHeatMapLookupItem(n);
            this.m_LookupModel.fireTableDataChanged();
        }

        private void paste() {
            if (this.m_Copy != null) {
                this.m_HeatMapXYType.addHeatMapLookupItem(this.m_Copy.deepCopy());
                this.m_LookupModel.fireTableDataChanged();
            }
        }

        public void moveUp() {
            int n = this.getSelectedRow();
            HeatMapLookupItem heatMapLookupItem = (HeatMapLookupItem)this.m_HeatMapXYType.getHeatMapLookupItemList().remove(n);
            this.m_HeatMapXYType.addHeatMapLookupItem(--n, heatMapLookupItem);
            this.m_LookupModel.fireTableDataChanged();
            this.select(n);
        }

        public void moveDown() {
            int n = this.getSelectedRow();
            HeatMapLookupItem heatMapLookupItem = (HeatMapLookupItem)this.m_HeatMapXYType.getHeatMapLookupItemList().remove(n);
            this.m_HeatMapXYType.addHeatMapLookupItem(++n, heatMapLookupItem);
            this.getTable().setRowSelectionInterval(n, n);
            this.m_LookupModel.fireTableDataChanged();
            this.select(n);
        }

        public List<HeatMapLookupItem> getHeatMapLookupItemList() {
            return this.m_HeatMapXYType.getHeatMapLookupItemList();
        }
    }

    static class BoxIcon
    implements Icon {
        private Color m_Color = Color.WHITE;
        private int borderWidth;

        public void setColor(Color color) {
            this.m_Color = color;
        }

        BoxIcon(int n) {
            this.borderWidth = n;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.black);
            graphics.fillRect(n, n2, this.getIconWidth(), this.getIconHeight());
            graphics.setColor(this.m_Color);
            graphics.fillRect(n + this.borderWidth, n2 + this.borderWidth, this.getIconWidth() - 2 * this.borderWidth, this.getIconHeight() - 2 * this.borderWidth);
        }
    }
}

