/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.HeatMapXYType;
import com.elixirtech.chart2.model.HeatMapXYUi;
import com.elixirtech.chart2.model.ICategory3dBaseType;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.ui.DataTab;
import com.elixirtech.chart2.ui.HeatMapXYAxisTab;
import com.elixirtech.chart2.ui.HeatMapXYConfigTab;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.TitleTab;
import com.elixirtech.chart2.ui.TypeSpecificPage;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.wizard.IFinishPage;

public class HeatMapXYPage
extends TypeSpecificPage
implements IFinishPage {
    public static String NAME = "HeatMapXY";
    private TitleTab m_TitleTab;
    private HeatMapXYAxisTab m_HeatMapXYTab;
    private HeatMapXYConfigTab m_HeatMapXYConfigTab;
    private DataTab m_XTab;
    private DataTab m_YTab;
    private DataTab m_ZTab;

    public HeatMapXYPage() {
        super(NAME);
        this.setTitle(Messages.getString("HeatMapPageXY.TITLE"));
    }

    @Override
    protected void init(IChart iChart) {
        HeatMapXYType heatMapXYType = (HeatMapXYType)iChart.getChartType();
        this.m_XTab.setControlSource(heatMapXYType.getXSource());
        this.m_YTab.setControlSource(heatMapXYType.getYSource());
        this.m_ZTab.setControlSource(heatMapXYType.getZSource());
        this.m_TitleTab.setTitle(heatMapXYType.getTitle());
        this.m_HeatMapXYTab.init(iChart);
        this.m_HeatMapXYConfigTab.init(iChart);
        super.init(iChart);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            IChart iChart = this.getChart();
            this.ensureChartType(iChart);
            this.updatePanels();
            if (!this.m_Initialized) {
                this.init(iChart);
            }
        }
        super.setVisible(bl);
    }

    @Override
    protected void buildTabs() {
        this.m_XTab = new DataTab(Messages.getString("3DCategoryPage.X"), 7, false){

            @Override
            public void exited() {
                ICategory3dBaseType iCategory3dBaseType = (ICategory3dBaseType)HeatMapXYPage.this.getChart().getChartType();
                iCategory3dBaseType.setXSource(this.getControlSource());
            }
        };
        this.m_XTab.setShowNumeric(true);
        this.addTab(this.m_XTab);
        this.m_YTab = new DataTab(Messages.getString("3DCategoryPage.Y"), 7, false){

            @Override
            public void exited() {
                ICategory3dBaseType iCategory3dBaseType = (ICategory3dBaseType)HeatMapXYPage.this.getChart().getChartType();
                iCategory3dBaseType.setYSource(this.getControlSource());
            }
        };
        this.m_YTab.setShowNumeric(true);
        this.addTab(this.m_YTab);
        this.m_ZTab = new DataTab(Messages.getString("BubblePage.VALUE"), 7, false){

            @Override
            public void exited() {
                ICategory3dBaseType iCategory3dBaseType = (ICategory3dBaseType)HeatMapXYPage.this.getChart().getChartType();
                iCategory3dBaseType.setZSource(this.getControlSource());
            }
        };
        this.m_ZTab.setShowNumeric(true);
        this.addTab(this.m_ZTab);
        this.m_HeatMapXYConfigTab = new HeatMapXYConfigTab();
        this.addTab(this.m_HeatMapXYConfigTab);
        this.m_TitleTab = new TitleTab(){

            @Override
            public void exited() {
                ChartType chartType = HeatMapXYPage.this.getChart().getChartType();
                chartType.setTitle(HeatMapXYPage.this.m_TitleTab.getTitle());
            }
        };
        this.addTab(this.m_TitleTab);
        this.m_HeatMapXYTab = new HeatMapXYAxisTab();
        this.addTab(this.m_HeatMapXYTab);
        super.buildTabs();
    }

    protected void updatePanels() {
        this.m_XTab.updatePanels(this.m_Wizard);
        this.m_YTab.updatePanels(this.m_Wizard);
        this.m_ZTab.updatePanels(this.m_Wizard);
        this.m_TitleTab.updatePanels(this.m_Wizard);
        this.m_HeatMapXYTab.updatePanels(this.m_Wizard);
        this.m_HeatMapXYConfigTab.updatePanels(this.m_Wizard);
    }

    @Override
    protected void ensureChartType(IChart iChart) {
        if (!(iChart.getChartType() instanceof HeatMapXYType)) {
            HeatMapXYType heatMapXYType = new HeatMapXYType();
            heatMapXYType.setXSource(new ControlSource());
            heatMapXYType.setYSource(new ControlSource());
            heatMapXYType.setZSource(new ControlSource());
            HeatMapXYUi heatMapXYUi = new HeatMapXYUi();
            heatMapXYUi.init();
            heatMapXYType.setHeatMapXYUi(heatMapXYUi);
            iChart.setChartType((ChartType)heatMapXYType);
        }
    }

    @Override
    protected void applyChanges(IChart iChart) {
        if (this.m_Current != null) {
            this.m_Current.exited();
        }
        super.applyChanges(iChart);
        HeatMapXYType heatMapXYType = (HeatMapXYType)iChart.getChartType();
        heatMapXYType.setXSource(this.m_XTab.getControlSource());
        heatMapXYType.setYSource(this.m_YTab.getControlSource());
        heatMapXYType.setZSource(this.m_ZTab.getControlSource());
        heatMapXYType.setTitle(this.m_TitleTab.getTitle());
    }
}

