/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.IChartData;
import com.elixirtech.chart2.model.HighLowType;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.ui.IChartProvider;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.JColorChooserEx;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;

class HighLowDataTab
extends TabComponent
implements ActionListener {
    private static final String DATE = "date";
    private static final String HIGH = "high";
    private static final String LOW = "low";
    private static final String OPEN = "open";
    private static final String CLOSE = "close";
    private static final String VOLUME = "volume";
    private IChartProvider m_Page;
    private JComboBox m_Date;
    private JComboBox m_High;
    private JComboBox m_Low;
    private JComboBox m_Open;
    private JComboBox m_Close;
    private JComboBox m_Volume;

    public HighLowDataTab(IChartProvider iChartProvider) {
        this.m_Page = iChartProvider;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ArchLayout archLayout = new ArchLayout();
        this.setLayout(archLayout);
        this.m_Date = archLayout.addCombo(this, DATE, new JLabel(Messages.getString("HighLowDataTab.DATE")));
        this.m_High = archLayout.addCombo(this, HIGH, new JLabel(Messages.getString("HighLowDataTab.HIGH")));
        this.m_Low = archLayout.addCombo(this, LOW, new JLabel(Messages.getString("HighLowDataTab.LOW")));
        this.m_Open = archLayout.addCombo(this, OPEN, new JLabel(Messages.getString("HighLowDataTab.OPEN")));
        this.m_Close = archLayout.addCombo(this, CLOSE, new JLabel(Messages.getString("HighLowDataTab.CLOSE")));
        this.m_Volume = archLayout.addCombo(this, VOLUME, new JLabel(Messages.getString("HighLowDataTab.VOLUME")));
        archLayout.stickTop(DATE);
        archLayout.putRight(DATE, "date-label,high-label,low-label,open-label,close-label,volume-label", 10);
        archLayout.alignBelow(HIGH, DATE);
        archLayout.alignBelow(LOW, HIGH);
        archLayout.alignBelow(OPEN, LOW);
        archLayout.alignBelow(CLOSE, OPEN);
        archLayout.alignBelow(VOLUME, CLOSE);
    }

    public void updatePanels(IWizard iWizard) {
        String[] stringArray;
        DataSchema dataSchema = ((IChartData)iWizard).getSchema();
        if (dataSchema == null) {
            return;
        }
        int n = dataSchema.getColumnCount();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            stringArray = dataSchema.getColumnType(i);
            if (stringArray.getTypeId() == 4) {
                arrayList.add(dataSchema.getColumnName(i));
                continue;
            }
            if (!stringArray.isNumeric()) continue;
            arrayList2.add(dataSchema.getColumnName(i));
        }
        String[] stringArray2 = new String[arrayList.size()];
        stringArray = new String[arrayList2.size()];
        arrayList.toArray(stringArray2);
        arrayList2.toArray(stringArray);
        this.setModel(this.m_Date, stringArray2);
        this.setModel(this.m_High, stringArray);
        this.setModel(this.m_Low, stringArray);
        this.setModel(this.m_Open, stringArray);
        this.setModel(this.m_Close, stringArray);
        this.setModel(this.m_Volume, stringArray);
        boolean bl = !iWizard.isReadOnly();
        this.m_Date.setEnabled(bl);
        this.m_High.setEnabled(bl);
        this.m_Low.setEnabled(bl);
        this.m_Open.setEnabled(bl);
        this.m_Close.setEnabled(bl);
        this.m_Volume.setEnabled(bl);
    }

    protected void init(IChart iChart) {
        HighLowType highLowType = (HighLowType)iChart.getChartType();
        this.setCombo(this.m_Date, highLowType.getDateSource());
        this.setCombo(this.m_High, highLowType.getHighSource());
        this.setCombo(this.m_Low, highLowType.getLowSource());
        this.setCombo(this.m_Open, highLowType.getOpenSource());
        this.setCombo(this.m_Close, highLowType.getCloseSource());
        this.setCombo(this.m_Volume, highLowType.getVolumeSource());
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    @Override
    public void exited() {
        IChart iChart = this.m_Page.getChart();
        HighLowType highLowType = (HighLowType)iChart.getChartType();
        highLowType.setDateSource(this.getControlSource(this.m_Date));
        highLowType.setHighSource(this.getControlSource(this.m_High));
        highLowType.setLowSource(this.getControlSource(this.m_Low));
        highLowType.setOpenSource(this.getControlSource(this.m_Open));
        highLowType.setCloseSource(this.getControlSource(this.m_Close));
        highLowType.setVolumeSource(this.getControlSource(this.m_Volume));
    }

    @Override
    public String getName() {
        return Messages.getString("HighLowDataTab.DATA");
    }

    @Override
    public String getMessage() {
        return Messages.getString("HighLowDataTab.CHOOSE_DATA_FIELDS");
    }

    @Override
    public void performFinish() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        JButton jButton = (JButton)actionEvent.getSource();
        Color color = jButton.getBackground();
        color = JColorChooserEx.showDialog(this, string, color);
        jButton.setBackground(color);
    }

    private void setCombo(JComboBox jComboBox, ControlSource controlSource) {
        if (controlSource == null) {
            return;
        }
        jComboBox.setSelectedItem(controlSource.getField());
    }

    private ControlSource getControlSource(JComboBox jComboBox) {
        ControlSource controlSource = new ControlSource();
        controlSource.setType("Field");
        controlSource.setField((String)jComboBox.getSelectedItem());
        return controlSource;
    }

    private void setModel(JComboBox jComboBox, String[] stringArray) {
        Object object = jComboBox.getSelectedItem();
        jComboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
        jComboBox.setSelectedItem(object);
    }
}

