/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.HighLowType;
import com.elixirtech.chart2.model.HighLowUi;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.ui.HighLowDataTab;
import com.elixirtech.chart2.ui.HighLowTab;
import com.elixirtech.chart2.ui.IChartProvider;
import com.elixirtech.chart2.ui.LegendTab;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.TitleTab;
import com.elixirtech.chart2.ui.TypeSpecificPage;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.wizard.IFinishPage;

public class HighLowPage
extends TypeSpecificPage
implements IFinishPage,
IChartProvider {
    public static final String NAME = "HighLow";
    protected HighLowDataTab m_DataTab;
    protected HighLowTab m_HighLowTab;
    protected TitleTab m_TitleTab;
    protected LegendTab m_LegendTab;

    protected HighLowPage(String string) {
        super(string);
    }

    public HighLowPage() {
        super(NAME);
        this.setTitle(Messages.getString("HighLowPage.TITLE"));
    }

    public String getChartTypeName() {
        return Messages.getString("HighLowPage.HIGHLOW");
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            IChart iChart = this.getChart();
            this.ensureChartType(iChart);
            this.updatePanels();
            if (!this.m_Initialized) {
                this.init(iChart);
            }
        }
        super.setVisible(bl);
    }

    @Override
    protected void buildTabs() {
        this.m_DataTab = new HighLowDataTab(this);
        this.addTab(this.m_DataTab);
        this.m_HighLowTab = new HighLowTab(this.getChartTypeName());
        this.addTab(this.m_HighLowTab);
        this.m_TitleTab = new TitleTab(){

            @Override
            public void exited() {
                ChartType chartType = HighLowPage.this.getChart().getChartType();
                chartType.setTitle(HighLowPage.this.m_TitleTab.getTitle());
            }
        };
        this.addTab(this.m_TitleTab);
        this.m_LegendTab = new LegendTab(){

            @Override
            public void exited() {
                ChartType chartType = HighLowPage.this.getChart().getChartType();
                chartType.setLegend(HighLowPage.this.m_LegendTab.getLegend());
            }
        };
        this.addTab(this.m_LegendTab);
        super.buildTabs();
    }

    protected void updatePanels() {
        this.m_DataTab.updatePanels(this.m_Wizard);
        this.m_HighLowTab.updatePanels(this.m_Wizard);
        this.m_TitleTab.updatePanels(this.m_Wizard);
        this.m_LegendTab.updatePanels(this.m_Wizard);
        this.m_ScriptTab.updatePanels(this.m_Wizard);
    }

    @Override
    protected void init(IChart iChart) {
        HighLowType highLowType = (HighLowType)iChart.getChartType();
        this.m_DataTab.init(iChart);
        this.m_HighLowTab.init(iChart);
        this.m_TitleTab.setTitle(highLowType.getTitle());
        this.m_LegendTab.setLegend(highLowType.getLegend());
        super.init(iChart);
    }

    @Override
    protected void applyChanges(IChart iChart) {
        if (this.m_Current != null) {
            this.m_Current.exited();
        }
        super.applyChanges(iChart);
        HighLowType highLowType = (HighLowType)iChart.getChartType();
        this.m_DataTab.exited();
        this.m_HighLowTab.exited();
        highLowType.setTitle(this.m_TitleTab.getTitle());
        highLowType.setLegend(this.m_LegendTab.getLegend());
    }

    @Override
    protected void ensureChartType(IChart iChart) {
        if (!(iChart.getChartType() instanceof HighLowType)) {
            HighLowType highLowType = new HighLowType();
            highLowType.setDateSource(new ControlSource());
            highLowType.setHighSource(new ControlSource());
            highLowType.setLowSource(new ControlSource());
            highLowType.setOpenSource(new ControlSource());
            highLowType.setCloseSource(new ControlSource());
            highLowType.setVolumeSource(new ControlSource());
            HighLowUi highLowUi = new HighLowUi();
            highLowUi.init();
            highLowType.setHighLowUi(highLowUi);
            iChart.setChartType((ChartType)highLowType);
        }
    }
}

