/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.model.HighLowType;
import com.elixirtech.chart2.model.HighLowUi;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.ui.AxisPanel;
import com.elixirtech.chart2.ui.ColorPanel;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.IWizard;
import javax.swing.BorderFactory;

class HighLowTab
extends TabComponent {
    public static final String BG_BUTTON = "bg-button";
    public static final String X_LABEL = "x-label";
    public static final String Y_LABEL = "y-label";
    private String m_Name;
    private ArchLayout m_Layout = new ArchLayout();
    private ColorPanel m_Background;
    private AxisPanel m_XAxisPanel;
    private AxisPanel m_YAxisPanel;
    private HighLowUi m_HighLowUi;

    public HighLowTab(String string) {
        this.m_Name = string;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(this.m_Layout);
        this.m_Background = new ColorPanel(Messages.getString("HighLowTab.PLOT_BACKGROUND"));
        this.m_XAxisPanel = new AxisPanel(Messages.getString("HighLowTab.X_AXIS"));
        this.m_YAxisPanel = new AxisPanel(Messages.getString("HighLowTab.Y_AXIS"));
        this.m_Background.build(this, "bg");
        this.m_XAxisPanel.build(this, "x");
        this.m_YAxisPanel.build(this, "y");
        this.m_Layout.stickTop(BG_BUTTON);
        this.m_Layout.putRight(BG_BUTTON, "x-name,y-name,bg-name", 10);
        this.m_Layout.alignBelow(X_LABEL, BG_BUTTON, 5);
        this.m_Layout.alignBelow(Y_LABEL, X_LABEL, 5);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getMessage() {
        return Messages.getString("HighLowTab.MESSAGE");
    }

    public void init(IChart iChart) {
        this.m_HighLowUi = ((HighLowType)iChart.getChartType()).getHighLowUi();
        this.m_Background.setColor(this.m_HighLowUi.getPlotBackground());
        this.m_XAxisPanel.setAxis(this.m_HighLowUi.getValueAxis());
        this.m_YAxisPanel.setAxis(this.m_HighLowUi.getKeyAxis());
    }

    @Override
    public void exited() {
        this.m_HighLowUi.setPlotBackground(this.m_Background.getColor());
        this.m_HighLowUi.setValueAxis(this.m_XAxisPanel.getAxis());
        this.m_HighLowUi.setKeyAxis(this.m_YAxisPanel.getAxis());
    }

    public void updatePanels(IWizard iWizard) {
        boolean bl = !iWizard.isReadOnly();
        this.m_Background.setEnabled(bl);
        this.m_XAxisPanel.setEnabled(bl);
        this.m_YAxisPanel.setEnabled(bl);
    }

    @Override
    public void performFinish() {
    }
}

