/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.I18N;
import com.elixirtech.chart2.model.Font;
import com.elixirtech.chart2.model.IntervalMarker;
import com.elixirtech.chart2.ui.ChartAction;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.Name;
import com.elixirtech.ui.FontChooserDialog;
import com.elixirtech.ui.JColorChooserEx;
import com.elixirtech.ui.NumberDocument;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jfree.chart.JFreeChart;

public class IntervalMarkerTab
extends TabComponent {
    public static String[] m_AnchorIDs = new String[]{"North", "South", "West", "East", "Northeast", "Northwest", "Southeast", "Southwest"};
    public static String[] m_AnchorResources = new String[]{"Position.North", "Position.South", "Position.West", "Position.East", "Position.Northeast", "Position.Northwest", "Position.Southeast", "Position.Southwest"};
    private JCheckBox m_EnableCheck;
    private JTextField m_Start;
    private JTextField m_End;
    private ArchLayout m_Layout = new ArchLayout();
    private JButton m_FontButton;
    private JButton m_ColorButton;
    private JTextField m_IntervalMakerLabel;
    private JSlider m_BackgroundAlphaSlider;
    private ColorSelector m_Background;
    private IntervalMarker m_IntervalMarker;
    private I18NComboBox m_Anchors;

    public IntervalMarkerTab() {
        this.buildUI();
    }

    @Override
    public String getMessage() {
        return Messages.getString("IntervalMarkerTab.MESSAGE");
    }

    @Override
    public String getName() {
        return Messages.getString("IntervalMarkerTab.TITLE");
    }

    @Override
    public void performFinish() {
    }

    public void setIntervalMaker(IntervalMarker intervalMarker) {
        this.m_IntervalMarker = intervalMarker;
        this.m_Background.setColor(this.m_IntervalMarker.getPaint());
        float f = this.m_IntervalMarker.getStart();
        float f2 = this.m_IntervalMarker.getEnd();
        this.m_Start.setText(Float.toString(f));
        this.m_End.setText(Float.toString(f2));
        String string = this.m_IntervalMarker.getLabel().getText();
        this.m_IntervalMakerLabel.setText(string);
        this.m_BackgroundAlphaSlider.setValue((int)(this.m_IntervalMarker.getAlpha() * 100.0f));
        boolean bl = this.m_IntervalMarker.isEnabled();
        this.m_EnableCheck.setSelected(bl);
        this.m_Anchors.setSelectedId(this.m_IntervalMarker.getLabelAnchor());
    }

    public IntervalMarker getIntervalMaker() {
        try {
            this.m_IntervalMarker.setStart(Float.parseFloat(this.m_Start.getText()));
        }
        catch (Exception exception) {
            this.m_IntervalMarker.setStart(0.0f);
        }
        try {
            this.m_IntervalMarker.setEnd(Float.parseFloat(this.m_End.getText()));
        }
        catch (Exception exception) {
            this.m_IntervalMarker.setEnd(0.0f);
        }
        float f = (float)this.m_BackgroundAlphaSlider.getValue() / 100.0f;
        this.m_IntervalMarker.setAlpha(f);
        this.m_IntervalMarker.getLabel().setText(this.m_IntervalMakerLabel.getText());
        this.m_IntervalMarker.setEnabled(this.m_EnableCheck.isSelected());
        this.m_IntervalMarker.setPaint(this.m_Background.getColor());
        this.m_IntervalMarker.setLabelAnchor(this.m_Anchors.getSelectedId());
        return this.m_IntervalMarker;
    }

    public void buildUI() {
        this.setLayout(this.m_Layout);
        this.m_EnableCheck = new JCheckBox(Messages.getString("IntervalMarkerTab.ENABLED"));
        this.add("enabled", this.m_EnableCheck);
        this.m_IntervalMakerLabel = new JTextField();
        JLabel jLabel = new JLabel(Messages.getString("IntervalMarkerTab.LABEL"));
        this.m_IntervalMakerLabel = SwingFactory.newTextField("interval-text", 20);
        this.m_FontButton = this.button(new FontAction());
        this.m_ColorButton = this.button(new FontColorAction());
        this.add("label", jLabel);
        this.add("interval-text", this.m_IntervalMakerLabel);
        this.add("interval-font", this.m_FontButton);
        this.add("interval-color", this.m_ColorButton);
        this.m_Layout.stickLeft("enabled", 5);
        this.m_Layout.stickTop("enabled", 5);
        this.m_Layout.stickLeft("label");
        this.m_Layout.putBelow("label", "enabled", 10);
        this.m_Layout.putRight("interval-text", "label", 5);
        this.m_Layout.putRight("interval-font", "interval-text", 2);
        this.m_Layout.putRight("interval-color", "interval-font", 2);
        this.m_Layout.vCenter("interval-text", "label");
        this.m_Layout.vCenter("interval-font", "interval-text");
        this.m_Layout.vCenter("interval-color", "interval-font");
        JLabel jLabel2 = new JLabel(Messages.getString("IntervalMarkerTab.LABEL_ANCHOR"));
        Name[] nameArray = I18NComboBox.buildNames(m_AnchorIDs, I18N.CHART_UI, m_AnchorResources);
        this.m_Anchors = I18NComboBox.apply(nameArray);
        this.add("anchor-lbl", jLabel2);
        this.add("anchor", this.m_Anchors);
        this.m_Layout.alignBelow("anchor-lbl", "label", 12);
        this.m_Layout.putRight("anchor", "anchor-lbl,label", 5);
        this.m_Layout.vCenter("anchor", "anchor-lbl");
        JLabel jLabel3 = new JLabel(Messages.getString("IntervalMarkerTab.START"));
        JLabel jLabel4 = new JLabel(Messages.getString("IntervalMarkerTab.END"));
        this.add("start-lbl", jLabel3);
        this.add("end-lbl", jLabel4);
        this.m_Start = SwingFactory.newTextField("start", 15);
        this.add(this.m_Start);
        this.m_End = SwingFactory.newTextField("end", 15);
        this.add(this.m_End);
        this.m_Start.setDocument(new NumberDocument());
        this.m_End.setDocument(new NumberDocument());
        RangeValueDocumentListener rangeValueDocumentListener = new RangeValueDocumentListener();
        this.m_Start.getDocument().addDocumentListener(rangeValueDocumentListener);
        this.m_End.getDocument().addDocumentListener(rangeValueDocumentListener);
        this.add("start", this.m_Start);
        this.add("end", this.m_End);
        this.m_Layout.alignBelow("start", "anchor", 5);
        this.m_Layout.stickLeft("start-lbl");
        this.m_Layout.vCenter("start-lbl", "start");
        this.m_Layout.alignBelow("end", "start", 2);
        this.m_Layout.stickLeft("end-lbl");
        this.m_Layout.vCenter("end-lbl", "end");
        JLabel jLabel5 = new JLabel(Messages.getString("IntervalMarkerTab.BACKGROUND"));
        this.add("bkgnd-lbl", jLabel5);
        this.m_Background = new ColorSelector("bkgnd");
        this.add("bkgnd", this.m_Background);
        this.m_Layout.alignBelow("bkgnd", "end", 4);
        this.m_Layout.stickLeft("bkgnd-lbl");
        this.m_Layout.vCenter("bkgnd-lbl", "bkgnd");
        JLabel jLabel6 = new JLabel(Messages.getString("IntervalMarkerTab.ALPHA"));
        this.m_BackgroundAlphaSlider = new JSlider(0, 0, 100, 50);
        this.m_BackgroundAlphaSlider.setMajorTickSpacing(10);
        this.m_BackgroundAlphaSlider.setMinorTickSpacing(1);
        this.m_BackgroundAlphaSlider.setPaintTicks(true);
        this.m_BackgroundAlphaSlider.setPaintTrack(true);
        this.m_BackgroundAlphaSlider.setPaintLabels(true);
        this.add("alpha-lbl", jLabel6);
        this.add("alpha", this.m_BackgroundAlphaSlider);
        this.m_Layout.alignBelow("alpha-lbl", "bkgnd-lbl", 25);
        this.m_Layout.putRight("alpha", "alpha-lbl,label", 5);
        this.m_Layout.stickRight("alpha");
        this.m_Layout.vCenter("alpha", "alpha-lbl");
    }

    protected JButton button(ChartAction chartAction) {
        JButton jButton = new JButton(chartAction);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_IntervalMakerLabel.setEnabled(bl);
        this.m_Start.setEnabled(bl);
        this.m_End.setEnabled(bl);
        this.m_BackgroundAlphaSlider.setEnabled(bl);
        this.m_FontButton.setEnabled(bl);
        this.m_ColorButton.setEnabled(bl);
        this.m_Anchors.setEnabled(bl);
        super.setEnabled(bl);
    }

    public void updatePanels(IWizard iWizard) {
        this.setEnabled(!iWizard.isReadOnly());
    }

    public static class ColorSelector
    extends JPanel {
        private ColorPaint m_ColorDisplay = new ColorPaint();
        private JTextField m_Text = new JTextField(15);
        private JButton m_ColorBtn = new JButton("...");
        private Color m_Paint;

        public ColorSelector(String string) {
            this.setName(string);
            this.setLayout(new BorderLayout(1, 4));
            this.add("Center", this.m_Text);
            JPanel jPanel = new JPanel(new BorderLayout(4, 4));
            this.m_ColorDisplay.setPreferredSize(new Dimension(25, 20));
            this.m_ColorDisplay.setBorder(BorderFactory.createEtchedBorder());
            jPanel.add("Center", this.m_ColorDisplay);
            jPanel.add("East", this.m_ColorBtn);
            this.add("East", jPanel);
            this.m_ColorBtn.addActionListener(new AL());
        }

        public void setColor(String string) {
            this.m_Paint = StandardColor.lookup(string);
            this.m_Text.setText(string);
            this.m_ColorDisplay.setBackground(this.m_Paint);
            this.m_ColorDisplay.setForeground(this.m_Paint);
        }

        public String getColor() {
            return this.m_Text.getText();
        }

        final class ColorPaint
        extends JPanel {
            ColorPaint() {
            }

            @Override
            public void print(Graphics graphics) {
                Color color = graphics.getColor();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics.setColor(color);
            }
        }

        final class AL
        implements ActionListener {
            AL() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ColorSelector.this.m_Paint = JColorChooser.showDialog(ColorSelector.this.m_Text, Messages.getString("IntervalMarkerTab.BACKGROUND_DIALOG"), ColorSelector.this.m_Paint);
                        if (ColorSelector.this.m_Paint != null) {
                            ColorSelector.this.setColor(StandardColor.getColorName(ColorSelector.this.m_Paint));
                        }
                    }
                });
            }
        }
    }

    private final class FontAction
    extends ChartAction {
        public FontAction() {
            super("Chart.Font");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Font font = IntervalMarkerTab.this.m_IntervalMarker.getLabel().getFont();
            if (font == null) {
                font = new Font(JFreeChart.DEFAULT_TITLE_FONT);
            }
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            java.awt.Font font2 = font.getAWTFont();
            FontChooserDialog fontChooserDialog = new FontChooserDialog((Frame)elixirFrame.getFrame(), font2);
            fontChooserDialog.setTitle(Messages.getString("IntervalMarkerTab.LABEL_Font"));
            fontChooserDialog.pack();
            fontChooserDialog.setLocationRelativeTo(elixirFrame.getFrame());
            elixirFrame.showModal(fontChooserDialog);
            if (fontChooserDialog.isOk()) {
                font2 = fontChooserDialog.getSelectedFont();
                String string = null;
                if (font != null) {
                    string = font.getFontColor();
                }
                font = new Font(font2);
                font.setFontColor(string);
                IntervalMarkerTab.this.m_IntervalMarker.getLabel().setFont(font);
            }
        }
    }

    private class FontColorAction
    extends ChartAction {
        public FontColorAction() {
            super("Chart.Color");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Font font = IntervalMarkerTab.this.m_IntervalMarker.getLabel().getFont();
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            String string = font != null ? font.getFontColor() : "Black";
            Color color = StandardColor.lookup(string);
            color = JColorChooserEx.showDialog(elixirFrame.getFrame(), Messages.getString("AxisPanel.LABEL_COLOR"), color);
            if (font == null) {
                font = new Font(JFreeChart.DEFAULT_TITLE_FONT);
            }
            font.setFontColor(StandardColor.getColorName(color));
        }
    }

    private final class RangeValueDocumentListener
    implements DocumentListener {
        private Color m_RangeValueColor;

        public RangeValueDocumentListener() {
            this.m_RangeValueColor = IntervalMarkerTab.this.m_Start.getForeground();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.showWithinRange();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.showWithinRange();
        }

        private void showWithinRange() {
            try {
                double d = Double.parseDouble(IntervalMarkerTab.this.m_Start.getText());
                double d2 = Double.parseDouble(IntervalMarkerTab.this.m_End.getText());
                if (d2 >= d) {
                    IntervalMarkerTab.this.m_Start.setForeground(this.m_RangeValueColor);
                    IntervalMarkerTab.this.m_End.setForeground(this.m_RangeValueColor);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            IntervalMarkerTab.this.m_Start.setForeground(Color.RED);
            IntervalMarkerTab.this.m_End.setForeground(Color.RED);
        }
    }
}

