/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.I18N;
import com.elixirtech.chart2.model.Legend;
import com.elixirtech.chart2.model.Painter;
import com.elixirtech.chart2.ui.ColorSelector;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.ui.OrderedEditableTable;
import com.elixirtech.ui.StandardPaint;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class LegendPaintTab
extends TabComponent
implements ActionListener {
    private Legend m_Legend;
    private PaintModel m_PaintModel;
    private JCheckBox m_AutoPaintSelection;
    private OrderedEditableTable m_PaintTable;
    private Color m_OriginalColor;

    public LegendPaintTab() {
        this.buildUI();
    }

    @Override
    public String getMessage() {
        return Messages.getString("LegendPaintTab.MESSAGE");
    }

    @Override
    public String getName() {
        return Messages.getString("LegendPaintTab.TITLE");
    }

    @Override
    public void performFinish() {
    }

    public void setLegend(Legend legend) {
        this.m_Legend = legend.deepCopy();
        Boolean bl = this.m_Legend.isCustomPaint();
        if (bl == null) {
            bl = Boolean.TRUE;
        }
        this.m_AutoPaintSelection.setSelected(bl == false);
        this.greyOut(bl == false);
        this.m_PaintModel.setLegend(this.m_Legend);
        this.m_PaintTable.repaint();
    }

    public void updateLegend(Legend legend) {
        this.stopTableEditing();
        legend.setCustomPaint(Boolean.valueOf(!this.m_AutoPaintSelection.isSelected()));
        legend.setPainterList(this.m_Legend.getPainterList());
    }

    public void buildUI() {
        this.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(Messages.getString("LegendPaintTab.LABEL"));
        this.m_AutoPaintSelection = new JCheckBox(Messages.getString("LegendPaintTab.AUTO"));
        this.m_AutoPaintSelection.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("West", jLabel);
        jPanel.add("East", this.m_AutoPaintSelection);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add("North", jPanel);
        this.m_PaintModel = new PaintModel(this.m_Legend);
        this.m_PaintTable = new PaintSelectionTable(this.m_PaintModel);
        this.m_OriginalColor = this.m_PaintTable.getTable().getBackground();
        this.add("Center", this.m_PaintTable);
    }

    public void updatePanels(IWizard iWizard) {
        boolean bl = !iWizard.isReadOnly();
        this.m_AutoPaintSelection.setEnabled(bl);
        this.m_PaintTable.setEnabled(bl);
    }

    public void greyOut(boolean bl) {
        if (bl) {
            this.m_PaintTable.setEnabled(false);
            this.m_PaintTable.getTable().setBackground(Color.LIGHT_GRAY);
        } else {
            this.m_PaintTable.setEnabled(true);
            this.m_PaintTable.getTable().setBackground(this.m_OriginalColor);
        }
        this.m_PaintTable.repaint();
    }

    public void stopTableEditing() {
        JTable jTable = this.m_PaintTable.getTable();
        if (jTable.isEditing()) {
            jTable.getCellEditor().stopCellEditing();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.greyOut(this.m_AutoPaintSelection.isSelected());
    }

    public static class PaintModel
    extends ElxTableModel {
        private static String[] COLUMNS = new String[]{"LegendPaintTab.COLOR", "LegendPaintTab.PATTERN", "LegendPaintTab.ENABLED"};
        private Legend m_Legend;

        public PaintModel(Legend legend) {
            super(Messages.RESOURCE_BUNDLE, COLUMNS);
            this.m_Legend = legend;
        }

        @Override
        public int getRowCount() {
            if (this.m_Legend == null) {
                return 0;
            }
            return this.m_Legend.getPainterCount();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (2 == n) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Painter painter = this.m_Legend.getPainter(n);
            if (n2 == 0) {
                return painter.getColor();
            }
            if (n2 == 1) {
                return painter.getPattern();
            }
            if (n2 == 2) {
                return painter.isEnabled();
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Painter painter = this.m_Legend.getPainter(n);
            if (n2 == 0) {
                painter.setColor((String)object);
            } else if (n2 == 1) {
                painter.setPattern((String)object);
            } else if (n2 == 2) {
                painter.setEnabled((Boolean)object);
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public void setLegend(Legend legend) {
            this.m_Legend = legend;
        }
    }

    public class PaintSelectionTable
    extends OrderedEditableTable {
        Painter m_Copy;

        public PaintSelectionTable(TableModel tableModel) {
            super(tableModel, false, true);
            this.setAutoResizeMode(3);
            TableColumn tableColumn = this.getTable().getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(new ColorSelector());
            tableColumn.setCellEditor(new ColorSelector());
            TableColumn tableColumn2 = this.getTable().getColumnModel().getColumn(1);
            tableColumn2.setCellRenderer(new PatternSelector());
            tableColumn2.setCellEditor(new PatternSelector());
            JTable jTable = this.getTable();
            jTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            jTable.setRowHeight(jTable.getRowHeight() + 4);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = -1;
            if ("plus".equals(string)) {
                this.addPainter();
            } else if ("minus".equals(string)) {
                n = this.removePainter();
            } else if ("copy".equals(string)) {
                this.copy();
            } else if ("paste".equals(string)) {
                this.paste();
            } else if ("up".equals(string)) {
                n = this.moveUp();
            } else if ("down".equals(string)) {
                n = this.moveDown();
            }
            LegendPaintTab.this.m_PaintModel.fireTableDataChanged();
            if (n >= 0) {
                this.m_Table.setRowSelectionInterval(n, n);
            }
        }

        private int moveDown() {
            int n = this.getSelectedRow();
            Painter painter = (Painter)LegendPaintTab.this.m_Legend.getPainterList().remove(n);
            LegendPaintTab.this.m_Legend.getPainterList().add(++n, painter);
            return n;
        }

        private int moveUp() {
            int n = this.getSelectedRow();
            Painter painter = (Painter)LegendPaintTab.this.m_Legend.getPainterList().remove(n);
            LegendPaintTab.this.m_Legend.getPainterList().add(--n, painter);
            return n;
        }

        private void copy() {
            int n = this.getSelectedRow();
            this.m_Copy = (Painter)LegendPaintTab.this.m_Legend.getPainterList().get(n);
        }

        public int addPainter() {
            Painter painter = new Painter();
            painter.setColor("red");
            painter.setPattern("none");
            LegendPaintTab.this.m_Legend.addPainter(new Painter());
            return LegendPaintTab.this.m_Legend.getPainterCount() - 1;
        }

        public int removePainter() {
            int n = this.getSelectedRow();
            LegendPaintTab.this.m_Legend.getPainterList().remove(n);
            int n2 = LegendPaintTab.this.m_Legend.getPainterCount();
            if (n >= n2) {
                --n;
            }
            return n;
        }

        public void paste() {
            if (this.m_Copy != null) {
                LegendPaintTab.this.m_Legend.addPainter(this.m_Copy.deepCopy());
            }
        }
    }

    static class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private ArrayList<ImageIcon> m_Icons;

        public ComboBoxRenderer(ArrayList<ImageIcon> arrayList) {
            this.m_Icons = arrayList;
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            int n2 = this.m_Icons.indexOf(object);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            ImageIcon imageIcon = this.m_Icons.get(n2);
            String string = imageIcon.getDescription();
            this.setIcon(imageIcon);
            if (imageIcon != null) {
                this.setText(string);
                this.setFont(jList.getFont());
            }
            return this;
        }
    }

    public static class PatternSelector
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        private ArrayList<String> m_PatternNames = new ArrayList();
        private ArrayList<ImageIcon> m_Icons = new ArrayList();
        private JPanel m_DisplayPanel = new JPanel(new BorderLayout());
        private JLabel m_Label = new JLabel();
        private JTextField m_Selected = new JTextField();
        private JComboBox m_Patterns;

        public PatternSelector() {
            Collection<StandardPaint> collection = StandardPaint.getPaints();
            StandardPaint[] standardPaintArray = collection.toArray(new StandardPaint[collection.size()]);
            for (int i = 0; i < standardPaintArray.length; ++i) {
                this.m_PatternNames.add(standardPaintArray[i].getName());
                this.m_Icons.add(new ImageIcon(standardPaintArray[i].getIcon(), I18N.CHART_UI.getString("StandardPaint." + this.m_PatternNames.get(i))));
            }
            this.m_Patterns = new JComboBox<ImageIcon>(this.m_Icons.toArray(new ImageIcon[this.m_PatternNames.size()]));
            this.m_Patterns.setRenderer(new ComboBoxRenderer(this.m_Icons));
            this.m_DisplayPanel.add("West", this.m_Label);
            this.m_DisplayPanel.add("Center", this.m_Selected);
            this.m_Selected.setBorder(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Serializable serializable;
            if (bl) {
                this.m_Selected.setForeground(jTable.getSelectionForeground());
                this.m_Selected.setBackground(jTable.getSelectionBackground());
                this.m_DisplayPanel.setBackground(jTable.getSelectionBackground());
            } else {
                this.m_Selected.setForeground(jTable.getForeground());
                Color color = jTable.getBackground();
                if (n % 2 == 0) {
                    color = UIManager.getColor("Table.alternateRowColor");
                }
                serializable = new Color(color.getRed(), color.getGreen(), color.getBlue());
                this.m_Selected.setBackground((Color)serializable);
                this.m_DisplayPanel.setBackground((Color)serializable);
            }
            int n3 = this.m_PatternNames.indexOf(object);
            serializable = this.m_Icons.get(n3);
            this.m_Label.setIcon((Icon)((Object)serializable));
            this.m_Selected.setText(((ImageIcon)serializable).getDescription());
            return this.m_DisplayPanel;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            int n3 = this.m_PatternNames.indexOf(object);
            if (n3 == -1) {
                n3 = this.m_PatternNames.indexOf("None");
            }
            this.m_Patterns.setSelectedIndex(n3);
            return this.m_Patterns;
        }

        @Override
        public Object getCellEditorValue() {
            int n = this.m_Patterns.getSelectedIndex();
            if (n == -1) {
                return "None";
            }
            return this.m_PatternNames.get(n);
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return ((MouseEvent)eventObject).getClickCount() >= 2;
            }
            return true;
        }
    }
}

