/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.model.MeterInterval;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.ui.ColorViewPanel;
import com.elixirtech.ui.EscapableDialog;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.UnitField;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class MeterIntervalDialog
extends EscapableDialog
implements ActionListener {
    private static final String NAME = "name";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String FILL = "fill";
    private static final String LINE = "line";
    private static final String WIDTH = "width";
    private static final String OK = "ok";
    private static final String CANCEL = "cancel";
    private static final String LABELS = "name-label,min-label,max-label,fill-label,line-label,width-label";
    private ArchLayout m_Layout;
    private MeterInterval m_MeterInterval;
    private JTextField m_Name = new JTextField();
    private JTextField m_Min = new JTextField();
    private JTextField m_Max = new JTextField();
    private ColorViewPanel m_Fill = new ColorViewPanel();
    private ColorViewPanel m_Line = new ColorViewPanel();
    private UnitField m_Width = new UnitField();
    private JButton m_Ok = SwingFactory.newOkButton();
    private JButton m_Cancel = SwingFactory.newCancelButton();
    private boolean m_IsFinished;

    public MeterIntervalDialog(JFrame jFrame, MeterInterval meterInterval) {
        super(jFrame, Messages.getString("MeterIntervalDialog.METER_INTERVAL"), true);
        this.m_MeterInterval = meterInterval;
        this.setDefaultCloseOperation(2);
        this.m_Layout = new ArchLayout();
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(this.m_Layout);
        jComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.label(jComponent, NAME, Messages.getString("MeterIntervalDialog.NAME"));
        this.label(jComponent, MIN, Messages.getString("MeterIntervalDialog.MINIMUM"));
        this.label(jComponent, MAX, Messages.getString("MeterIntervalDialog.MAXIMUM"));
        this.label(jComponent, FILL, Messages.getString("MeterIntervalDialog.FILL"));
        this.label(jComponent, LINE, Messages.getString("MeterIntervalDialog.LINE"));
        this.label(jComponent, WIDTH, Messages.getString("MeterIntervalDialog.WIDTH"));
        jComponent.add(NAME, this.m_Name);
        jComponent.add(MIN, this.m_Min);
        jComponent.add(MAX, this.m_Max);
        jComponent.add(FILL, this.m_Fill);
        jComponent.add(LINE, this.m_Line);
        jComponent.add(WIDTH, this.m_Width);
        jComponent.add(OK, this.m_Ok);
        jComponent.add(CANCEL, this.m_Cancel);
        this.m_Layout.stickTop(NAME);
        this.m_Layout.putRight(NAME, LABELS, 10);
        this.m_Layout.alignBelow(MIN, NAME);
        this.m_Layout.alignBelow(MAX, MIN);
        this.m_Layout.alignBelow(FILL, MAX);
        this.m_Layout.alignBelow(LINE, FILL);
        this.m_Layout.alignBelow(WIDTH, LINE);
        this.m_Layout.stickRight(NAME);
        this.m_Layout.stickRight(MIN);
        this.m_Layout.stickRight(MAX);
        this.m_Layout.stickRight(FILL);
        this.m_Layout.stickRight(LINE);
        this.m_Layout.stickRight(WIDTH);
        this.m_Layout.putBelow(OK, WIDTH, 5);
        this.m_Layout.putBelow(CANCEL, WIDTH, 5);
        this.m_Layout.stickRight(CANCEL);
        this.m_Layout.putLeft(OK, CANCEL, -5);
        this.m_Name.setText(this.m_MeterInterval.getName());
        this.m_Min.setText(String.valueOf(this.m_MeterInterval.getMin()));
        this.m_Max.setText(String.valueOf(this.m_MeterInterval.getMax()));
        this.m_Fill.setColor(this.m_MeterInterval.getFillColor());
        this.m_Line.setColor(this.m_MeterInterval.getLineColor());
        this.m_Width.setValue(this.m_MeterInterval.getLineWidth());
        this.m_Ok.addActionListener(this);
        this.m_Cancel.addActionListener(this);
        this.pack();
        Dimension dimension = this.getPreferredSize();
        dimension.width = 280;
        this.setSize(dimension);
        this.setLocationRelativeTo(jFrame);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_Ok) {
            try {
                this.m_MeterInterval.setName(this.m_Name.getText());
                this.m_MeterInterval.setMin(Double.parseDouble(this.m_Min.getText()));
                this.m_MeterInterval.setMax(Double.parseDouble(this.m_Max.getText()));
                this.m_MeterInterval.setFillColor(this.m_Fill.getColor());
                this.m_MeterInterval.setLineColor(this.m_Line.getColor());
                this.m_MeterInterval.setLineWidth(this.m_Width.getIntValue());
                this.m_IsFinished = true;
                this.dispose();
            }
            catch (NumberFormatException numberFormatException) {
                ElixirJ.userError(Messages.getString("MeterIntervalDialog.UNABLE_TO_PARSE_NUMBER") + String.valueOf(numberFormatException));
            }
        } else if (object == this.m_Cancel) {
            this.dispose();
        }
    }

    public boolean isFinished() {
        return this.m_IsFinished;
    }

    private void label(JComponent jComponent, String string, String string2) {
        String string3 = string + "-label";
        jComponent.add(string3, new JLabel(string2));
        this.m_Layout.vCenter(string3, string);
        this.m_Layout.stickLeft(string3);
    }
}

