/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.MeterType;
import com.elixirtech.chart2.model.MeterUi;
import com.elixirtech.chart2.ui.DataTab;
import com.elixirtech.chart2.ui.LegendTab;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.MeterTab;
import com.elixirtech.chart2.ui.TitleTab;
import com.elixirtech.chart2.ui.TypeSpecificPage;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.wizard.IFinishPage;

public class MeterPage
extends TypeSpecificPage
implements IFinishPage {
    public static final String NAME = "Meter";
    private DataTab m_DataTab;
    private MeterTab m_MeterTab;
    private TitleTab m_TitleTab;
    private LegendTab m_LegendTab;

    public MeterPage() {
        super(NAME);
        this.setTitle(Messages.getString("MeterPage.METER"));
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            IChart iChart = this.getChart();
            this.ensureChartType(iChart);
            String string = this.getTypeTitle(iChart);
            this.setTitle(string);
            this.m_Tabs.setTitleAt(1, string);
            this.updatePanels();
            if (!this.m_Initialized) {
                MeterType meterType = (MeterType)iChart.getChartType();
                this.m_DataTab.setControlSource(meterType.getControlSource());
                this.m_TitleTab.setTitle(meterType.getTitle());
                this.m_LegendTab.setLegend(meterType.getLegend());
                super.init(iChart);
            }
        }
        super.setVisible(bl);
    }

    protected void updatePanels() {
        this.m_DataTab.updatePanels(this.m_Wizard);
        this.m_MeterTab.updatePanels(this.m_Wizard);
        this.m_TitleTab.updatePanels(this.m_Wizard);
        this.m_LegendTab.updatePanels(this.m_Wizard);
        this.m_ScriptTab.updatePanels(this.m_Wizard);
    }

    protected String getTypeTitle(IChart iChart) {
        return Messages.getString("MeterPage.METER");
    }

    @Override
    protected void buildTabs() {
        this.m_DataTab = new DataTab(Messages.getString("MeterPage.DATA"), 7, false){

            @Override
            public void exited() {
                MeterType meterType = (MeterType)MeterPage.this.getChart().getChartType();
                meterType.setControlSource(this.getControlSource());
            }
        };
        this.addTab(this.m_DataTab);
        this.m_MeterTab = new MeterTab(this);
        this.addTab(this.m_MeterTab);
        this.m_TitleTab = new TitleTab(){

            @Override
            public void exited() {
                ChartType chartType = MeterPage.this.getChart().getChartType();
                chartType.setTitle(MeterPage.this.m_TitleTab.getTitle());
            }
        };
        this.addTab(this.m_TitleTab);
        this.m_LegendTab = new LegendTab(){

            @Override
            public void exited() {
                ChartType chartType = MeterPage.this.getChart().getChartType();
                chartType.setLegend(MeterPage.this.m_LegendTab.getLegend());
            }
        };
        this.addTab(this.m_LegendTab);
        super.buildTabs();
    }

    @Override
    protected void applyChanges(IChart iChart) {
        if (this.m_Current != null) {
            this.m_Current.exited();
        }
        super.applyChanges(iChart);
        MeterType meterType = (MeterType)iChart.getChartType();
        meterType.setControlSource(this.m_DataTab.getControlSource());
        meterType.setTitle(this.m_TitleTab.getTitle());
        meterType.setLegend(this.m_LegendTab.getLegend());
    }

    private ControlSource initData() {
        ControlSource controlSource = new ControlSource();
        controlSource.setType("Field");
        return controlSource;
    }

    @Override
    protected void ensureChartType(IChart iChart) {
        if (!(iChart.getChartType() instanceof MeterType)) {
            MeterType meterType = new MeterType();
            meterType.setControlSource(this.initData());
            MeterUi meterUi = new MeterUi();
            meterUi.init();
            meterType.setMeterUi(meterUi);
            iChart.setChartType((ChartType)meterType);
        }
    }
}

