/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.MeterInterval;
import com.elixirtech.chart2.model.MeterType;
import com.elixirtech.chart2.model.MeterUi;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.MeterIntervalDialog;
import com.elixirtech.chart2.ui.MeterPage;
import com.elixirtech.ui.ColorViewPanel;
import com.elixirtech.ui.EditableTable;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextField;

class MeterTab
extends TabComponent
implements ActionListener {
    private static final String MIN_LABEL = "min-label";
    private static final String MAX_LABEL = "max-label";
    private static final String UNITS_LABEL = "units-label";
    private static final String BG_LABEL = "bg-label";
    private static final String VAL_LABEL = "val-label";
    private static final String NEEDLE_LABEL = "needle-label";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String BG = "bg";
    private static final String VAL = "val";
    private static final String NEEDLE = "needle";
    private static final String UNITS = "units";
    private static final String TABLE = "table";
    private MeterPage m_Page;
    private JTextField m_Min = this.textField();
    private JTextField m_Max = this.textField();
    private ColorViewPanel m_Paint = new ColorViewPanel();
    private ColorViewPanel m_ValuePaint = new ColorViewPanel();
    private ColorViewPanel m_NeedlePaint = new ColorViewPanel();
    private EditableTable m_Table;
    private IntervalModel m_Model;
    private JTextField m_Units = new JTextField(20);
    private List<MeterInterval> m_Intervals;
    private boolean m_Initialized;
    private NumberFormat m_Format = NumberFormat.getNumberInstance();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(MeterTab.class);
    private static final String[] COLUMNS = new String[]{"MeterTab.NAME", "MeterTab.MIN", "MeterTab.MAX"};

    public MeterTab(MeterPage meterPage) {
        this.m_Page = meterPage;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ArchLayout archLayout = new ArchLayout();
        this.setLayout(archLayout);
        this.m_Intervals = new ArrayList<MeterInterval>();
        this.m_Model = new IntervalModel();
        this.m_Table = new EditableTable(this.m_Model, true, false);
        this.m_Table.setAutoResizeMode(4);
        this.m_Table.addActionListener(this);
        Dimension dimension = this.m_Min.getPreferredSize();
        dimension.width = 80;
        this.m_Min.setPreferredSize(dimension);
        this.m_Max.setPreferredSize(dimension);
        this.add(MIN_LABEL, new JLabel(Messages.getString("MeterTab.MINIMUM")));
        this.add(MAX_LABEL, new JLabel(Messages.getString("MeterTab.MAXIMUM")));
        this.add(UNITS_LABEL, new JLabel(Messages.getString("MeterTab.UNITS")));
        this.add(BG_LABEL, new JLabel(Messages.getString("MeterTab.BACKGROUND")));
        this.add(VAL_LABEL, new JLabel(Messages.getString("MeterTab.VALUE")));
        this.add(NEEDLE_LABEL, new JLabel(Messages.getString("MeterTab.NEEDLE")));
        this.add(MIN, this.m_Min);
        this.add(MAX, this.m_Max);
        this.add(UNITS, this.m_Units);
        this.add(BG, this.m_Paint);
        this.add(VAL, this.m_ValuePaint);
        this.add(NEEDLE, this.m_NeedlePaint);
        this.add(TABLE, this.m_Table);
        archLayout.vCenter(MIN_LABEL, MIN);
        archLayout.vCenter(MAX_LABEL, MAX);
        archLayout.vCenter(BG_LABEL, BG);
        archLayout.vCenter(VAL_LABEL, VAL);
        archLayout.vCenter(NEEDLE_LABEL, NEEDLE);
        archLayout.vCenter(UNITS_LABEL, UNITS);
        archLayout.stickLeft(MIN_LABEL);
        archLayout.stickLeft(BG_LABEL);
        archLayout.stickLeft(VAL_LABEL);
        archLayout.stickLeft(NEEDLE_LABEL);
        archLayout.stickTop(MIN);
        archLayout.stickTop(MAX);
        archLayout.stickTop(UNITS);
        archLayout.putRight(MIN, "min-label,bg-label,val-label,needle-label", 10);
        archLayout.putRight(MAX_LABEL, MIN, 10);
        archLayout.putRight(MAX, MAX_LABEL, 10);
        archLayout.putRight(UNITS_LABEL, MAX, 10);
        archLayout.putRight(UNITS, UNITS_LABEL, 10);
        archLayout.alignBelow(BG, MIN, 3);
        archLayout.alignBelow(VAL, BG, 3);
        archLayout.alignBelow(NEEDLE, VAL, 3);
        archLayout.stickRight(BG);
        archLayout.stickRight(VAL);
        archLayout.stickRight(NEEDLE);
        archLayout.stickRight(UNITS);
        archLayout.putBelow(TABLE, NEEDLE, 5);
        archLayout.stickLeft(TABLE);
        archLayout.stickRight(TABLE);
        archLayout.stickBottom(TABLE);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    @Override
    public void entered() {
        if (!this.m_Initialized) {
            IChart iChart = this.m_Page.getChart();
            MeterType meterType = (MeterType)iChart.getChartType();
            MeterUi meterUi = meterType.getMeterUi();
            this.m_Min.setText(this.m_Format.format(meterUi.getRangeMin()));
            this.m_Max.setText(this.m_Format.format(meterUi.getRangeMax()));
            this.m_Units.setText(meterUi.getUnit());
            this.m_Paint.setColor(StandardColor.lookup(meterUi.getPlotBackground()));
            this.m_ValuePaint.setColor(StandardColor.lookup(meterUi.getValueColor()));
            this.m_NeedlePaint.setColor(StandardColor.lookup(meterUi.getNeedleColor()));
            int n = meterUi.getIntervalCount();
            try {
                for (int i = 0; i < n; ++i) {
                    MeterInterval meterInterval = meterUi.getInterval(i);
                    this.m_Intervals.add((MeterInterval)meterInterval.shallowCopy());
                }
            }
            catch (Exception exception) {
                m_Log.error((Object)(Messages.getString("MeterTab.ERROR1") + String.valueOf(exception)), (Throwable)exception);
            }
            this.m_Model.fireTableDataChanged();
            this.m_Initialized = true;
        }
    }

    @Override
    public void exited() {
        if (!this.m_Initialized) {
            return;
        }
        IChart iChart = this.m_Page.getChart();
        MeterType meterType = (MeterType)iChart.getChartType();
        MeterUi meterUi = meterType.getMeterUi();
        String string = null;
        try {
            string = Messages.getString("MeterTab.OVERALL_MIN");
            meterUi.setRangeMin(this.m_Format.parse(this.m_Min.getText()).doubleValue());
            string = Messages.getString("MeterTab.OVERALL_MAX");
            meterUi.setRangeMax(this.m_Format.parse(this.m_Max.getText()).doubleValue());
        }
        catch (ParseException parseException) {
            ElixirJ.error(Messages.getString("MeterTab.ERROR2") + string);
        }
        meterUi.setUnit(this.m_Units.getText());
        meterUi.setPlotBackground(StandardColor.getColorName(this.m_Paint.getColor()));
        meterUi.setValueColor(StandardColor.getColorName(this.m_ValuePaint.getColor()));
        meterUi.setNeedleColor(StandardColor.getColorName(this.m_NeedlePaint.getColor()));
        meterUi.removeAllIntervals();
        meterUi.addAllIntervals(this.m_Intervals);
    }

    public void updatePanels(IWizard iWizard) {
        boolean bl = !iWizard.isReadOnly();
        this.m_Min.setEnabled(bl);
        this.m_Max.setEnabled(bl);
        this.m_Paint.setEnabled(bl);
        this.m_ValuePaint.setEnabled(bl);
        this.m_NeedlePaint.setEnabled(bl);
        this.m_Table.setEnabled(bl);
        this.m_Units.setEnabled(bl);
    }

    @Override
    public String getName() {
        return Messages.getString("MeterTab.METER");
    }

    @Override
    public String getMessage() {
        return Messages.getString("MeterTab.MESSAGE");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("plus".equals(string)) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            MeterInterval meterInterval = new MeterInterval();
            MeterIntervalDialog meterIntervalDialog = new MeterIntervalDialog(elixirFrame.getFrame(), meterInterval);
            elixirFrame.showModal(meterIntervalDialog);
            if (meterIntervalDialog.isFinished()) {
                int n = this.m_Intervals.size();
                this.m_Intervals.add(meterInterval);
                this.m_Model.fireTableRowsInserted(n, n);
            }
        } else if ("edit".equals(string)) {
            int n = this.m_Table.getSelectedRow();
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            MeterInterval meterInterval = this.m_Intervals.get(n);
            MeterIntervalDialog meterIntervalDialog = new MeterIntervalDialog(elixirFrame.getFrame(), meterInterval);
            elixirFrame.showModal(meterIntervalDialog);
            if (meterIntervalDialog.isFinished()) {
                this.m_Model.fireTableRowsUpdated(n, n);
            }
        } else if ("minus".equals(string)) {
            int[] nArray = this.m_Table.getSelectedRows();
            ArrayList<MeterInterval> arrayList = new ArrayList<MeterInterval>();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(this.m_Intervals.get(nArray[i]));
            }
            this.m_Intervals.removeAll(arrayList);
            this.m_Model.fireTableDataChanged();
        }
    }

    @Override
    public void performFinish() {
    }

    private JTextField textField() {
        JTextField jTextField = new JTextField();
        jTextField.setHorizontalAlignment(4);
        return jTextField;
    }

    private class IntervalModel
    extends ElxTableModel {
        public IntervalModel() {
            super(Messages.RESOURCE_BUNDLE, COLUMNS);
        }

        @Override
        public int getRowCount() {
            return MeterTab.this.m_Intervals.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            MeterInterval meterInterval = MeterTab.this.m_Intervals.get(n);
            switch (n2) {
                case 0: {
                    return meterInterval.getName();
                }
                case 1: {
                    return meterInterval.getMin();
                }
                case 2: {
                    return meterInterval.getMax();
                }
            }
            return null;
        }
    }
}

